# Microsoft.AspNetCore.Mvc.ApplicationModels

``` diff
 namespace Microsoft.AspNetCore.Mvc.ApplicationModels {
-    [DebuggerDisplayAttribute("ApplicationModel: Controllers: {Controllers.Count}, Filters: {Filters.Count}")]
-    public class ApplicationModel : IApiExplorerModel, IFilterModel, IPropertyModel
+    [DebuggerDisplayAttribute("Type = {GetType().Name}, Controllers = {Controllers.Count}, Filters = {Filters.Count}")]
+    public class ApplicationModel : IApiExplorerModel, IFilterModel, IPropertyModel
-    [DebuggerDisplayAttribute("PageHandlerModel: Name={Name}")]
-    public class PageHandlerModel : ICommonModel, IPropertyModel
+    [DebuggerDisplayAttribute("Type = {GetType().Name}, Name = {Name}")]
+    public class PageHandlerModel : ICommonModel, IPropertyModel
-    [DebuggerDisplayAttribute("PageParameterModel: Name={ParameterName}")]
-    public class PageParameterModel : ParameterModelBase, IBindingModel, ICommonModel, IPropertyModel
+    [DebuggerDisplayAttribute("Type = {GetType().Name}, Name = {ParameterName}")]
+    public class PageParameterModel : ParameterModelBase, IBindingModel, ICommonModel, IPropertyModel
-    [DebuggerDisplayAttribute("PagePropertyModel: Name={PropertyName}")]
-    public class PagePropertyModel : ParameterModelBase, ICommonModel, IPropertyModel
+    [DebuggerDisplayAttribute("Type = {GetType().Name}, Name = {PropertyName}")]
+    public class PagePropertyModel : ParameterModelBase, ICommonModel, IPropertyModel
-    [DebuggerDisplayAttribute("ParameterModel: Name={ParameterName}")]
-    public class ParameterModel : ParameterModelBase, ICommonModel, IPropertyModel
+    [DebuggerDisplayAttribute("Type = {GetType().Name}, Name = {ParameterName}")]
+    public class ParameterModel : ParameterModelBase, ICommonModel, IPropertyModel
-    [DebuggerDisplayAttribute("PropertyModel: Name={PropertyName}")]
-    public class PropertyModel : ParameterModelBase, IBindingModel, ICommonModel, IPropertyModel
+    [DebuggerDisplayAttribute("Type = {GetType().Name}, Name = {PropertyName}")]
+    public class PropertyModel : ParameterModelBase, IBindingModel, ICommonModel, IPropertyModel
 }
```

