# Microsoft.AspNetCore.Mvc

``` diff
 namespace Microsoft.AspNetCore.Mvc {
     [ControllerAttribute]
     public abstract class ControllerBase {
-        public IModelMetadataProvider MetadataProvider { get; set; }
+        [DebuggerBrowsableAttribute(0)]
+        public IModelMetadataProvider MetadataProvider { get; set; }
-        public IModelBinderFactory ModelBinderFactory { get; set; }
+        [DebuggerBrowsableAttribute(0)]
+        public IModelBinderFactory ModelBinderFactory { get; set; }
-        public IObjectModelValidator ObjectValidator { get; set; }
+        [DebuggerBrowsableAttribute(0)]
+        public IObjectModelValidator ObjectValidator { get; set; }
-        public ProblemDetailsFactory ProblemDetailsFactory { get; set; }
+        [DebuggerBrowsableAttribute(0)]
+        public ProblemDetailsFactory ProblemDetailsFactory { get; set; }
-        public IUrlHelper Url { get; set; }
+        [DebuggerBrowsableAttribute(0)]
+        public IUrlHelper Url { get; set; }
     }
-    public class ControllerContext : ActionContext
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    public class ControllerContext : ActionContext
-    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
-    public class RequestFormLimitsAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter {
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    public class RequestFormLimitsAttribute : Attribute, IFilterFactory, IFilterMetadata, IFormOptionsMetadata, IOrderedFilter {
+        bool? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.BufferBody { get; }
+        long? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.BufferBodyLengthLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.KeyLengthLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.MemoryBufferThreshold { get; }
+        long? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.MultipartBodyLengthLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.MultipartBoundaryLengthLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.MultipartHeadersCountLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.MultipartHeadersLengthLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.ValueCountLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.ValueLengthLimit { get; }
     }
-    [AttributeUsageAttribute(68, AllowMultiple=true, Inherited=true)]
-    [DebuggerDisplayAttribute("ServiceFilter: Type={ServiceType} Order={Order}")]
-    public class ServiceFilterAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter
+    [AttributeUsageAttribute(68, AllowMultiple=true, Inherited=true)]
+    [DebuggerDisplayAttribute("Type = {ServiceType}, Order = {Order}")]
+    public class ServiceFilterAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter
-    [DebuggerDisplayAttribute("ServiceFilter: Type={ServiceType} Order={Order}")]
-    public class ServiceFilterAttribute<TFilter> : ServiceFilterAttribute where TFilter : IFilterMetadata
+    [DebuggerDisplayAttribute("Type = {ServiceType}, Order = {Order}")]
+    public class ServiceFilterAttribute<TFilter> : ServiceFilterAttribute where TFilter : IFilterMetadata
-    [AttributeUsageAttribute(68, AllowMultiple=true, Inherited=true)]
-    [DebuggerDisplayAttribute("TypeFilter: Type={ImplementationType} Order={Order}")]
-    public class TypeFilterAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter
+    [AttributeUsageAttribute(68, AllowMultiple=true, Inherited=true)]
+    [DebuggerDisplayAttribute("Type = {ImplementationType}, Order = {Order}")]
+    public class TypeFilterAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter
 }
```

