# Microsoft.Extensions.DependencyInjection

``` diff
 namespace Microsoft.Extensions.DependencyInjection {
     public static class ComponentServiceCollectionExtensions {
-        [RequiresUnreferencedCodeAttribute("Server-side Blazor does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IServerSideBlazorBuilder AddServerSideBlazor(this IServiceCollection services, Action<CircuitOptions>? configure = null);
+        [RequiresUnreferencedCodeAttribute("Server-side Blazor does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IServerSideBlazorBuilder AddServerSideBlazor(this IServiceCollection services, Action<CircuitOptions>? configure = null);
     }
     public static class IdentityServiceCollectionExtensions {
-        [RequiresUnreferencedCodeAttribute("Identity middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IdentityBuilder AddIdentity<TUser, TRole>(this IServiceCollection services) where TUser : class where TRole : class;
+        [RequiresUnreferencedCodeAttribute("Identity middleware does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IdentityBuilder AddIdentity<TUser, TRole>(this IServiceCollection services) where TUser : class where TRole : class;
-        [RequiresUnreferencedCodeAttribute("Identity middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IdentityBuilder AddIdentity<TUser, TRole>(this IServiceCollection services, Action<IdentityOptions> setupAction) where TUser : class where TRole : class;
+        [RequiresUnreferencedCodeAttribute("Identity middleware does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IdentityBuilder AddIdentity<TUser, TRole>(this IServiceCollection services, Action<IdentityOptions> setupAction) where TUser : class where TRole : class;
     }
+    public interface IRazorComponentsBuilder {
+        IServiceCollection Services { get; }
+    }
-    public interface IServerSideBlazorBuilder {
+    public interface IServerSideBlazorBuilder : IRazorComponentsBuilder {
+        IServiceCollection IRazorComponentsBuilder.Services { get; }
-        IServiceCollection Services { get; }
+        new IServiceCollection Services { get; }
     }
     public static class MetricsServiceExtensions {
+        public static IServiceCollection AddMetrics(this IServiceCollection services, Action<IMetricsBuilder> configure);
     }
     public static class MvcRazorPagesMvcCoreBuilderExtensions {
-        [RequiresUnreferencedCodeAttribute("Razor Pages does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IMvcCoreBuilder AddRazorPages(this IMvcCoreBuilder builder);
+        [RequiresUnreferencedCodeAttribute("Razor Pages does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcCoreBuilder AddRazorPages(this IMvcCoreBuilder builder);
     }
     public static class MvcServiceCollectionExtensions {
-        [RequiresUnreferencedCodeAttribute("MVC does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IMvcBuilder AddControllers(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddControllers(this IServiceCollection services);
-        [RequiresUnreferencedCodeAttribute("MVC does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IMvcBuilder AddControllers(this IServiceCollection services, Action<MvcOptions>? configure);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddControllers(this IServiceCollection services, Action<MvcOptions>? configure);
-        [RequiresUnreferencedCodeAttribute("MVC does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IMvcBuilder AddControllersWithViews(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddControllersWithViews(this IServiceCollection services);
-        [RequiresUnreferencedCodeAttribute("MVC does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IMvcBuilder AddControllersWithViews(this IServiceCollection services, Action<MvcOptions>? configure);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddControllersWithViews(this IServiceCollection services, Action<MvcOptions>? configure);
-        [RequiresUnreferencedCodeAttribute("MVC does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IMvcBuilder AddMvc(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddMvc(this IServiceCollection services);
-        [RequiresUnreferencedCodeAttribute("MVC does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IMvcBuilder AddMvc(this IServiceCollection services, Action<MvcOptions> setupAction);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddMvc(this IServiceCollection services, Action<MvcOptions> setupAction);
-        [RequiresUnreferencedCodeAttribute("Razor Pages does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IMvcBuilder AddRazorPages(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("Razor Pages does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddRazorPages(this IServiceCollection services);
-        [RequiresUnreferencedCodeAttribute("Razor Pages does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IMvcBuilder AddRazorPages(this IServiceCollection services, Action<RazorPagesOptions>? configure);
+        [RequiresUnreferencedCodeAttribute("Razor Pages does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddRazorPages(this IServiceCollection services, Action<RazorPagesOptions>? configure);
     }
     public static class OptionsServiceCollectionExtensions {
+        public static OptionsBuilder<TOptions> AddOptionsWithValidateOnStart<TOptions, TValidateOptions>(this IServiceCollection services, string? name = null) where TOptions : class where TValidateOptions : class, IValidateOptions<TOptions>;
+        public static OptionsBuilder<TOptions> AddOptionsWithValidateOnStart<TOptions>(this IServiceCollection services, string? name = null) where TOptions : class;
     }
-    public class RazorComponentOptions {
-        public RazorComponentOptions();
-        public bool FormMappingUseCurrentCulture { get; set; }
-        public int MaxFormMappingCollectionSize { get; set; }
-        public int MaxFormMappingErrorCount { get; set; }
-        public int MaxFormMappingKeySize { get; set; }
-        public int MaxFormMappingRecursionDepth { get; set; }
-    }
-    public static class RazorComponentsBuilderExtensions {
-        [RequiresUnreferencedCodeAttribute("Server-side Blazor does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IRazorComponentsBuilder AddServerComponents(this IRazorComponentsBuilder builder, Action<CircuitOptions>? configure = null);
-    }
     public static class RazorComponentsServiceCollectionExtensions {
-        [RequiresUnreferencedCodeAttribute("Razor Components does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IRazorComponentsBuilder AddRazorComponents(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("Razor Components does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IRazorComponentsBuilder AddRazorComponents(this IServiceCollection services, Action<RazorComponentsOptions>? configure = null);
-        public static IRazorComponentsBuilder AddRazorComponents(this IServiceCollection services, Action<RazorComponentOptions> setupAction);
     }
+    public static class ServerRazorComponentsBuilderExtensions {
+        [RequiresUnreferencedCodeAttribute("Server-side Blazor does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IServerSideBlazorBuilder AddServerComponents(this IRazorComponentsBuilder builder, Action<CircuitOptions>? configure = null);
+    }
     public static class SessionServiceCollectionExtensions {
-        [RequiresUnreferencedCodeAttribute("Session State middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IServiceCollection AddSession(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("Session State middleware does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IServiceCollection AddSession(this IServiceCollection services);
-        [RequiresUnreferencedCodeAttribute("Session State middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IServiceCollection AddSession(this IServiceCollection services, Action<SessionOptions> configure);
+        [RequiresUnreferencedCodeAttribute("Session State middleware does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IServiceCollection AddSession(this IServiceCollection services, Action<SessionOptions> configure);
     }
     public static class SignalRDependencyInjectionExtensions {
-        [RequiresUnreferencedCodeAttribute("SignalR does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("SignalR does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services);
-        [RequiresUnreferencedCodeAttribute("SignalR does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services, Action<HubOptions> configure);
+        [RequiresUnreferencedCodeAttribute("SignalR does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services, Action<HubOptions> configure);
     }
 }
```

