# Microsoft.Extensions.Diagnostics.Metrics

``` diff
+namespace Microsoft.Extensions.Diagnostics.Metrics {
+    public static class ConsoleMetrics {
+        public static string DebugListenerName { get; }
+    }
+    public interface IMetricsBuilder {
+        IServiceCollection Services { get; }
+    }
+    public interface IMetricsListener {
+        string Name { get; }
+        MeasurementHandlers GetMeasurementHandlers();
+        void Initialize(IObservableInstrumentsSource source);
+        bool InstrumentPublished(Instrument instrument, out object? userState);
+        void MeasurementsCompleted(Instrument instrument, object? userState);
+    }
+    public class InstrumentRule {
+        public InstrumentRule(string meterName, string instrumentName, string listenerName, MeterScope scopes, bool enable);
+        public bool Enable { get; }
+        public string InstrumentName { get; }
+        public string ListenerName { get; }
+        public string MeterName { get; }
+        public MeterScope Scopes { get; }
+    }
+    public interface IObservableInstrumentsSource {
+        void RecordObservableInstruments();
+    }
+    public class MeasurementHandlers {
+        public MeasurementHandlers();
+        public MeasurementCallback<byte> ByteHandler { get; set; }
+        public MeasurementCallback<decimal> DecimalHandler { get; set; }
+        public MeasurementCallback<double> DoubleHandler { get; set; }
+        public MeasurementCallback<float> FloatHandler { get; set; }
+        public MeasurementCallback<int> IntHandler { get; set; }
+        public MeasurementCallback<long> LongHandler { get; set; }
+        public MeasurementCallback<short> ShortHandler { get; set; }
+    }
+    [FlagsAttribute]
+    public enum MeterScope {
+        Global = 1,
+        Local = 2,
+        None = 0,
+    }
+    public static class MetricsBuilderConfigurationExtensions {
+        public static IMetricsBuilder AddConfiguration(this IMetricsBuilder builder, IConfiguration configuration);
+    }
+    public static class MetricsBuilderConsoleExtensions {
+        public static IMetricsBuilder AddDebugConsole(this IMetricsBuilder builder);
+    }
+    public static class MetricsBuilderExtensions {
+        public static IMetricsBuilder AddListener(this IMetricsBuilder builder, IMetricsListener listener);
+        public static IMetricsBuilder AddListener<T>(this IMetricsBuilder builder) where T : class, IMetricsListener;
+        public static IMetricsBuilder ClearListeners(this IMetricsBuilder builder);
+        public static IMetricsBuilder DisableMetrics(this IMetricsBuilder builder, string? meterName);
+        public static IMetricsBuilder DisableMetrics(this IMetricsBuilder builder, string? meterName, string? instrumentName = null, string? listenerName = null, MeterScope scopes = MeterScope.Global | MeterScope.Local);
+        public static MetricsOptions DisableMetrics(this MetricsOptions options, string? meterName);
+        public static MetricsOptions DisableMetrics(this MetricsOptions options, string? meterName, string? instrumentName = null, string? listenerName = null, MeterScope scopes = MeterScope.Global | MeterScope.Local);
+        public static IMetricsBuilder EnableMetrics(this IMetricsBuilder builder, string? meterName);
+        public static IMetricsBuilder EnableMetrics(this IMetricsBuilder builder, string? meterName, string? instrumentName = null, string? listenerName = null, MeterScope scopes = MeterScope.Global | MeterScope.Local);
+        public static MetricsOptions EnableMetrics(this MetricsOptions options, string? meterName);
+        public static MetricsOptions EnableMetrics(this MetricsOptions options, string? meterName, string? instrumentName = null, string? listenerName = null, MeterScope scopes = MeterScope.Global | MeterScope.Local);
+    }
+    public class MetricsOptions {
+        public MetricsOptions();
+        public IList<InstrumentRule> Rules { get; }
+    }
+}
```

