# System.Runtime.CompilerServices

``` diff
 namespace System.Runtime.CompilerServices {
+    [AttributeUsageAttribute(AttributeTargets.Parameter, Inherited=false)]
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class RequiresLocationAttribute : Attribute {
+        public RequiresLocationAttribute();
+    }
     public static class Unsafe {
-        public static bool AreSame<T>([AllowNullAttribute] ref T left, [AllowNullAttribute] ref T right);
+        public static bool AreSame<T>([AllowNullAttribute, RequiresLocationAttribute] ref T left, [AllowNullAttribute, RequiresLocationAttribute] ref T right);
-        public static ref T AsRef<T>([ScopedRefAttribute] in T source);
+        public static ref T AsRef<T>([RequiresLocationAttribute, ScopedRefAttribute] ref T source);
-        public static IntPtr ByteOffset<T>([AllowNullAttribute] ref T origin, [AllowNullAttribute] ref T target);
+        public static IntPtr ByteOffset<T>([AllowNullAttribute, RequiresLocationAttribute] ref T origin, [AllowNullAttribute, RequiresLocationAttribute] ref T target);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void Copy<T>(void* destination, ref T source);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Copy<T>(void* destination, ref readonly T source);
-        [CLSCompliantAttribute(false)]
-        public static void CopyBlock(ref byte destination, ref byte source, uint byteCount);
+        [CLSCompliantAttribute(false)]
+        public static void CopyBlock(ref byte destination, ref readonly byte source, uint byteCount);
-        [CLSCompliantAttribute(false)]
-        public static void CopyBlockUnaligned(ref byte destination, ref byte source, uint byteCount);
+        [CLSCompliantAttribute(false)]
+        public static void CopyBlockUnaligned(ref byte destination, ref readonly byte source, uint byteCount);
-        public static bool IsAddressGreaterThan<T>([AllowNullAttribute] ref T left, [AllowNullAttribute] ref T right);
+        public static bool IsAddressGreaterThan<T>([AllowNullAttribute, RequiresLocationAttribute] ref T left, [AllowNullAttribute, RequiresLocationAttribute] ref T right);
-        public static bool IsAddressLessThan<T>([AllowNullAttribute] ref T left, [AllowNullAttribute] ref T right);
+        public static bool IsAddressLessThan<T>([AllowNullAttribute, RequiresLocationAttribute] ref T left, [AllowNullAttribute, RequiresLocationAttribute] ref T right);
-        public static bool IsNullRef<T>(ref T source);
+        public static bool IsNullRef<T>(ref readonly T source);
-        public static T ReadUnaligned<T>(ref byte source);
+        public static T ReadUnaligned<T>(ref readonly byte source);
     }
 }
```

