# System.ComponentModel.Design

``` diff
 namespace System.ComponentModel.Design {
     public class InheritanceService : IDisposable, IInheritanceService {
-        protected virtual void AddInheritedComponents(Type type, IComponent component, IContainer container);
+        protected virtual void AddInheritedComponents(Type? type, IComponent component, IContainer container);
-        protected virtual bool IgnoreInheritedMember(MemberInfo member, IComponent component);
+        protected virtual bool IgnoreInheritedMember(MemberInfo member, IComponent? component);
     }
     public sealed class LoadedEventArgs : EventArgs {
-        public LoadedEventArgs(bool succeeded, ICollection errors);
+        public LoadedEventArgs(bool succeeded, ICollection? errors);
     }
     public abstract class ObjectSelectorEditor : UITypeEditor {
-        protected virtual void FillTreeWithData(ObjectSelectorEditor.Selector selector, ITypeDescriptorContext context, IServiceProvider provider);
+        protected virtual void FillTreeWithData(ObjectSelectorEditor.Selector selector, ITypeDescriptorContext? context, IServiceProvider provider);
         public class Selector : TreeView {
-            public ObjectSelectorEditor.SelectorNode AddNode(string label, object value, ObjectSelectorEditor.SelectorNode parent);
+            public ObjectSelectorEditor.SelectorNode AddNode(string? label, object? value, ObjectSelectorEditor.SelectorNode? parent);
-            protected void OnAfterSelect(object sender, TreeViewEventArgs e);
+            protected void OnAfterSelect(object? sender, TreeViewEventArgs e);
-            public bool SetSelection(object value, TreeNodeCollection nodes);
+            public bool SetSelection(object? value, TreeNodeCollection? nodes);
-            public void Start(IWindowsFormsEditorService edSvc, object value);
+            public void Start(IWindowsFormsEditorService edSvc, object? value);
         }
         public class SelectorNode : TreeNode {
-            public object? value;
+            public object value;
-            public SelectorNode(string label, object? value);
+            public SelectorNode(string label, object value);
         }
     }
     public abstract class UndoEngine : IDisposable {
-        public event EventHandler Undoing;
+        public event EventHandler? Undoing;
-        public event EventHandler Undone;
+        public event EventHandler? Undone;
-        protected virtual UndoEngine.UndoUnit CreateUndoUnit(string name, bool primary);
+        protected virtual UndoEngine.UndoUnit CreateUndoUnit(string? name, bool primary);
-        protected object GetService(Type serviceType);
+        protected object? GetService(Type serviceType);
         protected class UndoUnit {
-            public UndoUnit(UndoEngine engine, string name);
+            public UndoUnit(UndoEngine engine, string? name);
-            protected object GetService(Type serviceType);
+            protected object? GetService(Type serviceType);
         }
     }
 }
```

