# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
-    [RequiresPreviewFeaturesAttribute]
-    public abstract class BindableComponent : Component, IBindableComponent, IComponent, IDisposable
+    public abstract class BindableComponent : Component, IBindableComponent, IComponent, IDisposable
-    public struct BindingMemberInfo : IEquatable<BindingMemberInfo>
+    public readonly struct BindingMemberInfo : IEquatable<BindingMemberInfo>
     [DesignerAttribute("System.Windows.Forms.Design.ButtonBaseDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public abstract class ButtonBase : Control, ICommandBindingTargetProvider {
-        [BindableAttribute(true)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandComponentCommandDescr")]
-        public ICommand? Command { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandComponentCommandDescr")]
+        public ICommand? Command { get; set; }
-        [BindableAttribute(true)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandComponentCommandParameterDescr")]
-        public object? CommandParameter { [RequiresPreviewFeaturesAttribute] get; [RequiresPreviewFeaturesAttribute] set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandComponentCommandParameterDescr")]
+        public object? CommandParameter { get; set; }
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandCanExecuteChangedEventDescr")]
-        public event EventHandler? CommandCanExecuteChanged;
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandCanExecuteChangedEventDescr")]
+        public event EventHandler? CommandCanExecuteChanged;
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandChangedEventDescr")]
-        public event EventHandler? CommandChanged;
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandChangedEventDescr")]
+        public event EventHandler? CommandChanged;
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandParameterChangedEventDescr")]
-        public event EventHandler? CommandParameterChanged;
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandParameterChangedEventDescr")]
+        public event EventHandler? CommandParameterChanged;
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnCommandCanExecuteChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnCommandCanExecuteChanged(EventArgs e);
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnCommandChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnCommandChanged(EventArgs e);
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnCommandParameterChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnCommandParameterChanged(EventArgs e);
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnRequestCommandExecute(EventArgs e);
+        protected virtual void OnRequestCommandExecute(EventArgs e);
     }
     [LookupBindingPropertiesAttribute]
     [SRDescriptionAttribute("DescriptionCheckedListBox")]
     public class CheckedListBox : ListBox {
-        [DesignerSerializationVisibilityAttribute(2)]
-        [EditorAttribute("System.Windows.Forms.Design.ListControlStringCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ListBoxItemsDescr")]
-        public new CheckedListBox.ObjectCollection Items { get; }
+        [DesignerSerializationVisibilityAttribute(2)]
+        [EditorAttribute("System.Windows.Forms.Design.ListControlStringCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [MergablePropertyAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ListBoxItemsDescr")]
+        public new CheckedListBox.ObjectCollection Items { get; }
     }
     public class DataGridViewButtonCell : DataGridViewCell {
-        public override Type EditType { get; }
+        public override Type? EditType { get; }
-        protected override object GetValue(int rowIndex);
+        protected override object? GetValue(int rowIndex);
-        protected override void Paint(Graphics graphics, Rectangle clipBounds, Rectangle cellBounds, int rowIndex, DataGridViewElementStates elementState, object value, object formattedValue, string errorText, DataGridViewCellStyle cellStyle, DataGridViewAdvancedBorderStyle advancedBorderStyle, DataGridViewPaintParts paintParts);
+        protected override void Paint(Graphics graphics, Rectangle clipBounds, Rectangle cellBounds, int rowIndex, DataGridViewElementStates elementState, object? value, object? formattedValue, string? errorText, DataGridViewCellStyle cellStyle, DataGridViewAdvancedBorderStyle advancedBorderStyle, DataGridViewPaintParts paintParts);
     }
     public class DataGridViewComboBoxEditingControl : ComboBox, IDataGridViewEditingControl {
-        public virtual DataGridView EditingControlDataGridView { get; set; }
+        public virtual DataGridView? EditingControlDataGridView { get; set; }
     }
     [ListBindableAttribute(false)]
     public class DataGridViewSelectedCellCollection : BaseCollection, ICollection, IEnumerable, IList {
-        int System.Collections.ICollection.Count { get; }
+        int ICollection.Count { get; }
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        bool System.Collections.IList.IsReadOnly { get; }
+        bool IList.IsReadOnly { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
-        int IList.Add(object value);
+        int IList.Add(object? value);
-        bool IList.Contains(object value);
+        bool IList.Contains(object? value);
-        int IList.IndexOf(object value);
+        int IList.IndexOf(object? value);
-        void IList.Insert(int index, object value);
+        void IList.Insert(int index, object? value);
-        void IList.Remove(object value);
+        void IList.Remove(object? value);
     }
-    public struct ImeModeConversion
+    public readonly struct ImeModeConversion
     [DefaultPropertyAttribute("Document")]
     [SRDescriptionAttribute("DescriptionPrintPreviewControl")]
     public class PrintPreviewControl : Control {
-        protected override CreateParams CreateParams { get; }
-        [DefaultValueAttribute(null)]
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("PrintPreviewDocumentDescr")]
-        public PrintDocument Document { get; set; }
+        [DefaultValueAttribute(null)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("PrintPreviewDocumentDescr")]
+        public PrintDocument? Document { get; set; }
-        [BrowsableAttribute(false)]
-        [DefaultValueAttribute(false)]
-        [DispIdAttribute(-516)]
-        [EditorBrowsableAttribute(1)]
-        public new bool TabStop { get; set; }
+        [DefaultValueAttribute(false)]
+        [DispIdAttribute(-516)]
+        public new bool TabStop { get; set; }
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("RadioButtonOnStartPageChangedDescr")]
-        public event EventHandler StartPageChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("RadioButtonOnStartPageChangedDescr")]
+        public event EventHandler? StartPageChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TabStopChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TextChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TextChanged;
+        protected override void OnGotFocus(EventArgs e);
+        protected override void OnLostFocus(EventArgs e);
+        protected override void OnMouseDown(MouseEventArgs e);
+        protected override void OnPaintBackground(PaintEventArgs e);
     }
     [DefaultEventAttribute("Click")]
     [DefaultPropertyAttribute("Text")]
     [DesignTimeVisibleAttribute(false)]
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripItemDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxItemAttribute(false)]
     public abstract class ToolStripItem : BindableComponent, IArrangedElement, ICommandBindingTargetProvider, IComponent, IDisposable, IDropTarget, IKeyboardToolTip, ISupportOleDropSource {
-        [BindableAttribute(true)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandComponentCommandDescr")]
-        public ICommand Command { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandComponentCommandDescr")]
+        public ICommand Command { get; set; }
-        [BindableAttribute(true)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandComponentCommandParameterDescr")]
-        public object CommandParameter { [RequiresPreviewFeaturesAttribute] get; [RequiresPreviewFeaturesAttribute] set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandComponentCommandParameterDescr")]
+        public object CommandParameter { get; set; }
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandCanExecuteChangedEventDescr")]
-        public event EventHandler CommandCanExecuteChanged;
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandCanExecuteChangedEventDescr")]
+        public event EventHandler CommandCanExecuteChanged;
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandChangedEventDescr")]
-        public event EventHandler CommandChanged;
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandChangedEventDescr")]
+        public event EventHandler CommandChanged;
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandParameterChangedEventDescr")]
-        public event EventHandler CommandParameterChanged;
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandParameterChangedEventDescr")]
+        public event EventHandler CommandParameterChanged;
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnCommandCanExecuteChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnCommandCanExecuteChanged(EventArgs e);
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnCommandChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnCommandChanged(EventArgs e);
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnCommandParameterChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnCommandParameterChanged(EventArgs e);
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnRequestCommandExecute(EventArgs e);
+        protected virtual void OnRequestCommandExecute(EventArgs e);
     }
     public static class ToolStripManager {
-        public static ToolStripRenderer Renderer { get; set; }
+        [AllowNullAttribute]
+        public static ToolStripRenderer Renderer { get; set; }
-        public static event EventHandler RendererChanged;
+        public static event EventHandler? RendererChanged;
-        public static ToolStrip FindToolStrip(string toolStripName);
+        public static ToolStrip? FindToolStrip(string toolStripName);
     }
     [EditorAttribute("System.Windows.Forms.Design.TreeNodeCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
     public class TreeNodeCollection : ICollection, IEnumerable, IList {
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object IList.this[int index] { get; set; }
-        public virtual TreeNode Add(string text);
+        public virtual TreeNode Add(string? text);
-        public virtual TreeNode Insert(int index, string text);
+        public virtual TreeNode Insert(int index, string? text);
     }
 }
```

