# Microsoft.AspNetCore.Components.Endpoints

``` diff
 namespace Microsoft.AspNetCore.Components.Endpoints {
-    public class RazorComponentResult : IResult {
-        public RazorComponentResult(Type componentType);
-        public RazorComponentResult(Type componentType, IReadOnlyDictionary<string, object?>? parameters);
-        public RazorComponentResult(Type componentType, object? parameters);
-        public Type ComponentType { get; }
-        public string? ContentType { get; set; }
-        public IReadOnlyDictionary<string, object?> Parameters { get; }
-        public bool PreventStreamingRendering { get; set; }
-        public int? StatusCode { get; set; }
-        public Task ExecuteAsync(HttpContext httpContext);
-    }
-    public class RazorComponentResult<TComponent> : RazorComponentResult where TComponent : IComponent {
-        public RazorComponentResult();
-        public RazorComponentResult(IReadOnlyDictionary<string, object?> parameters);
-        public RazorComponentResult(object parameters);
-    }
-    public class RazorComponentResultExecutor {
-        public static readonly string DefaultContentType;
-        public RazorComponentResultExecutor();
-        public virtual Task ExecuteAsync(HttpContext httpContext, RazorComponentResult result);
-    }
-    public sealed class RazorComponentsOptions {
-        public RazorComponentsOptions();
-        public int MaxFormMappingCollectionSize { get; set; }
-        public int MaxFormMappingErrorCount { get; set; }
-        public int MaxFormMappingKeySize { get; set; }
-        public int MaxFormMappingRecursionDepth { get; set; }
-    }
+    public sealed class RazorComponentsServiceOptions {
+        public RazorComponentsServiceOptions();
+        public bool DetailedErrors { get; set; }
+        public int MaxFormMappingCollectionSize { get; set; }
+        public int MaxFormMappingErrorCount { get; set; }
+        public int MaxFormMappingKeySize { get; set; }
+        public int MaxFormMappingRecursionDepth { get; set; }
+        public TimeSpan TemporaryRedirectionUrlValidityDuration { get; set; }
+    }
 }
```

