# Microsoft.AspNetCore.Components.Web

``` diff
 namespace Microsoft.AspNetCore.Components.Web {
-    public class AutoRenderMode : IComponentRenderMode {
-        public AutoRenderMode();
-        public AutoRenderMode(bool prerender);
-        public bool Prerender { get; }
-    }
-    [EventHandlerAttribute("onabort", typeof(ProgressEventArgs), true, true)]
-    [EventHandlerAttribute("onactivate", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onbeforeactivate", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onbeforecopy", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onbeforecut", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onbeforedeactivate", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onbeforepaste", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onblur", typeof(FocusEventArgs), true, true)]
-    [EventHandlerAttribute("oncanplay", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("oncanplaythrough", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onchange", typeof(ChangeEventArgs), true, true)]
-    [EventHandlerAttribute("onclick", typeof(MouseEventArgs), true, true)]
-    [EventHandlerAttribute("oncontextmenu", typeof(MouseEventArgs), true, true)]
-    [EventHandlerAttribute("oncopy", typeof(ClipboardEventArgs), true, true)]
-    [EventHandlerAttribute("oncuechange", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("oncut", typeof(ClipboardEventArgs), true, true)]
-    [EventHandlerAttribute("ondblclick", typeof(MouseEventArgs), true, true)]
-    [EventHandlerAttribute("ondeactivate", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("ondrag", typeof(DragEventArgs), true, true)]
-    [EventHandlerAttribute("ondragend", typeof(DragEventArgs), true, true)]
-    [EventHandlerAttribute("ondragenter", typeof(DragEventArgs), true, true)]
-    [EventHandlerAttribute("ondragleave", typeof(DragEventArgs), true, true)]
-    [EventHandlerAttribute("ondragover", typeof(DragEventArgs), true, true)]
-    [EventHandlerAttribute("ondragstart", typeof(DragEventArgs), true, true)]
-    [EventHandlerAttribute("ondrop", typeof(DragEventArgs), true, true)]
-    [EventHandlerAttribute("ondurationchange", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onemptied", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onended", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onerror", typeof(ErrorEventArgs), true, true)]
-    [EventHandlerAttribute("onfocus", typeof(FocusEventArgs), true, true)]
-    [EventHandlerAttribute("onfocusin", typeof(FocusEventArgs), true, true)]
-    [EventHandlerAttribute("onfocusout", typeof(FocusEventArgs), true, true)]
-    [EventHandlerAttribute("onfullscreenchange", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onfullscreenerror", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("ongotpointercapture", typeof(PointerEventArgs), true, true)]
-    [EventHandlerAttribute("oninput", typeof(ChangeEventArgs), true, true)]
-    [EventHandlerAttribute("oninvalid", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onkeydown", typeof(KeyboardEventArgs), true, true)]
-    [EventHandlerAttribute("onkeypress", typeof(KeyboardEventArgs), true, true)]
-    [EventHandlerAttribute("onkeyup", typeof(KeyboardEventArgs), true, true)]
-    [EventHandlerAttribute("onload", typeof(ProgressEventArgs), true, true)]
-    [EventHandlerAttribute("onloadeddata", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onloadedmetadata", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onloadend", typeof(ProgressEventArgs), true, true)]
-    [EventHandlerAttribute("onloadstart", typeof(ProgressEventArgs), true, true)]
-    [EventHandlerAttribute("onlostpointercapture", typeof(PointerEventArgs), true, true)]
-    [EventHandlerAttribute("onmousedown", typeof(MouseEventArgs), true, true)]
-    [EventHandlerAttribute("onmouseenter", typeof(MouseEventArgs), true, true)]
-    [EventHandlerAttribute("onmouseleave", typeof(MouseEventArgs), true, true)]
-    [EventHandlerAttribute("onmousemove", typeof(MouseEventArgs), true, true)]
-    [EventHandlerAttribute("onmouseout", typeof(MouseEventArgs), true, true)]
-    [EventHandlerAttribute("onmouseover", typeof(MouseEventArgs), true, true)]
-    [EventHandlerAttribute("onmouseup", typeof(MouseEventArgs), true, true)]
-    [EventHandlerAttribute("onmousewheel", typeof(WheelEventArgs), true, true)]
-    [EventHandlerAttribute("onpaste", typeof(ClipboardEventArgs), true, true)]
-    [EventHandlerAttribute("onpause", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onplay", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onplaying", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onpointercancel", typeof(PointerEventArgs), true, true)]
-    [EventHandlerAttribute("onpointerdown", typeof(PointerEventArgs), true, true)]
-    [EventHandlerAttribute("onpointerenter", typeof(PointerEventArgs), true, true)]
-    [EventHandlerAttribute("onpointerleave", typeof(PointerEventArgs), true, true)]
-    [EventHandlerAttribute("onpointerlockchange", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onpointerlockerror", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onpointermove", typeof(PointerEventArgs), true, true)]
-    [EventHandlerAttribute("onpointerout", typeof(PointerEventArgs), true, true)]
-    [EventHandlerAttribute("onpointerover", typeof(PointerEventArgs), true, true)]
-    [EventHandlerAttribute("onpointerup", typeof(PointerEventArgs), true, true)]
-    [EventHandlerAttribute("onprogress", typeof(ProgressEventArgs), true, true)]
-    [EventHandlerAttribute("onratechange", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onreadystatechange", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onreset", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onscroll", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onseeked", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onseeking", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onselect", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onselectionchange", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onselectstart", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onstalled", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onstop", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onsubmit", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onsuspend", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("ontimeout", typeof(ProgressEventArgs), true, true)]
-    [EventHandlerAttribute("ontimeupdate", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("ontoggle", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("ontouchcancel", typeof(TouchEventArgs), true, true)]
-    [EventHandlerAttribute("ontouchend", typeof(TouchEventArgs), true, true)]
-    [EventHandlerAttribute("ontouchenter", typeof(TouchEventArgs), true, true)]
-    [EventHandlerAttribute("ontouchleave", typeof(TouchEventArgs), true, true)]
-    [EventHandlerAttribute("ontouchmove", typeof(TouchEventArgs), true, true)]
-    [EventHandlerAttribute("ontouchstart", typeof(TouchEventArgs), true, true)]
-    [EventHandlerAttribute("onvolumechange", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onwaiting", typeof(EventArgs), true, true)]
-    [EventHandlerAttribute("onwheel", typeof(WheelEventArgs), true, true)]
-    public static class EventHandlers
+    [EventHandlerAttribute("onabort", typeof(ProgressEventArgs), true, true)]
+    [EventHandlerAttribute("onactivate", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onbeforeactivate", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onbeforecopy", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onbeforecut", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onbeforedeactivate", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onbeforepaste", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onblur", typeof(FocusEventArgs), true, true)]
+    [EventHandlerAttribute("oncancel", typeof(EventArgs), false, true)]
+    [EventHandlerAttribute("oncanplay", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("oncanplaythrough", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onchange", typeof(ChangeEventArgs), true, true)]
+    [EventHandlerAttribute("onclick", typeof(MouseEventArgs), true, true)]
+    [EventHandlerAttribute("onclose", typeof(EventArgs), false, true)]
+    [EventHandlerAttribute("oncontextmenu", typeof(MouseEventArgs), true, true)]
+    [EventHandlerAttribute("oncopy", typeof(ClipboardEventArgs), true, true)]
+    [EventHandlerAttribute("oncuechange", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("oncut", typeof(ClipboardEventArgs), true, true)]
+    [EventHandlerAttribute("ondblclick", typeof(MouseEventArgs), true, true)]
+    [EventHandlerAttribute("ondeactivate", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("ondrag", typeof(DragEventArgs), true, true)]
+    [EventHandlerAttribute("ondragend", typeof(DragEventArgs), true, true)]
+    [EventHandlerAttribute("ondragenter", typeof(DragEventArgs), true, true)]
+    [EventHandlerAttribute("ondragleave", typeof(DragEventArgs), true, true)]
+    [EventHandlerAttribute("ondragover", typeof(DragEventArgs), true, true)]
+    [EventHandlerAttribute("ondragstart", typeof(DragEventArgs), true, true)]
+    [EventHandlerAttribute("ondrop", typeof(DragEventArgs), true, true)]
+    [EventHandlerAttribute("ondurationchange", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onemptied", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onended", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onerror", typeof(ErrorEventArgs), true, true)]
+    [EventHandlerAttribute("onfocus", typeof(FocusEventArgs), true, true)]
+    [EventHandlerAttribute("onfocusin", typeof(FocusEventArgs), true, true)]
+    [EventHandlerAttribute("onfocusout", typeof(FocusEventArgs), true, true)]
+    [EventHandlerAttribute("onfullscreenchange", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onfullscreenerror", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("ongotpointercapture", typeof(PointerEventArgs), true, true)]
+    [EventHandlerAttribute("oninput", typeof(ChangeEventArgs), true, true)]
+    [EventHandlerAttribute("oninvalid", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onkeydown", typeof(KeyboardEventArgs), true, true)]
+    [EventHandlerAttribute("onkeypress", typeof(KeyboardEventArgs), true, true)]
+    [EventHandlerAttribute("onkeyup", typeof(KeyboardEventArgs), true, true)]
+    [EventHandlerAttribute("onload", typeof(ProgressEventArgs), true, true)]
+    [EventHandlerAttribute("onloadeddata", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onloadedmetadata", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onloadend", typeof(ProgressEventArgs), true, true)]
+    [EventHandlerAttribute("onloadstart", typeof(ProgressEventArgs), true, true)]
+    [EventHandlerAttribute("onlostpointercapture", typeof(PointerEventArgs), true, true)]
+    [EventHandlerAttribute("onmousedown", typeof(MouseEventArgs), true, true)]
+    [EventHandlerAttribute("onmouseenter", typeof(MouseEventArgs), true, true)]
+    [EventHandlerAttribute("onmouseleave", typeof(MouseEventArgs), true, true)]
+    [EventHandlerAttribute("onmousemove", typeof(MouseEventArgs), true, true)]
+    [EventHandlerAttribute("onmouseout", typeof(MouseEventArgs), true, true)]
+    [EventHandlerAttribute("onmouseover", typeof(MouseEventArgs), true, true)]
+    [EventHandlerAttribute("onmouseup", typeof(MouseEventArgs), true, true)]
+    [EventHandlerAttribute("onmousewheel", typeof(WheelEventArgs), true, true)]
+    [EventHandlerAttribute("onpaste", typeof(ClipboardEventArgs), true, true)]
+    [EventHandlerAttribute("onpause", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onplay", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onplaying", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onpointercancel", typeof(PointerEventArgs), true, true)]
+    [EventHandlerAttribute("onpointerdown", typeof(PointerEventArgs), true, true)]
+    [EventHandlerAttribute("onpointerenter", typeof(PointerEventArgs), true, true)]
+    [EventHandlerAttribute("onpointerleave", typeof(PointerEventArgs), true, true)]
+    [EventHandlerAttribute("onpointerlockchange", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onpointerlockerror", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onpointermove", typeof(PointerEventArgs), true, true)]
+    [EventHandlerAttribute("onpointerout", typeof(PointerEventArgs), true, true)]
+    [EventHandlerAttribute("onpointerover", typeof(PointerEventArgs), true, true)]
+    [EventHandlerAttribute("onpointerup", typeof(PointerEventArgs), true, true)]
+    [EventHandlerAttribute("onprogress", typeof(ProgressEventArgs), true, true)]
+    [EventHandlerAttribute("onratechange", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onreadystatechange", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onreset", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onscroll", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onseeked", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onseeking", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onselect", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onselectionchange", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onselectstart", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onstalled", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onstop", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onsubmit", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onsuspend", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("ontimeout", typeof(ProgressEventArgs), true, true)]
+    [EventHandlerAttribute("ontimeupdate", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("ontoggle", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("ontouchcancel", typeof(TouchEventArgs), true, true)]
+    [EventHandlerAttribute("ontouchend", typeof(TouchEventArgs), true, true)]
+    [EventHandlerAttribute("ontouchenter", typeof(TouchEventArgs), true, true)]
+    [EventHandlerAttribute("ontouchleave", typeof(TouchEventArgs), true, true)]
+    [EventHandlerAttribute("ontouchmove", typeof(TouchEventArgs), true, true)]
+    [EventHandlerAttribute("ontouchstart", typeof(TouchEventArgs), true, true)]
+    [EventHandlerAttribute("onvolumechange", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onwaiting", typeof(EventArgs), true, true)]
+    [EventHandlerAttribute("onwheel", typeof(WheelEventArgs), true, true)]
+    public static class EventHandlers
+    public class InteractiveAutoRenderMode : IComponentRenderMode {
+        public InteractiveAutoRenderMode();
+        public InteractiveAutoRenderMode(bool prerender);
+        public bool Prerender { get; }
+    }
+    public class InteractiveServerRenderMode : IComponentRenderMode {
+        public InteractiveServerRenderMode();
+        public InteractiveServerRenderMode(bool prerender);
+        public bool Prerender { get; }
+    }
+    public class InteractiveWebAssemblyRenderMode : IComponentRenderMode {
+        public InteractiveWebAssemblyRenderMode();
+        public InteractiveWebAssemblyRenderMode(bool prerender);
+        public bool Prerender { get; }
+    }
     public static class RenderMode {
-        public static AutoRenderMode Auto { get; }
+        public static InteractiveAutoRenderMode InteractiveAuto { get; }
+        public static InteractiveServerRenderMode InteractiveServer { get; }
+        public static InteractiveWebAssemblyRenderMode InteractiveWebAssembly { get; }
-        public static ServerRenderMode Server { get; }
-        public static WebAssemblyRenderMode WebAssembly { get; }
     }
-    public class RenderModeAutoAttribute : RenderModeAttribute {
-        public RenderModeAutoAttribute();
-        public RenderModeAutoAttribute(bool prerender);
-        public override IComponentRenderMode Mode { get; }
-    }
+    public class RenderModeInteractiveAutoAttribute : RenderModeAttribute {
+        public RenderModeInteractiveAutoAttribute();
+        public RenderModeInteractiveAutoAttribute(bool prerender);
+        public override IComponentRenderMode Mode { get; }
+    }
+    public class RenderModeInteractiveServerAttribute : RenderModeAttribute {
+        public RenderModeInteractiveServerAttribute();
+        public RenderModeInteractiveServerAttribute(bool prerender);
+        public override IComponentRenderMode Mode { get; }
+    }
+    public class RenderModeInteractiveWebAssemblyAttribute : RenderModeAttribute {
+        public RenderModeInteractiveWebAssemblyAttribute();
+        public RenderModeInteractiveWebAssemblyAttribute(bool prerender);
+        public override IComponentRenderMode Mode { get; }
+    }
-    public class RenderModeServerAttribute : RenderModeAttribute {
-        public RenderModeServerAttribute();
-        public RenderModeServerAttribute(bool prerender);
-        public override IComponentRenderMode Mode { get; }
-    }
-    public class RenderModeWebAssemblyAttribute : RenderModeAttribute {
-        public RenderModeWebAssemblyAttribute();
-        public RenderModeWebAssemblyAttribute(bool prerender);
-        public override IComponentRenderMode Mode { get; }
-    }
-    public class ServerRenderMode : IComponentRenderMode {
-        public ServerRenderMode();
-        public ServerRenderMode(bool prerender);
-        public bool Prerender { get; }
-    }
-    public class WebAssemblyRenderMode : IComponentRenderMode {
-        public WebAssemblyRenderMode();
-        public WebAssemblyRenderMode(bool prerender);
-        public bool Prerender { get; }
-    }
 }
```

