# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
     [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
     public sealed class CascadingParameterAttribute : CascadingParameterAttributeBase {
-        public override string Name { get; set; }
+        public string Name { get; set; }
     }
     public abstract class CascadingParameterAttributeBase : Attribute {
-        public abstract string Name { get; set; }
     }
     public class CascadingValueSource<TValue> : ICascadingValueSupplier {
-        public CascadingValueSource(Func<TValue> valueFactory, bool isFixed);
+        public CascadingValueSource(Func<TValue> initialValueFactory, bool isFixed);
-        public CascadingValueSource(string name, Func<TValue> valueFactory, bool isFixed);
+        public CascadingValueSource(string name, Func<TValue> initialValueFactory, bool isFixed);
     }
     [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
     public sealed class InjectAttribute : Attribute {
+        public object Key { get; set; }
     }
     public interface IPersistentComponentStateStore {
+        bool SupportsRenderMode(IComponentRenderMode renderMode);
     }
     public class PersistentComponentState {
+        public PersistingComponentStateSubscription RegisterOnPersisting(Func<Task> callback, IComponentRenderMode? renderMode);
     }
-    [AttributeUsageAttribute(4)]
-    public abstract class RenderModeAttribute : Attribute
+    [AttributeUsageAttribute(4, AllowMultiple=false, Inherited=true)]
+    public abstract class RenderModeAttribute : Attribute
     [AttributeUsageAttribute(4, AllowMultiple=false)]
     public class StreamRenderingAttribute : Attribute {
-        public StreamRenderingAttribute(bool enabled);
+        public StreamRenderingAttribute(bool enabled = true);
     }
     [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
     public sealed class SupplyParameterFromFormAttribute : CascadingParameterAttributeBase {
+        public string FormName { get; set; }
-        public string Handler { get; set; }
-        public override string Name { get; set; }
+        public string Name { get; set; }
     }
     [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
     public sealed class SupplyParameterFromQueryAttribute : CascadingParameterAttributeBase {
-        public override string Name { get; set; }
+        public string Name { get; set; }
     }
 }
```

