# Microsoft.AspNetCore.Http.HttpResults

``` diff
 namespace Microsoft.AspNetCore.Http.HttpResults {
+    public class RazorComponentResult : IContentTypeHttpResult, IResult, IStatusCodeHttpResult {
+        public RazorComponentResult(Type componentType);
+        public RazorComponentResult(Type componentType, IReadOnlyDictionary<string, object?> parameters);
+        public RazorComponentResult(Type componentType, object parameters);
+        public Type ComponentType { get; }
+        public string? ContentType { get; set; }
+        public IReadOnlyDictionary<string, object?> Parameters { get; }
+        public bool PreventStreamingRendering { get; set; }
+        public int? StatusCode { get; set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public class RazorComponentResult<TComponent> : RazorComponentResult where TComponent : IComponent {
+        public RazorComponentResult();
+        public RazorComponentResult(IReadOnlyDictionary<string, object?> parameters);
+        public RazorComponentResult(object parameters);
+    }
 }
```

