# Microsoft.Extensions.DependencyInjection

``` diff
 namespace Microsoft.Extensions.DependencyInjection {
     public static class CascadingValueServiceCollectionExtensions {
-        public static IServiceCollection AddCascadingValue<TValue>(this IServiceCollection serviceCollection, Func<IServiceProvider, TValue> valueFactory);
+        public static IServiceCollection AddCascadingValue<TValue>(this IServiceCollection serviceCollection, Func<IServiceProvider, TValue> initialValueFactory);
-        public static IServiceCollection AddCascadingValue<TValue>(this IServiceCollection serviceCollection, string name, Func<IServiceProvider, TValue> valueFactory);
+        public static IServiceCollection AddCascadingValue<TValue>(this IServiceCollection serviceCollection, string name, Func<IServiceProvider, TValue> initialValueFactory);
+        public static void TryAddCascadingValue<TValue>(this IServiceCollection serviceCollection, Func<IServiceProvider, CascadingValueSource<TValue>> sourceFactory);
+        public static void TryAddCascadingValue<TValue>(this IServiceCollection serviceCollection, Func<IServiceProvider, TValue> valueFactory);
+        public static void TryAddCascadingValue<TValue>(this IServiceCollection serviceCollection, string name, Func<IServiceProvider, TValue> valueFactory);
     }
     public static class HttpClientFactoryServiceCollectionExtensions {
-        public static IServiceCollection ConfigureHttpClientDefaults(IServiceCollection services, Action<IHttpClientBuilder> configure);
+        public static IServiceCollection ConfigureHttpClientDefaults(this IServiceCollection services, Action<IHttpClientBuilder> configure);
     }
     public static class HttpLoggingServicesExtensions {
+        public static IServiceCollection AddHttpLoggingInterceptor<T>(this IServiceCollection services) where T : class, IHttpLoggingInterceptor;
     }
     public static class RazorComponentsServiceCollectionExtensions {
-        [RequiresUnreferencedCodeAttribute("Razor Components does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IRazorComponentsBuilder AddRazorComponents(this IServiceCollection services, Action<RazorComponentsOptions>? configure = null);
+        [RequiresUnreferencedCodeAttribute("Razor Components does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IRazorComponentsBuilder AddRazorComponents(this IServiceCollection services, Action<RazorComponentsServiceOptions>? configure = null);
     }
     public static class ServerRazorComponentsBuilderExtensions {
+        [RequiresUnreferencedCodeAttribute("Server-side Blazor does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IServerSideBlazorBuilder AddInteractiveServerComponents(this IRazorComponentsBuilder builder, Action<CircuitOptions>? configure = null);
-        [RequiresUnreferencedCodeAttribute("Server-side Blazor does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
-        public static IServerSideBlazorBuilder AddServerComponents(this IRazorComponentsBuilder builder, Action<CircuitOptions>? configure = null);
     }
 }
```

