# System.Runtime.InteropServices.Marshalling

``` diff
 namespace System.Runtime.InteropServices.Marshalling {
+    public struct ComVariant : IDisposable {
+        public static ComVariant Null { get; }
+        public VarEnum VarType { get; }
+        public T? As<T>();
+        public static ComVariant Create<T>(T value);
+        public static ComVariant CreateRaw<T>(VarEnum vt, T rawValue) where T : unmanaged;
+        public void Dispose();
+        public ref T GetRawDataRef<T>() where T : unmanaged;
+    }
+    public static class ComVariantMarshaller {
+        public static object ConvertToManaged(ComVariant unmanaged);
+        public static ComVariant ConvertToUnmanaged(object managed);
+        public static void Free(ComVariant unmanaged);
+        public struct RefPropagate {
+            public void Free();
+            public void FromManaged(object managed);
+            public void FromUnmanaged(ComVariant unmanaged);
+            public object ToManaged();
+            public ComVariant ToUnmanaged();
+        }
+    }
 }
```

