# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     public static class CryptographicOperations {
+        public static byte[] HashData(HashAlgorithmName hashAlgorithm, byte[] source);
+        public static byte[] HashData(HashAlgorithmName hashAlgorithm, Stream source);
+        public static int HashData(HashAlgorithmName hashAlgorithm, Stream source, Span<byte> destination);
+        public static byte[] HashData(HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> source);
+        public static int HashData(HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(HashAlgorithmName hashAlgorithm, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(HashAlgorithmName hashAlgorithm, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static byte[] HmacData(HashAlgorithmName hashAlgorithm, byte[] key, byte[] source);
+        public static byte[] HmacData(HashAlgorithmName hashAlgorithm, byte[] key, Stream source);
+        public static byte[] HmacData(HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> key, Stream source);
+        public static int HmacData(HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static byte[] HmacData(HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> key, ReadOnlySpan<byte> source);
+        public static int HmacData(HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination);
+        public static ValueTask<byte[]> HmacDataAsync(HashAlgorithmName hashAlgorithm, byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HmacDataAsync(HashAlgorithmName hashAlgorithm, ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HmacDataAsync(HashAlgorithmName hashAlgorithm, ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static bool TryHashData(HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        public static bool TryHmacData(HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
+    public sealed class Kmac128 : IDisposable {
+        public Kmac128(byte[] key, byte[]? customizationString = null);
+        public Kmac128(ReadOnlySpan<byte> key, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static bool IsSupported { get; }
+        public void AppendData(byte[] data);
+        public void AppendData(ReadOnlySpan<byte> data);
+        public void Dispose();
+        public byte[] GetCurrentHash(int outputLength);
+        public void GetCurrentHash(Span<byte> destination);
+        public byte[] GetHashAndReset(int outputLength);
+        public void GetHashAndReset(Span<byte> destination);
+        public static byte[] HashData(byte[] key, byte[] source, int outputLength, byte[]? customizationString = null);
+        public static byte[] HashData(byte[] key, Stream source, int outputLength, byte[]? customizationString = null);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source, int outputLength, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static void HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static byte[] HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, int outputLength, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static void HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, int outputLength, byte[]? customizationString = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, int outputLength, ReadOnlyMemory<byte> customizationString = default(ReadOnlyMemory<byte>), CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, ReadOnlyMemory<byte> customizationString = default(ReadOnlyMemory<byte>), CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public sealed class Kmac256 : IDisposable {
+        public Kmac256(byte[] key, byte[]? customizationString = null);
+        public Kmac256(ReadOnlySpan<byte> key, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static bool IsSupported { get; }
+        public void AppendData(byte[] data);
+        public void AppendData(ReadOnlySpan<byte> data);
+        public void Dispose();
+        public byte[] GetCurrentHash(int outputLength);
+        public void GetCurrentHash(Span<byte> destination);
+        public byte[] GetHashAndReset(int outputLength);
+        public void GetHashAndReset(Span<byte> destination);
+        public static byte[] HashData(byte[] key, byte[] source, int outputLength, byte[]? customizationString = null);
+        public static byte[] HashData(byte[] key, Stream source, int outputLength, byte[]? customizationString = null);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source, int outputLength, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static void HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static byte[] HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, int outputLength, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static void HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, int outputLength, byte[]? customizationString = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, int outputLength, ReadOnlyMemory<byte> customizationString = default(ReadOnlyMemory<byte>), CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, ReadOnlyMemory<byte> customizationString = default(ReadOnlyMemory<byte>), CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public sealed class KmacXof128 : IDisposable {
+        public KmacXof128(byte[] key, byte[]? customizationString = null);
+        public KmacXof128(ReadOnlySpan<byte> key, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static bool IsSupported { get; }
+        public void AppendData(byte[] data);
+        public void AppendData(ReadOnlySpan<byte> data);
+        public void Dispose();
+        public byte[] GetCurrentHash(int outputLength);
+        public void GetCurrentHash(Span<byte> destination);
+        public byte[] GetHashAndReset(int outputLength);
+        public void GetHashAndReset(Span<byte> destination);
+        public static byte[] HashData(byte[] key, byte[] source, int outputLength, byte[]? customizationString = null);
+        public static byte[] HashData(byte[] key, Stream source, int outputLength, byte[]? customizationString = null);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source, int outputLength, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static void HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static byte[] HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, int outputLength, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static void HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, int outputLength, byte[]? customizationString = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, int outputLength, ReadOnlyMemory<byte> customizationString = default(ReadOnlyMemory<byte>), CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, ReadOnlyMemory<byte> customizationString = default(ReadOnlyMemory<byte>), CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public sealed class KmacXof256 : IDisposable {
+        public KmacXof256(byte[] key, byte[]? customizationString = null);
+        public KmacXof256(ReadOnlySpan<byte> key, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static bool IsSupported { get; }
+        public void AppendData(byte[] data);
+        public void AppendData(ReadOnlySpan<byte> data);
+        public void Dispose();
+        public byte[] GetCurrentHash(int outputLength);
+        public void GetCurrentHash(Span<byte> destination);
+        public byte[] GetHashAndReset(int outputLength);
+        public void GetHashAndReset(Span<byte> destination);
+        public static byte[] HashData(byte[] key, byte[] source, int outputLength, byte[]? customizationString = null);
+        public static byte[] HashData(byte[] key, Stream source, int outputLength, byte[]? customizationString = null);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source, int outputLength, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static void HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static byte[] HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, int outputLength, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static void HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination, ReadOnlySpan<byte> customizationString = default(ReadOnlySpan<byte>));
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, int outputLength, byte[]? customizationString = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, int outputLength, ReadOnlyMemory<byte> customizationString = default(ReadOnlyMemory<byte>), CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, ReadOnlyMemory<byte> customizationString = default(ReadOnlyMemory<byte>), CancellationToken cancellationToken = default(CancellationToken));
+    }
 }
```

