# System

``` diff
 namespace System {
     public abstract class Array : ICloneable, ICollection, IEnumerable, IList, IStructuralComparable, IStructuralEquatable {
+        public static Array CreateInstanceFromArrayType(Type arrayType, int length);
+        public static Array CreateInstanceFromArrayType(Type arrayType, params int[] lengths);
+        public static Array CreateInstanceFromArrayType(Type arrayType, int[] lengths, int[] lowerBounds);
     }
     public static class BitConverter {
+        public static byte[] GetBytes(Int128 value);
+        public static byte[] GetBytes(UInt128 value);
+        public static Int128 ToInt128(byte[] value, int startIndex);
+        public static Int128 ToInt128(ReadOnlySpan<byte> value);
+        public static UInt128 ToUInt128(byte[] value, int startIndex);
+        public static UInt128 ToUInt128(ReadOnlySpan<byte> value);
+        public static bool TryWriteBytes(Span<byte> destination, Int128 value);
+        public static bool TryWriteBytes(Span<byte> destination, UInt128 value);
     }
     public static class Convert {
+        public static OperationStatus FromHexString(ReadOnlySpan<char> source, Span<byte> destination, out int charsConsumed, out int bytesWritten);
+        public static OperationStatus FromHexString(string source, Span<byte> destination, out int charsConsumed, out int bytesWritten);
+        public static string ToHexStringLower(byte[] inArray);
+        public static string ToHexStringLower(byte[] inArray, int offset, int length);
+        public static string ToHexStringLower(ReadOnlySpan<byte> bytes);
+        public static bool TryToHexString(ReadOnlySpan<byte> source, Span<char> destination, out int charsWritten);
+        public static bool TryToHexStringLower(ReadOnlySpan<byte> source, Span<char> destination, out int charsWritten);
     }
     public static class MemoryExtensions {
+        public static bool ContainsAny(this ReadOnlySpan<char> span, SearchValues<string> values);
+        public static bool ContainsAny(this Span<char> span, SearchValues<string> values);
+        public static int IndexOfAny(this ReadOnlySpan<char> span, SearchValues<string> values);
+        public static int IndexOfAny(this Span<char> span, SearchValues<string> values);
     }
     public abstract class Type : MemberInfo, IReflect {
+        public MethodInfo? GetMethod(string name, int genericParameterCount, BindingFlags bindingAttr, Type[] types);
     }
 }
```

