# System.ComponentModel.Design.Serialization

``` diff
 namespace System.ComponentModel.Design.Serialization {
     public abstract class BasicDesignerLoader : DesignerLoader, IDesignerLoaderService {
-        protected object PropertyProvider { get; set; }
+        protected object? PropertyProvider { get; set; }
-        protected object GetService(Type serviceType);
+        protected object? GetService(Type serviceType);
-        protected virtual void OnEndLoad(bool successful, ICollection errors);
+        protected virtual void OnEndLoad(bool successful, ICollection? errors);
-        void System.ComponentModel.Design.Serialization.IDesignerLoaderService.AddLoadDependency();
+        void IDesignerLoaderService.AddLoadDependency();
-        void System.ComponentModel.Design.Serialization.IDesignerLoaderService.DependentLoadComplete(bool successful, ICollection errorCollection);
+        void IDesignerLoaderService.DependentLoadComplete(bool successful, ICollection? errorCollection);
-        bool System.ComponentModel.Design.Serialization.IDesignerLoaderService.Reload();
+        bool IDesignerLoaderService.Reload();
     }
     public sealed class CodeDomComponentSerializationService : ComponentSerializationService {
-        public CodeDomComponentSerializationService(IServiceProvider provider);
+        public CodeDomComponentSerializationService(IServiceProvider? provider);
     }
     public abstract class CodeDomDesignerLoader : BasicDesignerLoader, IDesignerSerializationService, INameCreationService {
-        protected abstract CodeDomProvider CodeDomProvider { get; }
+        protected abstract CodeDomProvider? CodeDomProvider { get; }
-        protected abstract ITypeResolutionService TypeResolutionService { get; }
+        protected abstract ITypeResolutionService? TypeResolutionService { get; }
-        protected virtual void OnComponentRename(object component, string oldName, string newName);
+        protected virtual void OnComponentRename(object component, string? oldName, string? newName);
-        protected override void OnEndLoad(bool successful, ICollection errors);
+        protected override void OnEndLoad(bool successful, ICollection? errors);
-        ICollection System.ComponentModel.Design.Serialization.IDesignerSerializationService.Deserialize(object serializationData);
+        ICollection IDesignerSerializationService.Deserialize(object serializationData);
-        object System.ComponentModel.Design.Serialization.IDesignerSerializationService.Serialize(ICollection objects);
+        object IDesignerSerializationService.Serialize(ICollection? objects);
-        string System.ComponentModel.Design.Serialization.INameCreationService.CreateName(IContainer container, Type dataType);
+        string INameCreationService.CreateName(IContainer? container, Type dataType);
-        bool System.ComponentModel.Design.Serialization.INameCreationService.IsValidName(string name);
+        bool INameCreationService.IsValidName(string name);
-        void System.ComponentModel.Design.Serialization.INameCreationService.ValidateName(string name);
+        void INameCreationService.ValidateName(string name);
     }
     public sealed class CodeDomLocalizationProvider : IDesignerSerializationProvider, IDisposable {
-        public CodeDomLocalizationProvider(IServiceProvider provider, CodeDomLocalizationModel model, CultureInfo[] supportedCultures);
+        public CodeDomLocalizationProvider(IServiceProvider provider, CodeDomLocalizationModel model, CultureInfo?[] supportedCultures);
-        object System.ComponentModel.Design.Serialization.IDesignerSerializationProvider.GetSerializer(IDesignerSerializationManager manager, object currentSerializer, Type objectType, Type serializerType);
+        object? IDesignerSerializationProvider.GetSerializer(IDesignerSerializationManager manager, object? currentSerializer, Type? objectType, Type serializerType);
     }
     public class CollectionCodeDomSerializer : CodeDomSerializer {
-        public override object Serialize(IDesignerSerializationManager manager, object value);
+        public override object? Serialize(IDesignerSerializationManager manager, object value);
-        protected virtual object SerializeCollection(IDesignerSerializationManager manager, CodeExpression targetExpression, Type targetType, ICollection originalCollection, ICollection valuesToSerialize);
+        protected virtual object? SerializeCollection(IDesignerSerializationManager manager, CodeExpression? targetExpression, Type targetType, ICollection originalCollection, ICollection valuesToSerialize);
     }
     public class TypeCodeDomSerializer : CodeDomSerializerBase {
-        public virtual CodeTypeDeclaration Serialize(IDesignerSerializationManager manager, object root, ICollection members);
+        public virtual CodeTypeDeclaration Serialize(IDesignerSerializationManager manager, object root, ICollection? members);
     }
 }
```

