# System.ComponentModel.Design

``` diff
 namespace System.ComponentModel.Design {
     public sealed class BinaryEditor : UITypeEditor {
-        public override object EditValue(ITypeDescriptorContext context, IServiceProvider provider, object value);
+        public override object? EditValue(ITypeDescriptorContext? context, IServiceProvider provider, object? value);
-        public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext context);
+        public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext? context);
     }
     public class ByteViewer : TableLayoutPanel {
-        protected virtual void ScrollChanged(object source, EventArgs e);
+        protected virtual void ScrollChanged(object? source, EventArgs e);
     }
     public class CollectionEditor : UITypeEditor {
-        protected ITypeDescriptorContext Context { get; }
+        protected ITypeDescriptorContext? Context { get; }
-        public override object EditValue(ITypeDescriptorContext context, IServiceProvider provider, object value);
+        public override object? EditValue(ITypeDescriptorContext? context, IServiceProvider provider, object? value);
-        protected virtual string GetDisplayText(object value);
+        protected virtual string GetDisplayText(object? value);
-        public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext context);
+        public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext? context);
-        protected virtual object[] GetItems(object editValue);
+        protected virtual object[] GetItems(object? editValue);
-        protected virtual IList GetObjectsFromInstance(object instance);
+        protected virtual IList GetObjectsFromInstance(object? instance);
-        protected object GetService(Type serviceType);
+        protected object? GetService(Type serviceType);
-        protected virtual object SetItems(object editValue, object[] value);
+        protected virtual object? SetItems(object? editValue, object[]? value);
         protected abstract class CollectionForm : Form {
-            protected ITypeDescriptorContext Context { get; }
+            protected ITypeDescriptorContext? Context { get; }
-            protected override object GetService(Type serviceType);
+            protected override object? GetService(Type serviceType);
         }
     }
     public class ComponentDesigner : IComponentInitializer, IDesigner, IDesignerFilter, IDisposable, ITreeDesigner {
-        protected virtual InheritanceAttribute InheritanceAttribute { get; }
+        protected virtual InheritanceAttribute? InheritanceAttribute { get; }
-        protected virtual IComponent ParentComponent { get; }
+        protected virtual IComponent? ParentComponent { get; }
+        protected virtual bool SetTextualDefaultProperty { get; }
-        ICollection System.ComponentModel.Design.ITreeDesigner.Children { get; }
+        ICollection ITreeDesigner.Children { get; }
-        IDesigner System.ComponentModel.Design.ITreeDesigner.Parent { get; }
+        IDesigner? ITreeDesigner.Parent { get; }
-        protected virtual object GetService(Type serviceType);
+        protected virtual object? GetService(Type serviceType);
-        public virtual void InitializeExistingComponent(IDictionary defaultValues);
+        public virtual void InitializeExistingComponent(IDictionary? defaultValues);
-        public virtual void InitializeNewComponent(IDictionary defaultValues);
+        public virtual void InitializeNewComponent(IDictionary? defaultValues);
-        protected InheritanceAttribute InvokeGetInheritanceAttribute(ComponentDesigner toInvoke);
+        protected InheritanceAttribute? InvokeGetInheritanceAttribute(ComponentDesigner? toInvoke);
-        protected void RaiseComponentChanged(MemberDescriptor member, object oldValue, object newValue);
+        protected void RaiseComponentChanged(MemberDescriptor? member, object? oldValue, object? newValue);
-        protected void RaiseComponentChanging(MemberDescriptor member);
+        protected void RaiseComponentChanging(MemberDescriptor? member);
-        void System.ComponentModel.Design.IDesignerFilter.PostFilterAttributes(IDictionary attributes);
+        void IDesignerFilter.PostFilterAttributes(IDictionary attributes);
-        void System.ComponentModel.Design.IDesignerFilter.PostFilterEvents(IDictionary events);
+        void IDesignerFilter.PostFilterEvents(IDictionary events);
-        void System.ComponentModel.Design.IDesignerFilter.PostFilterProperties(IDictionary properties);
+        void IDesignerFilter.PostFilterProperties(IDictionary properties);
-        void System.ComponentModel.Design.IDesignerFilter.PreFilterAttributes(IDictionary attributes);
+        void IDesignerFilter.PreFilterAttributes(IDictionary attributes);
-        void System.ComponentModel.Design.IDesignerFilter.PreFilterEvents(IDictionary events);
+        void IDesignerFilter.PreFilterEvents(IDictionary events);
-        void System.ComponentModel.Design.IDesignerFilter.PreFilterProperties(IDictionary properties);
+        void IDesignerFilter.PreFilterProperties(IDictionary properties);
         protected sealed class ShadowPropertyCollection {
-            public object this[string propertyName] { get; set; }
+            public object? this[string propertyName] { get; set; }
         }
     }
+    public abstract class DataSourceDescriptor {
+        protected DataSourceDescriptor();
+        public abstract Bitmap Image { get; }
+        public abstract bool IsDesignable { get; }
+        public abstract string Name { get; }
+        public abstract string TypeName { get; }
+    }
+    public class DataSourceDescriptorCollection : CollectionBase {
+        public DataSourceDescriptorCollection();
+        public DataSourceDescriptor? this[int index] { get; set; }
+        public int Add(DataSourceDescriptor value);
+        public bool Contains(DataSourceDescriptor value);
+        public void CopyTo(DataSourceDescriptor[] array, int index);
+        public int IndexOf(DataSourceDescriptor value);
+        public void Insert(int index, DataSourceDescriptor value);
+        public void Remove(DataSourceDescriptor value);
+    }
+    public abstract class DataSourceGroup {
+        protected DataSourceGroup();
+        public abstract DataSourceDescriptorCollection DataSources { get; }
+        public abstract Bitmap Image { get; }
+        public abstract bool IsDefault { get; }
+        public abstract string Name { get; }
+    }
+    public class DataSourceGroupCollection : CollectionBase {
+        public DataSourceGroupCollection();
+        public DataSourceGroup? this[int index] { get; set; }
+        public int Add(DataSourceGroup value);
+        public bool Contains(DataSourceGroup value);
+        public void CopyTo(DataSourceGroup[] array, int index);
+        public int IndexOf(DataSourceGroup value);
+        public void Insert(int index, DataSourceGroup value);
+        public void Remove(DataSourceGroup value);
+    }
+    public abstract class DataSourceProviderService {
+        protected DataSourceProviderService();
+        public abstract bool SupportsAddNewDataSource { get; }
+        public abstract bool SupportsConfigureDataSource { get; }
+        public abstract object AddDataSourceInstance(IDesignerHost host, DataSourceDescriptor dataSourceDescriptor);
+        public abstract DataSourceGroupCollection GetDataSources();
+        public abstract DataSourceGroup InvokeAddNewDataSource(IWin32Window parentWindow, FormStartPosition startPosition);
+        public abstract bool InvokeConfigureDataSource(IWin32Window parentWindow, FormStartPosition startPosition, DataSourceDescriptor dataSourceDescriptor);
+        public abstract void NotifyDataSourceComponentAdded(object dsc);
+    }
     public class DesignerActionListCollection : CollectionBase {
-        public void AddRange(DesignerActionList?[] value);
+        public void AddRange(params DesignerActionList?[] value);
     }
     public class DesignerActionService : IDisposable {
-        public DesignerActionService(IServiceProvider serviceProvider);
+        public DesignerActionService(IServiceProvider? serviceProvider);
-        public event DesignerActionListsChangedEventHandler DesignerActionListsChanged;
+        public event DesignerActionListsChangedEventHandler? DesignerActionListsChanged;
     }
     public abstract class EventBindingService : IEventBindingService {
-        protected object GetService(Type serviceType);
+        protected object? GetService(Type serviceType);
-        string System.ComponentModel.Design.IEventBindingService.CreateUniqueMethodName(IComponent component, EventDescriptor e);
+        string IEventBindingService.CreateUniqueMethodName(IComponent component, EventDescriptor e);
-        ICollection System.ComponentModel.Design.IEventBindingService.GetCompatibleMethods(EventDescriptor e);
+        ICollection IEventBindingService.GetCompatibleMethods(EventDescriptor e);
-        EventDescriptor System.ComponentModel.Design.IEventBindingService.GetEvent(PropertyDescriptor property);
+        EventDescriptor? IEventBindingService.GetEvent(PropertyDescriptor property);
-        PropertyDescriptorCollection System.ComponentModel.Design.IEventBindingService.GetEventProperties(EventDescriptorCollection events);
+        PropertyDescriptorCollection IEventBindingService.GetEventProperties(EventDescriptorCollection events);
-        PropertyDescriptor System.ComponentModel.Design.IEventBindingService.GetEventProperty(EventDescriptor e);
+        PropertyDescriptor IEventBindingService.GetEventProperty(EventDescriptor e);
-        bool System.ComponentModel.Design.IEventBindingService.ShowCode();
+        bool IEventBindingService.ShowCode();
-        bool System.ComponentModel.Design.IEventBindingService.ShowCode(IComponent component, EventDescriptor e);
+        bool IEventBindingService.ShowCode(IComponent component, EventDescriptor e);
-        bool System.ComponentModel.Design.IEventBindingService.ShowCode(int lineNumber);
+        bool IEventBindingService.ShowCode(int lineNumber);
     }
     public class MenuCommandService : IDisposable, IMenuCommandService {
-        public MenuCommandService(IServiceProvider serviceProvider);
+        public MenuCommandService(IServiceProvider? serviceProvider);
-        public event MenuCommandsChangedEventHandler MenuCommandsChanged;
+        public event MenuCommandsChangedEventHandler? MenuCommandsChanged;
-        public MenuCommand FindCommand(CommandID commandID);
+        public MenuCommand? FindCommand(CommandID commandID);
-        protected MenuCommand FindCommand(Guid guid, int id);
+        protected MenuCommand? FindCommand(Guid guid, int id);
-        protected ICollection GetCommandList(Guid guid);
+        protected ICollection? GetCommandList(Guid guid);
-        protected object GetService(Type serviceType);
+        protected object? GetService(Type serviceType);
     }
 }
```

