# .NET 9 Preview 2 Binaries

.NET 9 Preview 2 installers and binaries can be downloaded for the following product versions:

- `.NET 9.0.0 Preview 2`
- `.NET SDK 9.0.100-preview.2.24157.14`

See [README.md](README.md) for .NET 9 release notes and discussions.

The latest .NET releases are always listed at [.NET Releases](../../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
9.0.100-preview.2.24157.14
```

## .NET Multi-Platform App UI (MAUI) Workload Downloads

 After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

 ```console
 $ dotnet workload install maui
 ```

 The following workloads are also available to install individually:

 ```console
 $ dotnet workload install android
 $ dotnet workload install ios
 $ dotnet workload install maccatalyst
 $ dotnet workload install macos
 $ dotnet workload install tvos
 ```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 9.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

.NET 9 is compatible with  [Visual Studio 17.10 latest preview](https://visualstudio.microsoft.com) Users will have to [download](https://dotnet.microsoft.com/download/dotnet/9.0) and install the .NET 9 runtime/sdk standalone. Visual Studio for Mac is currently not supported for .NET 9.0 Preview releases.


## Feedback

Your feedback is important and appreciated. We've created an issue at https://aka.ms/dotnet/9/preview2 for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.Windows.Compatibility | 9.0.0-preview.2.24128.10
Microsoft.WindowsDesktop.App.Ref | 9.0.0-preview.2.24128.10
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 9.0.0-preview.2.24128.10
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 9.0.0-preview.2.24128.10
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 9.0.0-preview.2.24128.10
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.DotNet.ILCompiler | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Configuration.Binder | 9.0.0-preview.2.24128.5
Microsoft.Extensions.FileSystemGlobbing | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Hosting.Abstractions | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Logging.TraceSource | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Http | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Logging | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Logging.Abstractions | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.linux-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.wasi-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.wasi-wasm.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 9.0.0-preview.2.24128.5
dotnet-ilverify | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-preview.2.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Crossgen2.osx-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Crossgen2.win-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.linux-bionic-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.linux-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.linux-musl-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.osx-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.win-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.browser-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.ILAsm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.ILDAsm | 9.0.0-preview.2.24128.5
Microsoft.Win32.Registry.AccessControl | 9.0.0-preview.2.24128.5
Microsoft.XmlSerializer.Generator | 9.0.0-preview.2.24128.5
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.2.24128.5
runtime.linux-musl-arm.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.osx-arm64.Microsoft.NETCore.ILAsm | 9.0.0-preview.2.24128.5
runtime.osx-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.2.24128.5
System.IO.Packaging | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.win-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.win-x86 | 9.0.0-preview.2.24128.5
runtime.android-arm.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.linux-musl-arm.Microsoft.DotNet.ILCompiler | 9.0.0-preview.2.24128.5
runtime.android-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.android-x64.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.2.24128.5
runtime.linux-arm.Microsoft.NETCore.ILDAsm | 9.0.0-preview.2.24128.5
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.2.24128.5
runtime.osx-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
System.DirectoryServices.AccountManagement | 9.0.0-preview.2.24128.5
System.Diagnostics.EventLog | 9.0.0-preview.2.24128.5
System.Net.Http.WinHttpHandler | 9.0.0-preview.2.24128.5
System.Numerics.Tensors | 9.0.0-preview.2.24128.5
System.Runtime.Caching | 9.0.0-preview.2.24128.5
System.Reflection.Metadata | 9.0.0-preview.2.24128.5
System.Reflection.MetadataLoadContext | 9.0.0-preview.2.24128.5
System.Windows.Extensions | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Primitives | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.MonoTargets.Sdk | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.wasm.Sample.Mono | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.WebAssembly.Templates | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Crossgen2.linux-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-preview.2.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-preview.2.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-preview.2.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-preview.2.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-preview.2.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-preview.2.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-preview.2 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Crossgen2.win-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.linux-musl-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.osx-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.win-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.browser-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.browser-wasm.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.linux-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-musl-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.win-arm64 | 9.0.0-preview.2.24128.5
runtime.linux-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.linux-bionic-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.linux-bionic-x64.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.linux-musl-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.2.24128.5
runtime.linux-musl-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.linux-musl-x64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.2.24128.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
runtime.linux-musl-x64.Microsoft.NETCore.ILAsm | 9.0.0-preview.2.24128.5
runtime.linux-x64.Microsoft.NETCore.ILAsm | 9.0.0-preview.2.24128.5
runtime.maccatalyst-x64.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.linux-x64.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.win-x64.Microsoft.NETCore.ILAsm | 9.0.0-preview.2.24128.5
System.ComponentModel.Composition | 9.0.0-preview.2.24128.5
System.ComponentModel.Composition.Registration | 9.0.0-preview.2.24128.5
System.Composition.TypedParts | 9.0.0-preview.2.24128.5
Microsoft.Bcl.Numerics | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Configuration.Ini | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Configuration.Abstractions | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Configuration | 9.0.0-preview.2.24128.5
Microsoft.Extensions.DependencyInjection | 9.0.0-preview.2.24128.5
Microsoft.Extensions.DependencyInjection.Abstractions | 9.0.0-preview.2.24128.5
Microsoft.Extensions.DependencyModel | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Diagnostics | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Hosting.Systemd | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Diagnostics.Abstractions | 9.0.0-preview.2.24128.5
Microsoft.Extensions.FileProviders.Abstractions | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Options | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NET.WebAssembly.Threading | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-preview.2.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-preview.2 | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-preview.2 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.win-x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.wasi-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 9.0.0-preview.2.24128.5
runtime.linux-arm.Microsoft.NETCore.ILAsm | 9.0.0-preview.2.24128.5
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
runtime.linux-musl-arm.Microsoft.NETCore.ILAsm | 9.0.0-preview.2.24128.5
runtime.linux-musl-arm.Microsoft.NETCore.ILDAsm | 9.0.0-preview.2.24128.5
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.2.24128.5
runtime.osx-x64.Microsoft.NETCore.ILAsm | 9.0.0-preview.2.24128.5
runtime.osx-x64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.2.24128.5
runtime.osx-x64.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
System.Data.Odbc | 9.0.0-preview.2.24128.5
System.DirectoryServices | 9.0.0-preview.2.24128.5
System.Configuration.ConfigurationManager | 9.0.0-preview.2.24128.5
System.Diagnostics.DiagnosticSource | 9.0.0-preview.2.24128.5
System.DirectoryServices.Protocols | 9.0.0-preview.2.24128.5
System.IO.Pipelines | 9.0.0-preview.2.24128.5
System.Memory.Data | 9.0.0-preview.2.24128.5
System.Net.Http.Json | 9.0.0-preview.2.24128.5
System.Security.Cryptography.Cose | 9.0.0-preview.2.24128.5
System.Security.Cryptography.Xml | 9.0.0-preview.2.24128.5
System.ServiceProcess.ServiceController | 9.0.0-preview.2.24128.5
System.Threading.AccessControl | 9.0.0-preview.2.24128.5
System.Text.Encoding.CodePages | 9.0.0-preview.2.24128.5
System.Text.Encodings.Web | 9.0.0-preview.2.24128.5
System.Threading.Channels | 9.0.0-preview.2.24128.5
System.Threading.RateLimiting | 9.0.0-preview.2.24128.5
System.Threading.Tasks.Dataflow | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Configuration.CommandLine | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Configuration.Xml | 9.0.0-preview.2.24128.5
Microsoft.Extensions.DependencyInjection.Specification.Tests | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Configuration.EnvironmentVariables | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Configuration.FileExtensions | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Configuration.UserSecrets | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Configuration.Json | 9.0.0-preview.2.24128.5
Microsoft.Extensions.FileProviders.Composite | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Hosting.WindowsServices | 9.0.0-preview.2.24128.5
Microsoft.Extensions.FileProviders.Physical | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Hosting | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.iOS.Sample.Mono | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.WebAssembly.Sdk | 9.0.0-preview.2.24128.5
Microsoft.NET.Sdk.IL | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-preview.2.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-preview.2.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-preview.2.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-preview.2.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Crossgen2.linux-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.linux-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.linux-musl-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Host.linux-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Ref | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.wasi-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.wasi-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.wasi-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x86.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.browser-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.wasi-wasm.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 9.0.0-preview.2.24128.5
runtime.linux-arm.Microsoft.DotNet.ILCompiler | 9.0.0-preview.2.24128.5
runtime.linux-arm64.Microsoft.NETCore.ILAsm | 9.0.0-preview.2.24128.5
runtime.linux-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.2.24128.5
runtime.linux-musl-arm64.Microsoft.NETCore.ILAsm | 9.0.0-preview.2.24128.5
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.2.24128.5
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
runtime.linux-x64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.2.24128.5
runtime.win-x64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.2.24128.5
runtime.win-x86.Microsoft.NETCore.ILAsm | 9.0.0-preview.2.24128.5
runtime.win-x86.Microsoft.NETCore.ILDAsm | 9.0.0-preview.2.24128.5
System.CodeDom | 9.0.0-preview.2.24128.5
System.Composition | 9.0.0-preview.2.24128.5
System.Composition.Hosting | 9.0.0-preview.2.24128.5
System.Diagnostics.PerformanceCounter | 9.0.0-preview.2.24128.5
System.Formats.Cbor | 9.0.0-preview.2.24128.5
System.Formats.Asn1 | 9.0.0-preview.2.24128.5
System.IO.Ports | 9.0.0-preview.2.24128.5
System.Management | 9.0.0-preview.2.24128.5
System.IO.Hashing | 9.0.0-preview.2.24128.5
System.Reflection.Context | 9.0.0-preview.2.24128.5
System.Runtime.Serialization.Schema | 9.0.0-preview.2.24128.5
System.Resources.Extensions | 9.0.0-preview.2.24128.5
System.Speech | 9.0.0-preview.2.24128.5
System.ServiceModel.Syndication | 9.0.0-preview.2.24128.5
System.Security.Cryptography.Pkcs | 9.0.0-preview.2.24128.5
System.Security.Cryptography.ProtectedData | 9.0.0-preview.2.24128.5
System.Security.Permissions | 9.0.0-preview.2.24128.5
System.Text.Json | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-musl-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.osx-x64 | 9.0.0-preview.2.24128.5
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
runtime.maccatalyst-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.2.24128.5
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.2.24128.5
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
runtime.win-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.2.24128.5
System.Collections.Immutable | 9.0.0-preview.2.24128.5
System.Composition.AttributedModel | 9.0.0-preview.2.24128.5
System.Composition.Convention | 9.0.0-preview.2.24128.5
System.Composition.Runtime | 9.0.0-preview.2.24128.5
System.Data.OleDb | 9.0.0-preview.2.24128.5
Microsoft.Bcl.Cryptography | 9.0.0-preview.2.24128.5
Microsoft.Bcl.AsyncInterfaces | 9.0.0-preview.2.24128.5
Microsoft.Bcl.TimeProvider | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Caching.Abstractions | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Caching.Memory | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Logging.Configuration | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Logging.Debug | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Logging.Console | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Options.DataAnnotations | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Logging.EventLog | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Logging.EventSource | 9.0.0-preview.2.24128.5
Microsoft.Extensions.Options.ConfigurationExtensions | 9.0.0-preview.2.24128.5
Microsoft.ILVerification | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.Android.Sample.Mono | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 9.0.0-preview.2.24128.5
Microsoft.NET.ILLink.Tasks | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NET.Sdk.WebAssembly.Pack | 9.0.0-preview.2.24128.5
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-preview.2 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Crossgen2.win-x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.wasi-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.wasi-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.wasi-wasm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.linux-musl-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.linux-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-musl-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.win-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.win-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
Microsoft.Win32.SystemEvents | 9.0.0-preview.2.24128.5
runtime.android-x86.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.win-arm64.Microsoft.NETCore.ILAsm | 9.0.0-preview.2.24128.5
runtime.win-x64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.android-arm | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 9.0.0-preview.2.24128.5
Microsoft.NETCore.App.Runtime.osx-arm64 | 9.0.0-preview.2.24128.5
runtime.linux-arm.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.2.24128.5
runtime.linux-musl-x64.runtime.native.System.IO.Ports | 9.0.0-preview.2.24128.5
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.App.Runtime.win-x64 | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Authentication.JwtBearer | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Authentication.Negotiate | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Authentication.Twitter | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Authentication.WsFederation | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components.Authorization | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components.CustomElements | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components.Analyzers | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components.WebAssembly.Server | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components.QuickGrid | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components.WebAssembly | 9.0.0-preview.2.24128.4
AspNetCoreRuntime.9.0.x86 | 9.0.0-preview-2-24128-4
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.App.Runtime.linux-x64 | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.App.Runtime.osx-x64 | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Authentication.Certificate | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.App.Runtime.win-arm64 | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Authentication.Google | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Authentication.OpenIdConnect | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components.Forms | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components.Web | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Grpc.JsonTranscoding | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Grpc.Swagger.0 | 9.0-preview.2.24128.4
Microsoft.AspNetCore.HeaderPropagation | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Identity.UI | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Hosting.WindowsServices | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Http.Connections.Client | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Http.Connections.Common | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.OpenApi | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.SignalR.Client.Core | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.SignalR.Protocols.Json | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Caching.SqlServer | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Diagnostics.HealthChecks | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Identity.Core | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 9.0.0-preview.2.24128.4
dotnet-sql-cache | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.App.Runtime.win-x86 | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Authorization | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.AzureAppServicesIntegration | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components.WebView | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Connections.Abstractions | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Metadata | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.SpaProxy | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.TestHost | 9.0.0-preview.2.24128.4
Microsoft.Extensions.ApiDescription.Server | 9.0.0-preview.2.24128.4
Microsoft.DotNet.Web.ItemTemplates | 9.0 | 9.0.0-preview.2.24128.4
Microsoft.DotNet.Web.ProjectTemplates | 9.0 | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Http.Polly | 9.0.0-preview.2.24128.4
Microsoft.Net.Http.Headers | 9.0.0-preview.2.24128.4
Microsoft.Extensions.ObjectPool | 9.0.0-preview.2.24128.4
Microsoft.JSInterop | 9.0.0-preview.2.24128.4
Microsoft.JSInterop.WebAssembly | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Cryptography.KeyDerivation | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.JsonPatch | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.MiddlewareAnalysis | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.SignalR.Client | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.SignalR.Common | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.SpaServices.Extensions | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.SignalR.Specification.Tests | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.WebUtilities | 9.0.0-preview.2.24128.4
Microsoft.dotnet-openapi | 9.0.0-preview.2.24128.4
Microsoft.Authentication.WebAssembly.Msal | 9.0.0-preview.2.24128.4
Microsoft.DotNet.Web.Client.ItemTemplates | 9.0.0-preview.2.24128.4
Microsoft.Extensions.ApiDescription.Client | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Configuration.KeyPerFile | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Features | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Caching.StackExchangeRedis | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Localization | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Localization.Abstractions | 9.0.0-preview.2.24128.4
AspNetCoreRuntime.9.0.x64 | 9.0.0-preview-2-24128-4
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.App.Runtime.linux-arm | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.App.Ref | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Authentication.Facebook | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.ConcurrencyLimiter | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.DataProtection | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Cryptography.Internal | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.DataProtection.Abstractions | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.DataProtection.Extensions | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Mvc.Testing | 9.0.0-preview.2.24128.4
Microsoft.AspNetCore.Owin | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 9.0.0-preview.2.24128.4
Microsoft.Extensions.FileProviders.Embedded | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Identity.Stores | 9.0.0-preview.2.24128.4
Microsoft.Extensions.Logging.AzureAppServices | 9.0.0-preview.2.24128.4
Microsoft.Extensions.WebEncoders | 9.0.0-preview.2.24128.4
FSharp.Compiler.Service | 43.8.300-preview.24154.4
Microsoft.NET.Build.Containers | 9.0.100-preview.2.24157.36
Microsoft.DotNet.Common.ProjectTemplates | 9.0 | 9.0.100-preview.2.24157.36
Microsoft.DotNet.ApiCompat.Tool | 9.0.100-preview.2.24157.36
Microsoft.DotNet.ApiCompat.Task | 9.0.100-preview.2.24157.36
FSharp.Core | 8.0.300-beta.24154.4
Microsoft.DotNet.Common.ItemTemplates | 9.0.100-preview.2.24157.36
System.Drawing.Common | 9.0.0-preview.2.24128.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-musl-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-preview.2.Msi.x86 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-musl-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-musl-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-musl-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-musl-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-preview.2.Msi.x86 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-preview.2.Msi.x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-preview.2.Msi.arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-preview.2.Msi.x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-preview.2.Msi.arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-preview.2.Msi.x86 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-musl-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-preview.2.Msi.arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-preview.2.Msi.x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-preview.2.Msi.arm64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-preview.2.Msi.x86 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-preview.2 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-preview.2.Msi.x64 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-preview.2 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-preview.2 | 9.0.0-preview.2.24123.4
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-preview.2 | 9.0.0-preview.2.24123.4
Microsoft.EntityFrameworkCore | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Analyzers | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Cosmos | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Proxies | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Sqlite | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.SqlServer | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Templates | 9.0.0-preview.2.24128.4
Microsoft.Data.Sqlite.Core | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Abstractions | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Specification.Tests | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.InMemory | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Design | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Relational | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Sqlite.Core | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.Tools | 9.0.0-preview.2.24128.4
dotnet-ef | 9.0.0-preview.2.24128.4
Microsoft.Data.Sqlite | 9.0.0-preview.2.24128.4
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 9.0.0-preview.2.24128.4
Microsoft.TemplateEngine.Authoring.CLI | 9.0.100-preview.2.24128.3
Microsoft.TemplateEngine.Abstractions | 9.0.100-preview.2.24128.3
Microsoft.TemplateEngine.Authoring.Templates | 9.0.100-preview.2.24128.3
Microsoft.TemplateEngine.Authoring.Tasks | 9.0.100-preview.2.24128.3
Microsoft.TemplateEngine.Core.Contracts | 9.0.100-preview.2.24128.3
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 9.0.100-preview.2.24128.3
Microsoft.TemplateEngine.IDE | 9.0.100-preview.2.24128.3
Microsoft.TemplateEngine.TemplateLocalizer.Core | 9.0.100-preview.2.24128.3
Microsoft.TemplateEngine.Edge | 9.0.100-preview.2.24128.3
Microsoft.TemplateSearch.Common | 9.0.100-preview.2.24128.3
Microsoft.TemplateEngine.Core | 9.0.100-preview.2.24128.3
Microsoft.TemplateEngine.Samples | 9.0.100-preview.2.24128.3
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 9.0.100-preview.2.24128.3
Microsoft.TemplateEngine.Utils | 9.0.100-preview.2.24128.3
Microsoft.CodeAnalysis.Metrics | 4.0.0-beta1.24122.1
Microsoft.CodeAnalysis.Analyzers | 3.11.0-beta1.24122.1
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter | 3.11.0-beta1.24122.1
Microsoft.CodeAnalysis.AnalyzerUtilities | 3.11.0-beta1.24122.1
Microsoft.CodeAnalysis.NetAnalyzers | 9.0.0-preview.24122.1
Text.Analyzers | 3.11.0-beta1.24122.1
Microsoft.CodeAnalysis.ResxSourceGenerator | 3.11.0-beta1.24122.1
Microsoft.CodeAnalysis.PublicApiAnalyzers | 3.11.0-beta1.24122.1
Roslyn.Diagnostics.Analyzers | 3.11.0-beta1.24122.1
Microsoft.CodeAnalysis.BannedApiAnalyzers | 3.11.0-beta1.24122.1
Microsoft.CodeAnalysis.PerformanceSensitiveAnalyzers | 3.11.0-beta1.24122.1



[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 9.0.0-preview.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/9.0.0-preview.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/9.0.0-preview.2-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: ../../install-linux.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-9-preview-2
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-9-preview-2/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef9-preview-1/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A9.0.0-preview2+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A9.0.0-preview2+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A9.0.0-preview2+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A9.0.0-preview2+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A9.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A9.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A9.0.1xx
[linux-packages]: ../../install-linux.md


[//]: # ( Runtime 9.0.0-preview.2.24128.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b8a2b8f8-4499-450c-81e6-a54654e3e8c4/4c148cdfdce492949538fdcf478b72a5/dotnet-runtime-9.0.0-preview.2.24128.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ab7bbaf3-c61e-481d-8dbf-b0dc2bcc80f6/0467f280265fe3b33ddcd345b04cdfa1/dotnet-runtime-9.0.0-preview.2.24128.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95ae0189-d474-4d1e-b47b-32999c6c9b96/aef82d9a69aa8ba7563eee2b64324dde/dotnet-runtime-9.0.0-preview.2.24128.5-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ec450edb-1042-432e-9a15-211c3aa63f73/99dea9857c948437ebc0d18c0466f596/dotnet-runtime-9.0.0-preview.2.24128.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ee7ee86-0913-4a6e-886c-287b5c315645/49775cbe375d6544da49676b68595ad4/dotnet-runtime-9.0.0-preview.2.24128.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3d7900df-fefb-4aba-8dbc-e3d755111a85/c849ddf0290aeae485414ba46ad961c3/dotnet-runtime-9.0.0-preview.2.24128.5-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/943e433f-88c2-4e0b-a56d-44fba4946e1e/809ebff77cf2e17f2d9146df174fddeb/dotnet-runtime-9.0.0-preview.2.24128.5-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6401083b-8213-431e-94b3-bb1bba37d792/551aca92ab4da13513ead1e7865d57e2/dotnet-runtime-9.0.0-preview.2.24128.5-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/018b25f2-3017-4750-b7d4-aa5feac985d0/46eec7638b52e3179eafe00d17e8c448/dotnet-runtime-9.0.0-preview.2.24128.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8ccc8b00-80b0-48c4-9948-9adfa67f42e3/b93918f628eee154b3400fe05774d1be/dotnet-runtime-9.0.0-preview.2.24128.5-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e34ab999-b734-4d28-9811-c850e7efa475/e8ee49da3fe00f64d7974e2a9229bdf9/dotnet-runtime-9.0.0-preview.2.24128.5-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1b52f101-5fc6-4de8-b929-79c152dd976d/b332a49ecbffbfecf6c175d9d0c28d2d/dotnet-runtime-9.0.0-preview.2.24128.5-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c00df4a5-6d92-4704-ac31-ae10be42083a/41aa5cd5ebe827a4138ab662c31da899/dotnet-runtime-9.0.0-preview.2.24128.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/148ff15b-93e9-43a5-b9a0-19be5f5918c0/c2793ee38f227acac267234877e0bcac/dotnet-runtime-9.0.0-preview.2.24128.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cbb27466-67aa-4847-aea5-6c81d1d16dc7/a302106d0792a83c1fdfec62466fdffa/dotnet-runtime-9.0.0-preview.2.24128.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7101e9b8-6446-42a8-8ef6-2a9806db83cc/338af40210ac0a98c56ddcc904f09862/dotnet-runtime-9.0.0-preview.2.24128.5-win-x86.zip

[//]: # ( WindowsDesktop 9.0.0-preview.2.24128.10)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/7636b226-87e1-4d09-b758-c71b375b1bcc/ae993e6825615dfe90ec796c3fea0bad/windowsdesktop-runtime-9.0.0-preview.2.24128.10-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/5b6ce66b-ad59-445d-a46d-b94fc74e665d/90a22ecdb847711b7b765310b63e01ad/windowsdesktop-runtime-9.0.0-preview.2.24128.10-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/860c2219-3f1f-4948-925a-1d463ae23801/092fdd99190bf61c37eaea1b5b034305/windowsdesktop-runtime-9.0.0-preview.2.24128.10-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/cc5408ce-a9da-458c-ba58-65fd4dfb47ea/57a22113ce6b45f0880f391efb953cdd/windowsdesktop-runtime-9.0.0-preview.2.24128.10-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9914baa5-6682-45df-8dfd-6098376d0ee6/4b7d697197ddb6929f00778759f09275/windowsdesktop-runtime-9.0.0-preview.2.24128.10-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2d3eae09-04af-41ad-8072-ba414988dd87/a725bb2c98fd8a56412e4c1a9e61fa98/windowsdesktop-runtime-9.0.0-preview.2.24128.10-win-x86.zip

[//]: # ( ASP 9.0.0-preview.2.24128.4)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/69ca0164-e58a-4777-b1e9-0bd15a372b40/51284f988bdd4dc653eea820484a071c/aspnetcore-runtime-9.0.0-preview.2.24128.4-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cb8d7d43-e403-44b3-9ee8-477a947f3e6b/3e38a543b6b9144e0fed12cf18eae7f9/aspnetcore-runtime-9.0.0-preview.2.24128.4-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97bcbe77-6b0f-44f7-9a01-a3110308bcf8/469574afbddd9432bf1f4b9f9078c919/aspnetcore-runtime-9.0.0-preview.2.24128.4-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/948610d8-af3c-4c0c-84f1-65cf3b9bfbad/226982b96d52f4147bcd36d9a2133cad/aspnetcore-runtime-9.0.0-preview.2.24128.4-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/59a764e6-bc1a-4aba-95d3-15e94a3aba0b/18f5fd10635db63df24fc2592f7cf65b/aspnetcore-runtime-9.0.0-preview.2.24128.4-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e3e81a61-4493-433a-ac40-ce2bceb3370d/ce1c59a7054d200dd24a7e4987666b8c/aspnetcore-runtime-9.0.0-preview.2.24128.4-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9f27cd5d-334b-4dfe-8876-33186210815a/2752edc7662b603b734219e4fee20ba0/aspnetcore-runtime-9.0.0-preview.2.24128.4-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dbbdbf43-8860-4aae-b1aa-57d44f976cc8/f4f6c6c4a740de95a332ed2c693d1d6f/aspnetcore-runtime-9.0.0-preview.2.24128.4-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/049903fc-4c2d-4236-85cd-87951ea9de7f/0f0aec1fb155fa09f61ed86cd26b6b6e/aspnetcore-runtime-9.0.0-preview.2.24128.4-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c2a880ed-96d2-4060-9132-5343b8fdb539/dda51332250362edb5c59047e925f556/aspnetcore-runtime-9.0.0-preview.2.24128.4-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/872b0c60-bd0a-4fed-a744-b265f13fff25/160c69de96951aed473bdb0570352322/aspnetcore-runtime-9.0.0-preview.2.24128.4-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cbf688a5-c777-476d-a47d-6b532848fd71/5034e38cef71b22c4d0a6fcd19db9840/aspnetcore-runtime-9.0.0-preview.2.24128.4-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9f46c914-c6ec-437e-8769-81a5c7d372e4/e3e5847261a6b71742a74fb47331d20f/aspnetcore-runtime-9.0.0-preview.2.24128.4-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1b3ae66-ed5f-46db-a1da-a3aa6f379a10/449d2758801ca01a21baa296edebf9d4/aspnetcore-runtime-composite-9.0.0-preview.2.24128.4-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3651a71-c7b5-445c-aa96-fbb473513f68/d23dc7326deba60db789acec02afd4b2/aspnetcore-runtime-composite-9.0.0-preview.2.24128.4-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd404332-ec4e-4d97-9cd9-007d9d185904/3e1e4ce502178d132adf8f68904c9002/aspnetcore-runtime-composite-9.0.0-preview.2.24128.4-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4f59418a-e794-4cbd-83ba-28caf49ffab6/895663c4eb1a594f37015a79d5a6c57a/aspnetcore-runtime-composite-9.0.0-preview.2.24128.4-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f8b9b876-af92-4182-9eeb-075f9c10903b/780b103d20efe7b3aa0b5baea30c93c5/aspnetcore-runtime-composite-9.0.0-preview.2.24128.4-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/285f7beb-77ed-41d2-88df-9b13831a8a6e/5ec67e65df1f9c869af24fdcbe43bd60/aspnetcore-runtime-composite-9.0.0-preview.2.24128.4-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/bab2ec4f-c930-44be-9b7d-38b9f837b3af/5ad4812b54c7588622b9eb10fd0de616/dotnet-hosting-9.0.0-preview.2.24128.4-win.exe

[//]: # ( SDK 9.0.100-preview.2.24157.14)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c2602262-2aba-4921-81f0-640ec8200c5e/7eac075f28a6817086891867c5058ae2/dotnet-sdk-9.0.100-preview.2.24157.14-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b64ba1b3-ad10-40a2-b588-73db9ed9d99d/f772743c20f55a5a8aea3da2e1480676/dotnet-sdk-9.0.100-preview.2.24157.14-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/daa714fa-cd09-40ef-94ef-7f7785e312d3/a0a4d29f8508ce756185f682ff1acb47/dotnet-sdk-9.0.100-preview.2.24157.14-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/48c6b988-5bb3-431d-b8d8-f03a1607ae06/6d0fb991e397020332cd09deb21fee15/dotnet-sdk-9.0.100-preview.2.24157.14-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e9eeb6eb-889b-46f6-a5b5-63d985747b66/a7aab27d12efd89d1d387727a32bc2f3/dotnet-sdk-9.0.100-preview.2.24157.14-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/911f82cf-0f87-46c2-8d70-44fab9a0f3c9/137ec23686722b8119bd62def8d7b117/dotnet-sdk-9.0.100-preview.2.24157.14-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ea918db8-961f-4b46-9457-00eddc6289e7/8c9b1472a0dd4d12702f598ac017617d/dotnet-sdk-9.0.100-preview.2.24157.14-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30628efc-01f0-468d-baf1-fc487e55093a/4c2bf86dbebb6c522d4d667516dc5930/dotnet-sdk-9.0.100-preview.2.24157.14-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/077d24e5-df1c-40fa-8204-cd601e0b3465/44de36d04f570e120f4f47debe33b839/dotnet-sdk-9.0.100-preview.2.24157.14-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d2259a0-cb6e-4079-96fa-e0de6f0448c5/9b299e3cc15adf6153c28c24cba35fef/dotnet-sdk-9.0.100-preview.2.24157.14-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b9e31f8c-0bf0-4895-9c79-8baffc8530ef/b2db38465ee04fecbad4a970422681c2/dotnet-sdk-9.0.100-preview.2.24157.14-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/41c79f6f-30d8-4b2f-a15a-c098084dc78b/e46437cd6d1bca934eeba50a70a33bf7/dotnet-sdk-9.0.100-preview.2.24157.14-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e120265e-8b49-4faf-ae33-7828bbec8375/8d607b56fb4d92f8c456eff315d3d687/dotnet-sdk-9.0.100-preview.2.24157.14-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1e952733-b58e-4d72-808b-4b6cafec490e/04fbd6374d14a95bebdf500b47e12098/dotnet-sdk-9.0.100-preview.2.24157.14-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/af6eaf7a-e53e-4787-a61d-74cdb048b2c0/81cdad4a45ebaebf4881ae1a5a944c49/dotnet-sdk-9.0.100-preview.2.24157.14-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/db55584c-9ba6-42d4-a946-545993e2ec07/a5ccf36a2217b8476337d2ad5f547b87/dotnet-sdk-9.0.100-preview.2.24157.14-win-x86.zip
