# System.Runtime.Intrinsics.X86

``` diff
 namespace System.Runtime.Intrinsics.X86 {
     public abstract class Avx512DQ : Avx512F {
+        public static Vector256<float> ConvertToVector256Single(Vector512<long> value, FloatRoundingMode mode);
+        public static Vector256<float> ConvertToVector256Single(Vector512<ulong> value, FloatRoundingMode mode);
+        public static Vector512<double> ConvertToVector512Double(Vector512<long> value, FloatRoundingMode mode);
+        public static Vector512<double> ConvertToVector512Double(Vector512<ulong> value, FloatRoundingMode mode);
+        public static Vector512<long> ConvertToVector512Int64(Vector256<float> value, FloatRoundingMode mode);
+        public static Vector512<long> ConvertToVector512Int64(Vector512<double> value, FloatRoundingMode mode);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector256<float> value, FloatRoundingMode mode);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector512<double> value, FloatRoundingMode mode);
     }
     public abstract class Avx512F : Avx2 {
+        public static Vector512<float> Add(Vector512<float> left, Vector512<float> right, FloatRoundingMode mode);
+        public static Vector128<double> AddScalar(Vector128<double> left, Vector128<double> right, FloatRoundingMode mode);
+        public static Vector128<float> AddScalar(Vector128<float> left, Vector128<float> right, FloatRoundingMode mode);
+        public static Vector128<float> ConvertScalarToVector128Single(Vector128<float> upper, int value, FloatRoundingMode mode);
+        public static Vector128<float> ConvertScalarToVector128Single(Vector128<float> upper, Vector128<double> value, FloatRoundingMode mode);
+        public static Vector128<float> ConvertScalarToVector128Single(Vector128<float> upper, uint value, FloatRoundingMode mode);
+        public static int ConvertToInt32(Vector128<double> value, FloatRoundingMode mode);
+        public static int ConvertToInt32(Vector128<float> value, FloatRoundingMode mode);
+        public static uint ConvertToUInt32(Vector128<double> value, FloatRoundingMode mode);
+        public static uint ConvertToUInt32(Vector128<float> value, FloatRoundingMode mode);
+        public static Vector256<int> ConvertToVector256Int32(Vector512<double> value, FloatRoundingMode mode);
+        public static Vector256<float> ConvertToVector256Single(Vector512<double> value, FloatRoundingMode mode);
+        public static Vector256<uint> ConvertToVector256UInt32(Vector512<double> value, FloatRoundingMode mode);
+        public static Vector512<int> ConvertToVector512Int32(Vector512<float> value, FloatRoundingMode mode);
+        public static Vector512<float> ConvertToVector512Single(Vector512<int> value, FloatRoundingMode mode);
+        public static Vector512<float> ConvertToVector512Single(Vector512<uint> value, FloatRoundingMode mode);
+        public static Vector512<uint> ConvertToVector512UInt32(Vector512<float> value, FloatRoundingMode mode);
+        public static Vector512<double> Divide(Vector512<double> left, Vector512<double> right, FloatRoundingMode mode);
+        public static Vector512<float> Divide(Vector512<float> left, Vector512<float> right, FloatRoundingMode mode);
+        public static Vector128<double> DivideScalar(Vector128<double> left, Vector128<double> right, FloatRoundingMode mode);
+        public static Vector128<float> DivideScalar(Vector128<float> left, Vector128<float> right, FloatRoundingMode mode);
+        public static Vector512<double> FusedMultiplyAdd(Vector512<double> a, Vector512<double> b, Vector512<double> c, FloatRoundingMode mode);
+        public static Vector512<float> FusedMultiplyAdd(Vector512<float> a, Vector512<float> b, Vector512<float> c, FloatRoundingMode mode);
+        public static Vector512<double> FusedMultiplyAddNegated(Vector512<double> a, Vector512<double> b, Vector512<double> c, FloatRoundingMode mode);
+        public static Vector512<float> FusedMultiplyAddNegated(Vector512<float> a, Vector512<float> b, Vector512<float> c, FloatRoundingMode mode);
+        public static Vector128<double> FusedMultiplyAddNegatedScalar(Vector128<double> a, Vector128<double> b, Vector128<double> c, FloatRoundingMode mode);
+        public static Vector128<float> FusedMultiplyAddNegatedScalar(Vector128<float> a, Vector128<float> b, Vector128<float> c, FloatRoundingMode mode);
+        public static Vector128<double> FusedMultiplyAddScalar(Vector128<double> a, Vector128<double> b, Vector128<double> c, FloatRoundingMode mode);
+        public static Vector128<float> FusedMultiplyAddScalar(Vector128<float> a, Vector128<float> b, Vector128<float> c, FloatRoundingMode mode);
+        public static Vector512<double> FusedMultiplyAddSubtract(Vector512<double> a, Vector512<double> b, Vector512<double> c, FloatRoundingMode mode);
+        public static Vector512<float> FusedMultiplyAddSubtract(Vector512<float> a, Vector512<float> b, Vector512<float> c, FloatRoundingMode mode);
+        public static Vector512<double> FusedMultiplySubtract(Vector512<double> a, Vector512<double> b, Vector512<double> c, FloatRoundingMode mode);
+        public static Vector512<float> FusedMultiplySubtract(Vector512<float> a, Vector512<float> b, Vector512<float> c, FloatRoundingMode mode);
+        public static Vector512<double> FusedMultiplySubtractAdd(Vector512<double> a, Vector512<double> b, Vector512<double> c, FloatRoundingMode mode);
+        public static Vector512<float> FusedMultiplySubtractAdd(Vector512<float> a, Vector512<float> b, Vector512<float> c, FloatRoundingMode mode);
+        public static Vector512<double> FusedMultiplySubtractNegated(Vector512<double> a, Vector512<double> b, Vector512<double> c, FloatRoundingMode mode);
+        public static Vector512<float> FusedMultiplySubtractNegated(Vector512<float> a, Vector512<float> b, Vector512<float> c, FloatRoundingMode mode);
+        public static Vector128<double> FusedMultiplySubtractNegatedScalar(Vector128<double> a, Vector128<double> b, Vector128<double> c, FloatRoundingMode mode);
+        public static Vector128<float> FusedMultiplySubtractNegatedScalar(Vector128<float> a, Vector128<float> b, Vector128<float> c, FloatRoundingMode mode);
+        public static Vector128<double> FusedMultiplySubtractScalar(Vector128<double> a, Vector128<double> b, Vector128<double> c, FloatRoundingMode mode);
+        public static Vector128<float> FusedMultiplySubtractScalar(Vector128<float> a, Vector128<float> b, Vector128<float> c, FloatRoundingMode mode);
+        public static Vector512<double> Multiply(Vector512<double> left, Vector512<double> right, FloatRoundingMode mode);
+        public static Vector512<float> Multiply(Vector512<float> left, Vector512<float> right, FloatRoundingMode mode);
+        public static Vector128<double> MultiplyScalar(Vector128<double> left, Vector128<double> right, FloatRoundingMode mode);
+        public static Vector128<float> MultiplyScalar(Vector128<float> left, Vector128<float> right, FloatRoundingMode mode);
+        public static Vector512<double> Scale(Vector512<double> left, Vector512<double> right, FloatRoundingMode mode);
+        public static Vector512<float> Scale(Vector512<float> left, Vector512<float> right, FloatRoundingMode mode);
+        public static Vector128<double> ScaleScalar(Vector128<double> left, Vector128<double> right, FloatRoundingMode mode);
+        public static Vector128<float> ScaleScalar(Vector128<float> left, Vector128<float> right, FloatRoundingMode mode);
+        public static Vector512<double> Sqrt(Vector512<double> value, FloatRoundingMode mode);
+        public static Vector512<float> Sqrt(Vector512<float> value, FloatRoundingMode mode);
+        public static Vector128<double> SqrtScalar(Vector128<double> upper, Vector128<double> value, FloatRoundingMode mode);
+        public static Vector128<float> SqrtScalar(Vector128<float> upper, Vector128<float> value, FloatRoundingMode mode);
+        public static Vector512<double> Subtract(Vector512<double> left, Vector512<double> right, FloatRoundingMode mode);
+        public static Vector512<float> Subtract(Vector512<float> left, Vector512<float> right, FloatRoundingMode mode);
+        public static Vector128<double> SubtractScalar(Vector128<double> left, Vector128<double> right, FloatRoundingMode mode);
+        public static Vector128<float> SubtractScalar(Vector128<float> left, Vector128<float> right, FloatRoundingMode mode);
         public new abstract class X64 : Avx2.X64 {
+            public static Vector128<double> ConvertScalarToVector128Double(Vector128<double> upper, long value, FloatRoundingMode mode);
+            public static Vector128<double> ConvertScalarToVector128Double(Vector128<double> upper, ulong value, FloatRoundingMode mode);
+            public static Vector128<float> ConvertScalarToVector128Single(Vector128<float> upper, long value, FloatRoundingMode mode);
+            public static Vector128<float> ConvertScalarToVector128Single(Vector128<float> upper, ulong value, FloatRoundingMode mode);
+            public static long ConvertToInt64(Vector128<double> value, FloatRoundingMode mode);
+            public static long ConvertToInt64(Vector128<float> value, FloatRoundingMode mode);
+            public static ulong ConvertToUInt64(Vector128<double> value, FloatRoundingMode mode);
+            public static ulong ConvertToUInt64(Vector128<float> value, FloatRoundingMode mode);
         }
     }
 }
```

