# System

``` diff
 namespace System {
     public abstract class Delegate : ICloneable, ISerializable {
+        public bool HasSingleTarget { get; }
+        public static Delegate.InvocationListEnumerator<TDelegate> EnumerateInvocationList<TDelegate>(TDelegate? d) where TDelegate : Delegate;
+        public struct InvocationListEnumerator<TDelegate> where TDelegate : Delegate {
+            public TDelegate Current { get; }
+            public Delegate.InvocationListEnumerator<TDelegate> GetEnumerator();
+            public bool MoveNext();
+        }
     }
     public static class MemoryExtensions {
-        public static int LastIndexOf<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T?>;
+        public static int LastIndexOf<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>?;
     }
     public readonly ref struct ReadOnlySpan<T> {
+        public static ReadOnlySpan<T> CastUp<TDerived>(ReadOnlySpan<TDerived> items) where TDerived : class?, T?;
     }
     public class Uri : IFormattable, ISerializable, ISpanFormattable {
+        public static string EscapeDataString(ReadOnlySpan<char> charsToEscape);
+        public static bool TryEscapeDataString(ReadOnlySpan<char> charsToEscape, Span<char> destination, out int charsWritten);
+        public static bool TryUnescapeDataString(ReadOnlySpan<char> charsToUnescape, Span<char> destination, out int charsWritten);
+        public static string UnescapeDataString(ReadOnlySpan<char> charsToUnescape);
     }
 }
```

