# System.Drawing.Drawing2D

``` diff
 namespace System.Drawing.Drawing2D {
     public sealed class GraphicsPath : MarshalByRefObject, ICloneable, IDisposable {
+        public GraphicsPath(ReadOnlySpan<Point> pts, ReadOnlySpan<byte> types, FillMode fillMode = FillMode.Alternate);
+        public GraphicsPath(ReadOnlySpan<PointF> pts, ReadOnlySpan<byte> types, FillMode fillMode = FillMode.Alternate);
-        public void AddBeziers(PointF[] points);
+        public void AddBeziers(params PointF[] points);
+        public void AddBeziers(ReadOnlySpan<Point> points);
+        public void AddBeziers(ReadOnlySpan<PointF> points);
-        public void AddClosedCurve(PointF[] points);
+        public void AddClosedCurve(params PointF[] points);
-        public void AddClosedCurve(Point[] points);
+        public void AddClosedCurve(params Point[] points);
+        public void AddClosedCurve(ReadOnlySpan<Point> points);
+        public void AddClosedCurve(ReadOnlySpan<Point> points, float tension);
+        public void AddClosedCurve(ReadOnlySpan<PointF> points);
+        public void AddClosedCurve(ReadOnlySpan<PointF> points, float tension);
-        public void AddCurve(PointF[] points);
+        public void AddCurve(params PointF[] points);
-        public void AddCurve(Point[] points);
+        public void AddCurve(params Point[] points);
+        public void AddCurve(ReadOnlySpan<Point> points);
+        public void AddCurve(ReadOnlySpan<Point> points, float tension);
+        public void AddCurve(ReadOnlySpan<PointF> points);
+        public void AddCurve(ReadOnlySpan<PointF> points, float tension);
-        public void AddLines(PointF[] points);
+        public void AddLines(params PointF[] points);
-        public void AddLines(Point[] points);
+        public void AddLines(params Point[] points);
+        public void AddLines(ReadOnlySpan<Point> points);
+        public void AddLines(ReadOnlySpan<PointF> points);
+        public void AddPolygon(ReadOnlySpan<Point> points);
+        public void AddPolygon(ReadOnlySpan<PointF> points);
-        public void AddRectangles(RectangleF[] rects);
+        public void AddRectangles(params RectangleF[] rects);
+        public void AddRectangles(ReadOnlySpan<Rectangle> rects);
+        public void AddRectangles(ReadOnlySpan<RectangleF> rects);
+        public void AddRoundedRectangle(Rectangle rect, Size radius);
+        public void AddRoundedRectangle(RectangleF rect, SizeF radius);
+        public int GetPathPoints(Span<PointF> destination);
+        public int GetPathTypes(Span<byte> destination);
+        public void Warp(ReadOnlySpan<PointF> destPoints, RectangleF srcRect, Matrix? matrix = null, WarpMode warpMode = WarpMode.Perspective, float flatness = 0.25f);
     }
 }
```

