# System.Drawing.Imaging.Effects

``` diff
+namespace System.Drawing.Imaging.Effects {
+    public class BlackSaturationCurveEffect : ColorCurveEffect {
+        public BlackSaturationCurveEffect(CurveChannel channel, int blackSaturation);
+        public int BlackSaturation { get; }
+    }
+    public class BlurEffect : Effect {
+        public BlurEffect(float radius, bool expandEdge);
+        public bool ExpandEdge { get; }
+        public float Radius { get; }
+    }
+    public class BrightnessContrastEffect : Effect {
+        public BrightnessContrastEffect(int brightnessLevel, int contrastLevel);
+        public int BrightnessLevel { get; }
+        public int ContrastLevel { get; }
+    }
+    public class ColorBalanceEffect : Effect {
+        public ColorBalanceEffect(int cyanRed, int magentaGreen, int yellowBlue);
+        public int CyanRed { get; }
+        public int MagentaGreen { get; }
+        public int YellowBlue { get; }
+    }
+    public abstract class ColorCurveEffect : Effect {
+        public CurveChannel Channel { get; }
+    }
+    public class ColorLookupTableEffect : Effect {
+        public ColorLookupTableEffect(byte[] redLookupTable, byte[] greenLookupTable, byte[] blueLookupTable, byte[] alphaLookupTable);
+        public ColorLookupTableEffect(ReadOnlySpan<byte> redLookupTable, ReadOnlySpan<byte> greenLookupTable, ReadOnlySpan<byte> blueLookupTable, ReadOnlySpan<byte> alphaLookupTable);
+        public ReadOnlyMemory<byte> AlphaLookupTable { get; }
+        public ReadOnlyMemory<byte> BlueLookupTable { get; }
+        public ReadOnlyMemory<byte> GreenLookupTable { get; }
+        public ReadOnlyMemory<byte> RedLookupTable { get; }
+    }
+    public class ColorMatrixEffect : Effect {
+        public ColorMatrixEffect(ColorMatrix matrix);
+        public ColorMatrix Matrix { get; }
+    }
+    public class ContrastCurveEffect : ColorCurveEffect {
+        public ContrastCurveEffect(CurveChannel channel, int contrast);
+        public int Contrast { get; }
+    }
+    public enum CurveChannel {
+        All = 0,
+        Blue = 3,
+        Green = 2,
+        Red = 1,
+    }
+    public class DensityCurveEffect : ColorCurveEffect {
+        public DensityCurveEffect(CurveChannel channel, int density);
+        public int Density { get; }
+    }
+    public abstract class Effect : IDisposable {
+        public void Dispose();
+        public virtual void Dispose(bool disposing);
+        ~Effect();
+    }
+    public class ExposureCurveEffect : ColorCurveEffect {
+        public ExposureCurveEffect(CurveChannel channel, int exposure);
+        public int Exposure { get; }
+    }
+    public sealed class GrayScaleEffect : ColorMatrixEffect {
+        public GrayScaleEffect();
+    }
+    public class HighlightCurveEffect : ColorCurveEffect {
+        public HighlightCurveEffect(CurveChannel channel, int highlight);
+        public int Highlight { get; }
+    }
+    public sealed class InvertEffect : ColorMatrixEffect {
+        public InvertEffect();
+    }
+    public class LevelsEffect : Effect {
+        public LevelsEffect(int highlight, int midtone, int shadow);
+        public int Highlight { get; }
+        public int Midtone { get; }
+        public int Shadow { get; }
+    }
+    public class MidtoneCurveEffect : ColorCurveEffect {
+        public MidtoneCurveEffect(CurveChannel channel, int midtone);
+        public int Midtone { get; }
+    }
+    public sealed class SepiaEffect : ColorMatrixEffect {
+        public SepiaEffect();
+    }
+    public class ShadowCurveEffect : ColorCurveEffect {
+        public ShadowCurveEffect(CurveChannel channel, int shadow);
+        public int Shadow { get; }
+    }
+    public class SharpenEffect : Effect {
+        public SharpenEffect(float radius, float amount);
+        public float Amount { get; }
+        public float Radius { get; }
+    }
+    public class TintEffect : Effect {
+        public TintEffect(Color color, int amount);
+        public TintEffect(int hue, int amount);
+        public int Amount { get; }
+        public int Hue { get; }
+    }
+    public sealed class VividEffect : ColorMatrixEffect {
+        public VividEffect();
+    }
+    public class WhiteSaturationCurveEffect : ColorCurveEffect {
+        public WhiteSaturationCurveEffect(CurveChannel channel, int whiteSaturation);
+        public int WhiteSaturation { get; }
+    }
+}
```

