# System.Drawing.Imaging

``` diff
 namespace System.Drawing.Imaging {
     public sealed class ColorMatrix {
+        public ColorMatrix(ReadOnlySpan<float> newColorMatrix);
     }
     public sealed class ColorPalette {
+        public ColorPalette(params Color[] entries);
+        public ColorPalette(PaletteType paletteType);
+        public static ColorPalette CreateOptimalPalette(int colorCount, bool useTransparentColor, Bitmap bitmap);
     }
+    public enum DitherType {
+        DualSpiral4x4 = 7,
+        DualSpiral8x8 = 8,
+        ErrorDiffusion = 9,
+        None = 0,
+        Ordered16x16 = 4,
+        Ordered4x4 = 2,
+        Ordered8x8 = 3,
+        Solid = 1,
+        Spiral4x4 = 5,
+        Spiral8x8 = 6,
+    }
     public sealed class ImageAttributes : ICloneable, IDisposable {
-        public void SetBrushRemapTable(ColorMap[] map);
+        public void SetBrushRemapTable(params ColorMap[] map);
+        public void SetBrushRemapTable(ReadOnlySpan<ColorMap> map);
+        public void SetBrushRemapTable(ReadOnlySpan<(Color OldColor, Color NewColor)> map);
+        public void SetRemapTable(ColorAdjustType type, ReadOnlySpan<ColorMap> map);
+        public void SetRemapTable(ColorAdjustType type, ReadOnlySpan<(Color OldColor, Color NewColor)> map);
-        public void SetRemapTable(ColorMap[] map);
+        public void SetRemapTable(params ColorMap[] map);
+        public void SetRemapTable(ReadOnlySpan<ColorMap> map);
+        public void SetRemapTable(ReadOnlySpan<(Color OldColor, Color NewColor)> map);
     }
+    public enum PaletteType {
+        Custom = 0,
+        FixedBW = 2,
+        FixedHalftone125 = 6,
+        FixedHalftone216 = 7,
+        FixedHalftone252 = 8,
+        FixedHalftone256 = 9,
+        FixedHalftone27 = 4,
+        FixedHalftone64 = 5,
+        FixedHalftone8 = 3,
+    }
 }
```

