# System.Drawing

``` diff
 namespace System.Drawing {
     public sealed class Bitmap : Image {
+        public void ApplyEffect(Effect effect, Rectangle area = default(Rectangle));
+        public void ConvertFormat(PixelFormat format);
+        public void ConvertFormat(PixelFormat format, DitherType ditherType, PaletteType paletteType = PaletteType.Custom, ColorPalette? palette = null, float alphaThresholdPercent = 0f);
     }
     public sealed class Graphics : MarshalByRefObject, IDeviceContext, IDisposable, IGraphics, IGraphicsContextInfo, IHdcContext, IPointer<GpGraphics> {
-        public void DrawBeziers(Pen pen, PointF[] points);
+        public void DrawBeziers(Pen pen, params PointF[] points);
-        public void DrawBeziers(Pen pen, Point[] points);
+        public void DrawBeziers(Pen pen, params Point[] points);
+        public void DrawBeziers(Pen pen, ReadOnlySpan<Point> points);
+        public void DrawBeziers(Pen pen, ReadOnlySpan<PointF> points);
-        public void DrawClosedCurve(Pen pen, PointF[] points);
+        public void DrawClosedCurve(Pen pen, params PointF[] points);
+        public void DrawClosedCurve(Pen pen, ReadOnlySpan<Point> points);
+        public void DrawClosedCurve(Pen pen, ReadOnlySpan<Point> points, float tension, FillMode fillmode);
+        public void DrawClosedCurve(Pen pen, ReadOnlySpan<PointF> points);
+        public void DrawClosedCurve(Pen pen, ReadOnlySpan<PointF> points, float tension, FillMode fillmode);
-        public void DrawCurve(Pen pen, PointF[] points);
+        public void DrawCurve(Pen pen, params PointF[] points);
-        public void DrawCurve(Pen pen, Point[] points);
+        public void DrawCurve(Pen pen, params Point[] points);
+        public void DrawCurve(Pen pen, ReadOnlySpan<Point> points);
+        public void DrawCurve(Pen pen, ReadOnlySpan<Point> points, int offset, int numberOfSegments, float tension);
+        public void DrawCurve(Pen pen, ReadOnlySpan<Point> points, float tension);
+        public void DrawCurve(Pen pen, ReadOnlySpan<PointF> points);
+        public void DrawCurve(Pen pen, ReadOnlySpan<PointF> points, int offset, int numberOfSegments);
+        public void DrawCurve(Pen pen, ReadOnlySpan<PointF> points, int offset, int numberOfSegments, float tension);
+        public void DrawCurve(Pen pen, ReadOnlySpan<PointF> points, float tension);
+        public void DrawImage(Image image, Effect effect);
+        public void DrawImage(Image image, Effect effect, RectangleF srcRect = default(RectangleF), Matrix? transform = null, GraphicsUnit srcUnit = GraphicsUnit.Pixel, ImageAttributes? imageAttr = null);
-        public void DrawLines(Pen pen, Point[] points);
+        public void DrawLines(Pen pen, params Point[] points);
+        public void DrawLines(Pen pen, ReadOnlySpan<Point> points);
+        public void DrawLines(Pen pen, ReadOnlySpan<PointF> points);
-        public void DrawPolygon(Pen pen, PointF[] points);
+        public void DrawPolygon(Pen pen, params PointF[] points);
-        public void DrawPolygon(Pen pen, Point[] points);
+        public void DrawPolygon(Pen pen, params Point[] points);
+        public void DrawPolygon(Pen pen, ReadOnlySpan<Point> points);
+        public void DrawPolygon(Pen pen, ReadOnlySpan<PointF> points);
-        public void DrawRectangles(Pen pen, RectangleF[] rects);
+        public void DrawRectangles(Pen pen, params RectangleF[] rects);
-        public void DrawRectangles(Pen pen, Rectangle[] rects);
+        public void DrawRectangles(Pen pen, params Rectangle[] rects);
+        public void DrawRectangles(Pen pen, ReadOnlySpan<Rectangle> rects);
+        public void DrawRectangles(Pen pen, ReadOnlySpan<RectangleF> rects);
+        public void DrawRoundedRectangle(Pen pen, Rectangle rect, Size radius);
+        public void DrawRoundedRectangle(Pen pen, RectangleF rect, SizeF radius);
-        public void FillClosedCurve(Brush brush, PointF[] points);
+        public void FillClosedCurve(Brush brush, params PointF[] points);
-        public void FillClosedCurve(Brush brush, Point[] points);
+        public void FillClosedCurve(Brush brush, params Point[] points);
+        public void FillClosedCurve(Brush brush, ReadOnlySpan<Point> points);
+        public void FillClosedCurve(Brush brush, ReadOnlySpan<Point> points, FillMode fillmode);
+        public void FillClosedCurve(Brush brush, ReadOnlySpan<Point> points, FillMode fillmode, float tension);
+        public void FillClosedCurve(Brush brush, ReadOnlySpan<PointF> points);
+        public void FillClosedCurve(Brush brush, ReadOnlySpan<PointF> points, FillMode fillmode);
+        public void FillClosedCurve(Brush brush, ReadOnlySpan<PointF> points, FillMode fillmode, float tension);
-        public void FillPolygon(Brush brush, PointF[] points);
+        public void FillPolygon(Brush brush, params PointF[] points);
+        public void FillPolygon(Brush brush, ReadOnlySpan<Point> points);
+        public void FillPolygon(Brush brush, ReadOnlySpan<Point> points, FillMode fillMode);
+        public void FillPolygon(Brush brush, ReadOnlySpan<PointF> points);
+        public void FillPolygon(Brush brush, ReadOnlySpan<PointF> points, FillMode fillMode);
-        public void FillRectangles(Brush brush, RectangleF[] rects);
+        public void FillRectangles(Brush brush, params RectangleF[] rects);
-        public void FillRectangles(Brush brush, Rectangle[] rects);
+        public void FillRectangles(Brush brush, params Rectangle[] rects);
+        public void FillRectangles(Brush brush, ReadOnlySpan<Rectangle> rects);
+        public void FillRectangles(Brush brush, ReadOnlySpan<RectangleF> rects);
+        public void FillRoundedRectangle(Brush brush, Rectangle rect, Size radius);
+        public void FillRoundedRectangle(Brush brush, RectangleF rect, SizeF radius);
     }
 }
```

