# System.Runtime.Intrinsics.Arm

``` diff
 namespace System.Runtime.Intrinsics.Arm {
     public abstract class Sve : AdvSimd {
+        public static Vector<byte> CreateTrueMaskByte(SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<double> CreateTrueMaskDouble(SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<short> CreateTrueMaskInt16(SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<int> CreateTrueMaskInt32(SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<long> CreateTrueMaskInt64(SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<sbyte> CreateTrueMaskSByte(SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<float> CreateTrueMaskSingle(SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<ushort> CreateTrueMaskUInt16(SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<uint> CreateTrueMaskUInt32(SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<ulong> CreateTrueMaskUInt64(SveMaskPattern pattern = SveMaskPattern.All);
+        public unsafe static Vector<byte> LoadVector(Vector<byte> mask, byte* address);
+        public unsafe static Vector<double> LoadVector(Vector<double> mask, double* address);
+        public unsafe static Vector<short> LoadVector(Vector<short> mask, short* address);
+        public unsafe static Vector<int> LoadVector(Vector<int> mask, int* address);
+        public unsafe static Vector<long> LoadVector(Vector<long> mask, long* address);
+        public unsafe static Vector<sbyte> LoadVector(Vector<sbyte> mask, sbyte* address);
+        public unsafe static Vector<float> LoadVector(Vector<float> mask, float* address);
+        public unsafe static Vector<ushort> LoadVector(Vector<ushort> mask, ushort* address);
+        public unsafe static Vector<uint> LoadVector(Vector<uint> mask, uint* address);
+        public unsafe static Vector<ulong> LoadVector(Vector<ulong> mask, ulong* address);
     }
+    public enum SveMaskPattern : byte {
+        All = (byte)31,
+        LargestMultipleOf3 = (byte)30,
+        LargestMultipleOf4 = (byte)29,
+        LargestPowerOf2 = (byte)0,
+        VectorCount1 = (byte)1,
+        VectorCount128 = (byte)12,
+        VectorCount16 = (byte)9,
+        VectorCount2 = (byte)2,
+        VectorCount256 = (byte)13,
+        VectorCount3 = (byte)3,
+        VectorCount32 = (byte)10,
+        VectorCount4 = (byte)4,
+        VectorCount5 = (byte)5,
+        VectorCount6 = (byte)6,
+        VectorCount64 = (byte)11,
+        VectorCount7 = (byte)7,
+        VectorCount8 = (byte)8,
+    }
 }
```

