# System

``` diff
 namespace System {
     public readonly struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable, IParsable<TimeSpan>, ISpanFormattable, ISpanParsable<TimeSpan>, IUtf8SpanFormattable {
+        public static TimeSpan FromDays(int days);
+        public static TimeSpan FromDays(int days, int hours = 0, long minutes = (long)0, long seconds = (long)0, long milliseconds = (long)0, long microseconds = (long)0);
+        public static TimeSpan FromHours(int hours);
+        public static TimeSpan FromHours(int hours, long minutes = (long)0, long seconds = (long)0, long milliseconds = (long)0, long microseconds = (long)0);
+        public static TimeSpan FromMicroseconds(long microseconds);
+        public static TimeSpan FromMilliseconds(long milliseconds, long microseconds = (long)0);
+        public static TimeSpan FromMinutes(long minutes);
+        public static TimeSpan FromMinutes(long minutes, long seconds = (long)0, long milliseconds = (long)0, long microseconds = (long)0);
+        public static TimeSpan FromSeconds(long seconds);
+        public static TimeSpan FromSeconds(long seconds, long milliseconds = (long)0, long microseconds = (long)0);
     }
 }
```

