# .NET 9 Preview 4 Binaries

.NET 9 Preview 4 installers and binaries can be downloaded for the following product versions:

- `.NET 9.0.0 Preview 4`
- `.NET SDK 9.0.100-preview.4.24267.66`

See [README.md](README.md) for .NET 9 release notes and discussions.

The latest .NET releases are always listed at [.NET Releases](../../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
9.0.100-preview.4.24267.66
```

## .NET Multi-Platform App UI (MAUI) Workload Downloads

 After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

 ```console
 $ dotnet workload install maui
 ```

 The following workloads are also available to install individually:

 ```console
 $ dotnet workload install android
 $ dotnet workload install ios
 $ dotnet workload install maccatalyst
 $ dotnet workload install macos
 $ dotnet workload install tvos
 ```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 9.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

.NET 9 is compatible with  [Visual Studio 17.11 latest preview](https://visualstudio.microsoft.com) Users will have to [download](https://dotnet.microsoft.com/download/dotnet/9.0) and install the .NET 9 runtime/sdk standalone. Visual Studio for Mac is currently not supported for .NET 9.0 Preview releases.

## Feedback

Your feedback is important and appreciated. We've created an issue at https://aka.ms/dotnet/9/preview4 for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 9.0.0-preview.4.24267.11
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 9.0.0-preview.4.24267.11
Microsoft.WindowsDesktop.App.Ref | 9.0.0-preview.4.24267.11
Microsoft.Windows.Compatibility | 9.0.0-preview.4.24267.11
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 9.0.0-preview.4.24267.11
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 9.0.0-preview.4.24266.19
Microsoft.Extensions.DependencyInjection.Abstractions | 9.0.0-preview.4.24266.19
Microsoft.ILVerification | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Primitives | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-preview.4 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-preview.4.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-preview.4.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-preview.4.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-preview.4 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-preview.4 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Crossgen2.win-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.linux-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.linux-musl-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.win-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.win-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 9.0.0-preview.4.24266.19
runtime.android-arm.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.linux-musl-arm.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.linux-musl-x64.Microsoft.NETCore.ILAsm | 9.0.0-preview.4.24266.19
runtime.linux-x64.Microsoft.NETCore.ILAsm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.win-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.osx-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.win-x86 | 9.0.0-preview.4.24266.19
Microsoft.Win32.SystemEvents | 9.0.0-preview.4.24266.19
Microsoft.Win32.Registry.AccessControl | 9.0.0-preview.4.24266.19
Microsoft.XmlSerializer.Generator | 9.0.0-preview.4.24266.19
runtime.android-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.android-x86.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
runtime.linux-musl-arm.Microsoft.NETCore.ILAsm | 9.0.0-preview.4.24266.19
runtime.linux-musl-arm.Microsoft.NETCore.ILDAsm | 9.0.0-preview.4.24266.19
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
runtime.linux-musl-arm64.Microsoft.NETCore.ILAsm | 9.0.0-preview.4.24266.19
runtime.linux-musl-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.4.24266.19
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
runtime.maccatalyst-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
System.ComponentModel.Composition.Registration | 9.0.0-preview.4.24266.19
System.Composition | 9.0.0-preview.4.24266.19
System.Composition.Convention | 9.0.0-preview.4.24266.19
System.Composition.AttributedModel | 9.0.0-preview.4.24266.19
System.Composition.Hosting | 9.0.0-preview.4.24266.19
System.Configuration.ConfigurationManager | 9.0.0-preview.4.24266.19
System.Composition.Runtime | 9.0.0-preview.4.24266.19
System.Data.Odbc | 9.0.0-preview.4.24266.19
System.DirectoryServices | 9.0.0-preview.4.24266.19
System.Diagnostics.PerformanceCounter | 9.0.0-preview.4.24266.19
System.DirectoryServices.Protocols | 9.0.0-preview.4.24266.19
System.IO.Hashing | 9.0.0-preview.4.24266.19
System.IO.Pipelines | 9.0.0-preview.4.24266.19
System.IO.Packaging | 9.0.0-preview.4.24266.19
System.Management | 9.0.0-preview.4.24266.19
System.Resources.Extensions | 9.0.0-preview.4.24266.19
System.Security.Cryptography.Pkcs | 9.0.0-preview.4.24266.19
System.Security.Cryptography.Cose | 9.0.0-preview.4.24266.19
System.Runtime.Serialization.Schema | 9.0.0-preview.4.24266.19
System.Security.Cryptography.Xml | 9.0.0-preview.4.24266.19
System.Security.Cryptography.ProtectedData | 9.0.0-preview.4.24266.19
System.Security.Permissions | 9.0.0-preview.4.24266.19
System.Text.Json | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.wasi-wasm.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.wasi-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.linux-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.linux-musl-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.linux-musl-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.win-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 9.0.0-preview.4.24266.19
runtime.linux-arm.Microsoft.NETCore.ILAsm | 9.0.0-preview.4.24266.19
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
runtime.maccatalyst-x64.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.win-x86.Microsoft.DotNet.ILCompiler | 9.0.0-preview.4.24266.19
runtime.win-x64.Microsoft.NETCore.ILAsm | 9.0.0-preview.4.24266.19
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
runtime.win-x86.Microsoft.NETCore.ILDAsm | 9.0.0-preview.4.24266.19
runtime.win-x86.Microsoft.NETCore.ILAsm | 9.0.0-preview.4.24266.19
System.Collections.Immutable | 9.0.0-preview.4.24266.19
System.Composition.TypedParts | 9.0.0-preview.4.24266.19
System.Diagnostics.EventLog | 9.0.0-preview.4.24266.19
System.DirectoryServices.AccountManagement | 9.0.0-preview.4.24266.19
System.Formats.Asn1 | 9.0.0-preview.4.24266.19
System.Memory.Data | 9.0.0-preview.4.24266.19
System.Net.Http.Json | 9.0.0-preview.4.24266.19
System.Numerics.Tensors | 9.0.0-preview.4.24266.19
System.Reflection.Context | 9.0.0-preview.4.24266.19
System.Reflection.MetadataLoadContext | 9.0.0-preview.4.24266.19
System.ServiceModel.Syndication | 9.0.0-preview.4.24266.19
System.Text.Encoding.CodePages | 9.0.0-preview.4.24266.19
System.ServiceProcess.ServiceController | 9.0.0-preview.4.24266.19
System.Speech | 9.0.0-preview.4.24266.19
Microsoft.Extensions.DependencyInjection | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Diagnostics | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Logging.EventLog | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Options | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Logging.EventSource | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Logging.TraceSource | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Options.ConfigurationExtensions | 9.0.0-preview.4.24266.19
Microsoft.NET.Sdk.WebAssembly.Pack.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-preview.4.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-preview.4.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Crossgen2.linux-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Crossgen2.osx-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.linux-musl-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.linux-musl-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.osx-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.browser-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.wasi-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.linux-musl-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 9.0.0-preview.4.24266.19
runtime.linux-musl-x64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.4.24266.19
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.4.24266.19
runtime.linux-x64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.4.24266.19
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
runtime.win-x64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.4.24266.19
runtime.win-arm64.Microsoft.NETCore.ILAsm | 9.0.0-preview.4.24266.19
runtime.win-x64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.4.24266.19
System.Data.OleDb | 9.0.0-preview.4.24266.19
System.Diagnostics.DiagnosticSource | 9.0.0-preview.4.24266.19
System.Formats.Cbor | 9.0.0-preview.4.24266.19
System.Net.Http.WinHttpHandler | 9.0.0-preview.4.24266.19
System.Reflection.Metadata | 9.0.0-preview.4.24266.19
System.Runtime.Caching | 9.0.0-preview.4.24266.19
System.Windows.Extensions | 9.0.0-preview.4.24266.19
Microsoft.Bcl.AsyncInterfaces | 9.0.0-preview.4.24266.19
Microsoft.Bcl.Numerics | 9.0.0-preview.4.24266.19
Microsoft.Bcl.TimeProvider | 9.0.0-preview.4.24266.19
Microsoft.DotNet.ILCompiler | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Caching.Abstractions | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Configuration | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NET.Sdk.WebAssembly.Pack | 9.0.0-preview.4.24266.19
Microsoft.NET.Sdk.WebAssembly.Pack.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.wasi-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
Microsoft.NETCore.ILAsm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.ILDAsm | 9.0.0-preview.4.24266.19
runtime.linux-arm.Microsoft.DotNet.ILCompiler | 9.0.0-preview.4.24266.19
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.4.24266.19
runtime.linux-arm64.Microsoft.NETCore.ILAsm | 9.0.0-preview.4.24266.19
runtime.linux-bionic-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.linux-bionic-x64.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.4.24266.19
runtime.linux-musl-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.linux-musl-x64.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-preview.4.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.linux-bionic-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.linux-musl-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.linux-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Ref | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x86.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.linux-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.linux-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 9.0.0-preview.4.24266.19
runtime.linux-arm.Microsoft.NETCore.ILDAsm | 9.0.0-preview.4.24266.19
runtime.linux-arm.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.linux-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.4.24266.19
runtime.linux-musl-arm.Microsoft.DotNet.ILCompiler | 9.0.0-preview.4.24266.19
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.osx-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.osx-x64.Microsoft.NETCore.ILAsm | 9.0.0-preview.4.24266.19
runtime.osx-x64.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
System.ComponentModel.Composition | 9.0.0-preview.4.24266.19
System.CodeDom | 9.0.0-preview.4.24266.19
System.IO.Ports | 9.0.0-preview.4.24266.19
System.Text.Encodings.Web | 9.0.0-preview.4.24266.19
System.Threading.AccessControl | 9.0.0-preview.4.24266.19
dotnet-ilverify | 9.0.0-preview.4.24266.19
Microsoft.Bcl.Cryptography | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Caching.Memory | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Configuration.Binder | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Configuration.Abstractions | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Configuration.EnvironmentVariables | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Configuration.CommandLine | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Configuration.Ini | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Configuration.FileExtensions | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Configuration.UserSecrets | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Configuration.Json | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Diagnostics.Abstractions | 9.0.0-preview.4.24266.19
Microsoft.Extensions.FileProviders.Composite | 9.0.0-preview.4.24266.19
Microsoft.Extensions.FileProviders.Abstractions | 9.0.0-preview.4.24266.19
Microsoft.Extensions.FileProviders.Physical | 9.0.0-preview.4.24266.19
Microsoft.Extensions.FileSystemGlobbing | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Http | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Logging.Abstractions | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Logging | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Logging.Console | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Logging.Configuration | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Logging.Debug | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.wasm.Sample.Mono | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.WebAssembly.Sdk | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-preview.4.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-preview.4.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-preview.4 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-preview.4.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-preview.4.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.osx-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.win-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.wasi-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.browser-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.wasi-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.linux-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.wasi-wasm.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.linux-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.win-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 9.0.0-preview.4.24266.19
runtime.android-x64.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.linux-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.4.24266.19
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.4.24266.19
runtime.linux-x64.runtime.native.System.IO.Ports | 9.0.0-preview.4.24266.19
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Configuration.Xml | 9.0.0-preview.4.24266.19
Microsoft.Extensions.DependencyModel | 9.0.0-preview.4.24266.19
Microsoft.Extensions.DependencyInjection.Specification.Tests | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Hosting | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Hosting.Abstractions | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Hosting.Systemd | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Hosting.WindowsServices | 9.0.0-preview.4.24266.19
Microsoft.Extensions.Options.DataAnnotations | 9.0.0-preview.4.24266.19
Microsoft.NET.ILLink.Tasks | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.Android.Sample.Mono | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.iOS.Sample.Mono | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.MonoTargets.Sdk | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.WebAssembly.Templates | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Sdk.IL | 9.0.0-preview.4.24266.19
Microsoft.NET.Sdk.WebAssembly.Pack.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NET.WebAssembly.Threading | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-preview.4.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-preview.4.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Crossgen2.linux-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Crossgen2.win-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Crossgen2.win-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.linux-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.linux-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.win-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.wasi-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.wasi-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.browser-wasm.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.browser-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.wasi-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.osx-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 9.0.0-preview.4.24266.19
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.4.24266.19
runtime.osx-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.4.24266.19
runtime.osx-arm64.Microsoft.NETCore.ILAsm | 9.0.0-preview.4.24266.19
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.4.24266.19
runtime.osx-x64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.4.24266.19
runtime.win-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.4.24266.19
System.Threading.Channels | 9.0.0-preview.4.24266.19
System.Threading.RateLimiting | 9.0.0-preview.4.24266.19
System.Threading.Tasks.Dataflow | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 9.0.0-preview.4.24266.19
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Host.win-arm64 | 9.0.0-preview.4.24266.19
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-arm | 9.0.0-preview.4.24266.19
Microsoft.AspNetCore.Components.WebView | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.ConcurrencyLimiter | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Identity.UI | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.MiddlewareAnalysis | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Localization | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Localization.Abstractions | 9.0.0-preview.4.24267.6
Microsoft.Extensions.WebEncoders | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.App.Runtime.linux-arm | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.App.Runtime.linux-x64 | 9.0.0-preview.4.24267.6
AspNetCoreRuntime.9.0.x64 | 9.0.0-preview-4-24267-6
AspNetCoreRuntime.9.0.x86 | 9.0.0-preview-4-24267-6
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Authentication.OpenIdConnect | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Authentication.Twitter | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Components.WebAssembly.Server | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Mvc.Testing | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 9.0.0-preview.4.24267.6
Microsoft.DotNet.Web.ItemTemplates.9.0 | 9.0.0-preview.4.24267.6
Microsoft.Extensions.ApiDescription.Server | 9.0.0-preview.4.24267.6
Microsoft.Extensions.ApiDescription.Client | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Diagnostics.HealthChecks | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 9.0.0-preview.4.24267.6
Microsoft.Extensions.FileProviders.Embedded | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Features | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Http.Polly | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Identity.Core | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Logging.AzureAppServices | 9.0.0-preview.4.24267.6
Microsoft.Extensions.ObjectPool | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.DataProtection | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.DataProtection.Abstractions | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Grpc.JsonTranscoding | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.HeaderPropagation | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Http.Connections.Client | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.OpenApi | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.SignalR.Client | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.SignalR.Client.Core | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.SignalR.Common | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.SignalR.Protocols.Json | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.WebUtilities | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.TestHost | 9.0.0-preview.4.24267.6
Microsoft.Authentication.WebAssembly.Msal | 9.0.0-preview.4.24267.6
Microsoft.DotNet.Web.ProjectTemplates.9.0 | 9.0.0-preview.4.24267.6
Microsoft.dotnet-openapi | 9.0.0-preview.4.24267.6
Microsoft.DotNet.Web.Client.ItemTemplates | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Caching.Hybrid | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Caching.StackExchangeRedis | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Identity.Stores | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.App.Runtime.win-x64 | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Authentication.Facebook | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Authentication.Google | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Authentication.Certificate | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Authentication.JwtBearer | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Authentication.Negotiate | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Authentication.WsFederation | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Authorization | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.AzureAppServicesIntegration | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Components | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Components.Analyzers | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Components.CustomElements | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Components.WebAssembly | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Cryptography.Internal | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Connections.Abstractions | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.DataProtection.Extensions | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Cryptography.KeyDerivation | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Http.Connections.Common | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Grpc.Swagger | 0.9.0-preview.4.24267.6
Microsoft.AspNetCore.Hosting.WindowsServices | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.JsonPatch | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Metadata | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Owin | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.SignalR.Specification.Tests | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.SpaProxy | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.SpaServices.Extensions | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Caching.SqlServer | 9.0.0-preview.4.24267.6
Microsoft.Extensions.Configuration.KeyPerFile | 9.0.0-preview.4.24267.6
Microsoft.JSInterop | 9.0.0-preview.4.24267.6
Microsoft.JSInterop.WebAssembly | 9.0.0-preview.4.24267.6
Microsoft.Net.Http.Headers | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.App.Runtime.osx-x64 | 9.0.0-preview.4.24267.6
dotnet-sql-cache | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.App.Ref | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.App.Runtime.win-arm64 | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Components.Web | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.App.Runtime.win-x86 | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Components.Authorization | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Components.Forms | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Components.QuickGrid | 9.0.0-preview.4.24267.6
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 9.0.0-preview.4.24267.6
Microsoft.NET.Build.Containers | 9.0.100-preview.4.24267.43
Microsoft.DotNet.ApiCompat.Task | 9.0.100-preview.4.24267.43
Microsoft.DotNet.ApiCompat.Tool | 9.0.100-preview.4.24267.43
FSharp.Compiler.Service | 43.8.400-preview.24229.4
FSharp.Core | 8.0.400-beta.24229.4
Microsoft.DotNet.Common.ItemTemplates | 9.0.100-preview.4.24267.43
Microsoft.DotNet.Common.ProjectTemplates.9.0 | 9.0.100-preview.4.24267.43
System.Drawing.Common | 9.0.0-preview.4.24267.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-musl-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-preview.4.Msi.arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-musl-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-preview.4.Msi.arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-preview.4.Msi.x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-preview.4.Msi.x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-preview.4 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-musl-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-musl-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-preview.4.Msi.x86 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-preview.4.Msi.x86 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-preview.4 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-musl-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-musl-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-preview.4.Msi.x86 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-preview.4.Msi.arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-preview.4.Msi.arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-preview.4 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-preview.4.Msi.x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-preview.4.Msi.x86 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-preview.4.Msi.x64 | 9.0.0-preview.4.24266.2
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-preview.4 | 9.0.0-preview.4.24266.2
Microsoft.Data.Sqlite | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Abstractions | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Analyzers | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Cosmos | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Specification.Tests | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Proxies | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Sqlite.Core | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Sqlite | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.SqlServer | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Relational | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Design | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.InMemory | 9.0.0-preview.4.24267.1
dotnet-ef | 9.0.0-preview.4.24267.1
Microsoft.Data.Sqlite.Core | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Tasks | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Templates | 9.0.0-preview.4.24267.1
Microsoft.EntityFrameworkCore.Tools | 9.0.0-preview.4.24267.1
Microsoft.TemplateEngine.Core.Contracts | 9.0.100-preview.4.24267.3
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 9.0.100-preview.4.24267.3
Microsoft.TemplateEngine.Authoring.Tasks | 9.0.100-preview.4.24267.3
Microsoft.TemplateEngine.Authoring.CLI | 9.0.100-preview.4.24267.3
Microsoft.TemplateEngine.Abstractions | 9.0.100-preview.4.24267.3
Microsoft.TemplateEngine.Samples | 9.0.100-preview.4.24267.3
Microsoft.TemplateEngine.TemplateLocalizer.Core | 9.0.100-preview.4.24267.3
Microsoft.TemplateEngine.Utils | 9.0.100-preview.4.24267.3
Microsoft.TemplateEngine.Core | 9.0.100-preview.4.24267.3
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 9.0.100-preview.4.24267.3
Microsoft.TemplateEngine.Authoring.Templates | 9.0.100-preview.4.24267.3
Microsoft.TemplateEngine.Edge | 9.0.100-preview.4.24267.3
Microsoft.TemplateEngine.IDE | 9.0.100-preview.4.24267.3
Microsoft.TemplateSearch.Common | 9.0.100-preview.4.24267.3
Microsoft.CodeAnalysis.BannedApiAnalyzers | 3.11.0-beta1.24216.2
Microsoft.CodeAnalysis.Analyzers | 3.11.0-beta1.24216.2
Microsoft.CodeAnalysis.NetAnalyzers | 9.0.0-preview.24216.2
Text.Analyzers | 3.11.0-beta1.24216.2
Microsoft.CodeAnalysis.ResxSourceGenerator | 3.11.0-beta1.24216.2
Microsoft.CodeAnalysis.PublicApiAnalyzers | 3.11.0-beta1.24216.2
Microsoft.CodeAnalysis.Metrics | 4.0.0-beta1.24216.2
Microsoft.CodeAnalysis.PerformanceSensitiveAnalyzers | 3.11.0-beta1.24216.2
Roslyn.Diagnostics.Analyzers | 3.11.0-beta1.24216.2
Microsoft.CodeAnalysis.AnalyzerUtilities | 3.11.0-beta1.24216.2
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter | 3.11.0-beta1.24216.2

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 9.0.0-preview.4.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/9.0.0-preview.4-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/9.0.0-preview.4-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: ../../install-linux.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-9-preview-4
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-9-preview-4/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef9-preview-4/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A9.0.0-preview4+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A9.0.0-preview4+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A9.0.0-preview4+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A9.0.0-preview4+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A9.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A9.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A9.0.1xx
[linux-packages]: ../../install-linux.md

[//]: # ( Runtime 9.0.0-preview.4.24266.19)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5a99b6e0-105d-432e-8df1-9f881aab7d86/4018c96b74950f6943e9102b99baec58/dotnet-runtime-9.0.0-preview.4.24266.19-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/18801fdd-b1f5-4856-8288-c306b11f0f43/5c62f28b9a269b1a840cfb310a9a9f86/dotnet-runtime-9.0.0-preview.4.24266.19-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/35dd9b11-2055-4d52-9169-1b6c3dd11594/a35d42236e89f7e0bea13545138e170e/dotnet-runtime-9.0.0-preview.4.24266.19-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/242ea287-a11a-4248-8c85-bfca8d2057e0/c0da08d4b4f8b07c966d9169ec56ed1d/dotnet-runtime-9.0.0-preview.4.24266.19-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5139dd2b-c1a7-4be5-9913-18e09aed94f3/f9a8615238ec30073a7c1bcb3c7ae247/dotnet-runtime-9.0.0-preview.4.24266.19-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bd635e31-a279-4078-ac0d-f82ad8940f84/2e9b04bbe40e28507e8483c73eafdd7c/dotnet-runtime-9.0.0-preview.4.24266.19-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7e461d11-8e26-429b-a35e-6f67c84d5b3f/0d7cfe48dcbfaa6a8284850793c984d7/dotnet-runtime-9.0.0-preview.4.24266.19-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c53cab87-a771-422e-be8e-f33a8a6ca637/6e72c3d16f517c6e692572a5cc9546c2/dotnet-runtime-9.0.0-preview.4.24266.19-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/73f4cbbe-9a84-4403-ab5a-4ea15abe6890/95fb54f4ccd9024e7d41cee510cf3fa6/dotnet-runtime-9.0.0-preview.4.24266.19-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6bd91ad7-ac3c-4027-8674-239367730906/007b8c98680c550fb801c34dea28bc9f/dotnet-runtime-9.0.0-preview.4.24266.19-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e377474e-7847-4bca-a032-07a50104e7f5/97851ebb43ff0e3dce49a0ca9d0fb0d1/dotnet-runtime-9.0.0-preview.4.24266.19-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/28a070f2-adb7-4d2a-8363-6c4e285a8e63/9156f37f7cdcf63739881a80d8dbc050/dotnet-runtime-9.0.0-preview.4.24266.19-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/62b4e83e-1346-4c01-986e-33047bc2a6d3/852c4d4ff7a7517a5edbd896e4796e15/dotnet-runtime-9.0.0-preview.4.24266.19-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/676e985a-6242-426e-84dc-caa80beac6be/576a6d8e8f74c9520c8e7942c4d5278f/dotnet-runtime-9.0.0-preview.4.24266.19-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4415bda1-d266-4128-b194-0d4d280128c4/685282429a7c7affd9134fd5d2d9a2c0/dotnet-runtime-9.0.0-preview.4.24266.19-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/284b822f-4ff7-409b-90ef-9b37eb487dcc/26719d69cfcc500a1493bb9d4de6fd7f/dotnet-runtime-9.0.0-preview.4.24266.19-win-x86.zip

[//]: # ( WindowsDesktop 9.0.0-preview.4.24267.11)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/cfbeca90-42aa-4cac-bdb6-96cd4613e5c2/4ff431cf779a7892ffb899c27c76d7e5/windowsdesktop-runtime-9.0.0-preview.4.24267.11-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/9db2ef93-4e2e-47a6-9574-f8de141e8469/57ed42a750224dc5e501833f23df7f51/windowsdesktop-runtime-9.0.0-preview.4.24267.11-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a3420930-6bca-4552-9c40-adaf4abec571/5a6243eda5d7e9645afe9b6145213ec5/windowsdesktop-runtime-9.0.0-preview.4.24267.11-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2f9d8f00-2cf0-47d5-b763-a534a8cb77b5/f4043682c3e2f1bab5c2ebf5507ed4cc/windowsdesktop-runtime-9.0.0-preview.4.24267.11-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/53c1b7b1-1a61-43a7-8344-1c66d8238f03/592ed2c250de13ad82ec1c34d96a6b68/windowsdesktop-runtime-9.0.0-preview.4.24267.11-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/43216cd1-dd9c-4dcf-b05c-9591125f0cd7/91dabb962aaf27fddc388b20dd80dc10/windowsdesktop-runtime-9.0.0-preview.4.24267.11-win-x86.zip

[//]: # ( ASP 9.0.0-preview.4.24267.6)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/992c2b62-6318-4dc7-b7c3-994fd9f29e35/37e65e34cbe93b5389f8b779bded70f2/aspnetcore-runtime-9.0.0-preview.4.24267.6-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bc6ae1a6-a98c-446f-8aa9-fe4bdd18412d/569b1a10883293eaa5aae3275d8a4e2f/aspnetcore-runtime-9.0.0-preview.4.24267.6-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/833d8170-3991-4523-8601-e7ff36cf254f/ff7f1cf297f4af74acadda36affcfac9/aspnetcore-runtime-9.0.0-preview.4.24267.6-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/02b13c1e-b263-4ab2-add3-963137022042/9d5fe5a6b63936a143047fc6a466eb17/aspnetcore-runtime-9.0.0-preview.4.24267.6-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f6caec80-aaf5-494d-bf71-10761428ff24/e062b54765e468699ab0588c092cce18/aspnetcore-runtime-9.0.0-preview.4.24267.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f889c70-8c50-44d0-9877-0d0376c031ab/d73ca2ec30f5fc3e537b16f37c029daa/aspnetcore-runtime-9.0.0-preview.4.24267.6-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57b0954f-d550-42af-b1b5-8c9ef5da0d58/a4c7f9677ac41fa3421050bf9822c56a/aspnetcore-runtime-9.0.0-preview.4.24267.6-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7ccc886e-61cc-475e-9ab4-b1723078e7e4/093617db718ce4669b6a93f2d8934b1f/aspnetcore-runtime-9.0.0-preview.4.24267.6-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/92b6f660-9ac3-4f16-85ff-28e623f6d1d8/cc4895fbe24aeca773a1c1ad991c2d0a/aspnetcore-runtime-9.0.0-preview.4.24267.6-win-arm64.exe
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/accb26be-44e1-4940-8add-d51e6c3dfdb8/6514f378b6921d8cf43deaa94d803197/aspnetcore-runtime-9.0.0-preview.4.24267.6-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c4862573-61c6-491e-82c5-851c6e68e50b/6685d83ef28ca605014610d2302db83d/aspnetcore-runtime-9.0.0-preview.4.24267.6-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a97e2ca1-2463-480b-a8d9-1ef74cbeb1b8/a817f2e44eefb42f8859ce34d4ab4d05/aspnetcore-runtime-9.0.0-preview.4.24267.6-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c041c63a-938d-4c08-95a5-d019b64af27e/1ed28254f2a8d92e934968b77b90701a/aspnetcore-runtime-9.0.0-preview.4.24267.6-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/51f63e30-95a8-4c1e-81b7-4da3b8d66c22/d56ec056ada0081cad7ffa34bc7461e7/aspnetcore-runtime-9.0.0-preview.4.24267.6-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4345184c-9cb3-447b-8515-f577a4f80082/15e68b416144285b265fc84e11e6b54d/aspnetcore-runtime-composite-9.0.0-preview.4.24267.6-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3241265e-62d8-4a77-aed5-ec07d829a4f9/c3beb873fd6733a0e17741681220fe1b/aspnetcore-runtime-composite-9.0.0-preview.4.24267.6-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c4601543-9425-4a65-a7dc-890fc5031fd1/ee9980fb39cd686314d2ce281d57e9c8/aspnetcore-runtime-composite-9.0.0-preview.4.24267.6-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e0785796-d1f1-4224-b951-be51959d2422/cb7309f3f96bb1d6c87e003f5bea97a0/aspnetcore-runtime-composite-9.0.0-preview.4.24267.6-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5b89c4c9-b798-4eb3-a7cb-4b84f5cfccba/9cc25a4b4e004197ec7d99c53406f266/aspnetcore-runtime-composite-9.0.0-preview.4.24267.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/75d03b48-e892-4ecc-bac2-94b361ec9f15/8c345c3075ad13ec8c9013e7f1d08d85/aspnetcore-runtime-composite-9.0.0-preview.4.24267.6-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/dc7f36ba-c8ca-4dbb-9fc6-ba10ec01c36f/fd73f2c002241fec538305a8cf26c203/dotnet-hosting-9.0.0-preview.4.24267.6-win.exe

[//]: # ( SDK 9.0.100-preview.4.24267.66)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eb98063a-61bc-443b-b51d-0bc82cfa10bb/ef920311f783df4ade75298fcd45c9f7/dotnet-sdk-9.0.100-preview.4.24267.66-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/098a764a-8756-47c5-97e9-118431c31b9f/2e1b737cb4750deadb0136283346c7ed/dotnet-sdk-9.0.100-preview.4.24267.66-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/42b4a871-aa76-4e76-81d8-4de3adc015b7/1e6a598bb1c74ca1bd0f97701c1beec9/dotnet-sdk-9.0.100-preview.4.24267.66-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5970728d-630b-4a98-b92e-c7411094995d/97319be6b9b617c0e5529a89476d4431/dotnet-sdk-9.0.100-preview.4.24267.66-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/42143563-4bb7-456d-b3ce-698869c0feee/129e62b28eb216976385ddb095159013/dotnet-sdk-9.0.100-preview.4.24267.66-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/87f2eabb-8ba2-4677-9f91-526672f51857/9ed7fb997d40a369c038269a514fc4e4/dotnet-sdk-9.0.100-preview.4.24267.66-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/343689ab-65e1-4633-b85a-ca1bb8a0e5d1/e04cf1a20a665f377e2ea45d3a9734c5/dotnet-sdk-9.0.100-preview.4.24267.66-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e003d2d1-abfd-45f6-aca2-e3f2199e3633/dcefd0cccdfb48a3fbb20b14fd2fe22c/dotnet-sdk-9.0.100-preview.4.24267.66-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f0858498-9230-46ee-9cf4-fb68aec0e37d/58e82c5b5705f0fd9efb2d4ecc74c02b/dotnet-sdk-9.0.100-preview.4.24267.66-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3cee1ac-1bb3-48b0-8a35-813e511d1d41/dbcba8b2e6d28886d07bec53ab509225/dotnet-sdk-9.0.100-preview.4.24267.66-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/29c1ff6f-0156-43d4-b86c-9e7d3d99676d/d6097b452228be86bc95b995688685c2/dotnet-sdk-9.0.100-preview.4.24267.66-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7b9dad11-8a62-4521-9984-3a099d9ce61d/a0a1fe27a63ac76480db3281577edcef/dotnet-sdk-9.0.100-preview.4.24267.66-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1515bcb1-1862-43c5-a86c-180b1ec9049d/c4049cf3b8eb87e40dff823573cf563d/dotnet-sdk-9.0.100-preview.4.24267.66-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5bb0c9db-5ddb-44e7-90d1-bf34c1ac688f/8ba52405d812250c4b31e81e94c62334/dotnet-sdk-9.0.100-preview.4.24267.66-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bb1317f1-6c8d-4287-b10e-618e67cff2ff/d7537c37617a5d5d56b87079a24a2a66/dotnet-sdk-9.0.100-preview.4.24267.66-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ce78ba3f-c369-408e-8026-a2318844db65/d1636d07dd075acfdaad4d80d69b6262/dotnet-sdk-9.0.100-preview.4.24267.66-win-x86.zip
