# System.Numerics

``` diff
 namespace System.Numerics {
     public interface IFloatingPoint<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : IFloatingPoint<TSelf>? {
+        TInteger ConvertToInteger<TInteger>(TSelf value);
+        TInteger ConvertToIntegerNative<TInteger>(TSelf value);
     }
     public static class Vector {
+        public static Vector<Int32> ConvertToInt32Native(Vector<Single> value);
+        public static Vector<Int64> ConvertToInt64Native(Vector<Double> value);
+        public static Vector<UInt32> ConvertToUInt32Native(Vector<Single> value);
+        public static Vector<UInt64> ConvertToUInt64Native(Vector<Double> value);
     }
 }
```

