# System

``` diff
 namespace System {
     public static class Console {
+        public static void Write(string format, ReadOnlySpan<object?> arg);
+        public static void WriteLine(string format, ReadOnlySpan<object?> arg);
     }
     public readonly struct Decimal : IAdditionOperators<decimal, decimal, decimal>, IAdditiveIdentity<decimal, decimal>, IComparable, IComparable<decimal>, IComparisonOperators<decimal, decimal, bool>, IConvertible, IDecrementOperators<decimal>, IDeserializationCallback, IDivisionOperators<decimal, decimal, decimal>, IEqualityOperators<decimal, decimal, bool>, IEquatable<decimal>, IFloatingPoint<decimal>, IFloatingPointConstants<decimal>, IFormattable, IIncrementOperators<decimal>, IMinMaxValue<decimal>, IModulusOperators<decimal, decimal, decimal>, IMultiplicativeIdentity<decimal, decimal>, IMultiplyOperators<decimal, decimal, decimal>, INumber<decimal>, INumberBase<decimal>, IParsable<decimal>, ISerializable, ISignedNumber<decimal>, ISpanFormattable, ISpanParsable<decimal>, ISubtractionOperators<decimal, decimal, decimal>, IUnaryNegationOperators<decimal, decimal>, IUnaryPlusOperators<decimal, decimal>, IUtf8SpanFormattable, IUtf8SpanParsable<decimal> {
+        static TInteger ConvertToInteger<TInteger>(Decimal value);
+        static TInteger ConvertToIntegerNative<TInteger>(Decimal value);
     }
     public abstract class Delegate : ICloneable, ISerializable {
+        public static Delegate? Combine(ReadOnlySpan<Delegate?> delegates);
     }
     public readonly struct Double : IAdditionOperators<double, double, double>, IAdditiveIdentity<double, double>, IBinaryFloatingPointIeee754<double>, IBinaryNumber<double>, IBitwiseOperators<double, double, double>, IComparable, IComparable<double>, IComparisonOperators<double, double, bool>, IConvertible, IDecrementOperators<double>, IDivisionOperators<double, double, double>, IEqualityOperators<double, double, bool>, IEquatable<double>, IExponentialFunctions<double>, IFloatingPoint<double>, IFloatingPointConstants<double>, IFloatingPointIeee754<double>, IFormattable, IHyperbolicFunctions<double>, IIncrementOperators<double>, ILogarithmicFunctions<double>, IMinMaxValue<double>, IModulusOperators<double, double, double>, IMultiplicativeIdentity<double, double>, IMultiplyOperators<double, double, double>, INumber<double>, INumberBase<double>, IParsable<double>, IPowerFunctions<double>, IRootFunctions<double>, ISignedNumber<double>, ISpanFormattable, ISpanParsable<double>, ISubtractionOperators<double, double, double>, ITrigonometricFunctions<double>, IUnaryNegationOperators<double, double>, IUnaryPlusOperators<double, double>, IUtf8SpanFormattable, IUtf8SpanParsable<double> {
+        static TInteger ConvertToInteger<TInteger>(Double value);
+        static TInteger ConvertToIntegerNative<TInteger>(Double value);
     }
     public readonly struct Half : IAdditionOperators<Half, Half, Half>, IAdditiveIdentity<Half, Half>, IBinaryFloatingPointIeee754<Half>, IBinaryNumber<Half>, IBitwiseOperators<Half, Half, Half>, IComparable, IComparable<Half>, IComparisonOperators<Half, Half, bool>, IDecrementOperators<Half>, IDivisionOperators<Half, Half, Half>, IEqualityOperators<Half, Half, bool>, IEquatable<Half>, IExponentialFunctions<Half>, IFloatingPoint<Half>, IFloatingPointConstants<Half>, IFloatingPointIeee754<Half>, IFormattable, IHyperbolicFunctions<Half>, IIncrementOperators<Half>, ILogarithmicFunctions<Half>, IMinMaxValue<Half>, IModulusOperators<Half, Half, Half>, IMultiplicativeIdentity<Half, Half>, IMultiplyOperators<Half, Half, Half>, INumber<Half>, INumberBase<Half>, IParsable<Half>, IPowerFunctions<Half>, IRootFunctions<Half>, ISignedNumber<Half>, ISpanFormattable, ISpanParsable<Half>, ISubtractionOperators<Half, Half, Half>, ITrigonometricFunctions<Half>, IUnaryNegationOperators<Half, Half>, IUnaryPlusOperators<Half, Half>, IUtf8SpanFormattable, IUtf8SpanParsable<Half> {
+        static TInteger ConvertToInteger<TInteger>(Half value);
+        static TInteger ConvertToIntegerNative<TInteger>(Half value);
     }
     public readonly struct Single : IAdditionOperators<float, float, float>, IAdditiveIdentity<float, float>, IBinaryFloatingPointIeee754<float>, IBinaryNumber<float>, IBitwiseOperators<float, float, float>, IComparable, IComparable<float>, IComparisonOperators<float, float, bool>, IConvertible, IDecrementOperators<float>, IDivisionOperators<float, float, float>, IEqualityOperators<float, float, bool>, IEquatable<float>, IExponentialFunctions<float>, IFloatingPoint<float>, IFloatingPointConstants<float>, IFloatingPointIeee754<float>, IFormattable, IHyperbolicFunctions<float>, IIncrementOperators<float>, ILogarithmicFunctions<float>, IMinMaxValue<float>, IModulusOperators<float, float, float>, IMultiplicativeIdentity<float, float>, IMultiplyOperators<float, float, float>, INumber<float>, INumberBase<float>, IParsable<float>, IPowerFunctions<float>, IRootFunctions<float>, ISignedNumber<float>, ISpanFormattable, ISpanParsable<float>, ISubtractionOperators<float, float, float>, ITrigonometricFunctions<float>, IUnaryNegationOperators<float, float>, IUnaryPlusOperators<float, float>, IUtf8SpanFormattable, IUtf8SpanParsable<float> {
+        static TInteger ConvertToInteger<TInteger>(Single value);
+        static TInteger ConvertToIntegerNative<TInteger>(Single value);
     }
     public sealed class String : ICloneable, IComparable, IComparable<string?>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string?>, IParsable<string>, ISpanParsable<string> {
+        public static String Concat(ReadOnlySpan<object?> args);
+        public static String Concat(ReadOnlySpan<string?> values);
+        public static String Format(IFormatProvider? provider, String format, ReadOnlySpan<object?> args);
+        public static String Format(String format, ReadOnlySpan<object?> args);
+        public static String Join(char separator, ReadOnlySpan<object?> values);
+        public static String Join(char separator, ReadOnlySpan<string?> value);
+        public static String Join(String? separator, ReadOnlySpan<object?> values);
+        public static String Join(String? separator, ReadOnlySpan<string?> value);
+        public string[] Split(ReadOnlySpan<char> separator);
+        public String Trim(ReadOnlySpan<char> trimChars);
+        public String TrimEnd(ReadOnlySpan<char> trimChars);
+        public String TrimStart(ReadOnlySpan<char> trimChars);
     }
 }
```

