# .NET 9 Preview 5 Binaries

.NET 9 Preview 5 installers and binaries can be downloaded for the following product versions:

- `.NET 9.0.0 Preview 5`
- `.NET SDK 9.0.100-preview.5.24307.3`

See [README.md](README.md) for .NET 9 release notes and discussions.

The latest .NET releases are always listed at [.NET Releases](../../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
9.0.100-preview.5.24307.3
```

## .NET Multi-Platform App UI (MAUI) Workload Downloads

 After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

 ```console
 $ dotnet workload install maui
 ```

 The following workloads are also available to install individually:

 ```console
 $ dotnet workload install android
 $ dotnet workload install ios
 $ dotnet workload install maccatalyst
 $ dotnet workload install macos
 $ dotnet workload install tvos
 ```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 9.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

.NET 9 is compatible with  [Visual Studio 17.11 latest preview](https://visualstudio.microsoft.com) Users will have to [download](https://dotnet.microsoft.com/download/dotnet/9.0) and install the .NET 9 runtime/sdk standalone. Visual Studio for Mac is currently not supported for .NET 9.0 Preview releases.

## Feedback

Your feedback is important and appreciated. We've created an issue at https://aka.ms/dotnet/9/preview5 for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.DotNet.ApiCompat.Task | 9.0.100-preview.5.24307.3
Microsoft.DotNet.Common.ProjectTemplates.9.0 | 9.0.100-preview.5.24307.3
Microsoft.DotNet.ApiCompat.Tool | 9.0.100-preview.5.24307.3
FSharp.Compiler.Service | 43.8.400-preview.24280.1
FSharp.Core | 8.0.400-beta.24280.1
Microsoft.DotNet.Common.ItemTemplates | 9.0.100-preview.5.24307.3
Microsoft.NET.Build.Containers | 9.0.100-preview.5.24307.3
Microsoft.Net.Compilers.Toolset.Framework | 4.11.0-3.24280.3
Microsoft.TemplateEngine.Authoring.Tasks | 9.0.100-preview.5.24306.2
Microsoft.TemplateEngine.Authoring.Templates | 9.0.100-preview.5.24306.2
Microsoft.TemplateEngine.Edge | 9.0.100-preview.5.24306.2
Microsoft.TemplateEngine.Authoring.CLI | 9.0.100-preview.5.24306.2
Microsoft.TemplateEngine.Core | 9.0.100-preview.5.24306.2
Microsoft.TemplateEngine.Core.Contracts | 9.0.100-preview.5.24306.2
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 9.0.100-preview.5.24306.2
Microsoft.TemplateEngine.TemplateLocalizer.Core | 9.0.100-preview.5.24306.2
Microsoft.TemplateEngine.Samples | 9.0.100-preview.5.24306.2
Microsoft.TemplateEngine.Utils | 9.0.100-preview.5.24306.2
Microsoft.TemplateSearch.Common | 9.0.100-preview.5.24306.2
Microsoft.TemplateEngine.Abstractions | 9.0.100-preview.5.24306.2
Microsoft.TemplateEngine.IDE | 9.0.100-preview.5.24306.2
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 9.0.100-preview.5.24306.2
Microsoft.Bcl.Numerics | 9.0.0-preview.5.24306.7
Microsoft.Bcl.TimeProvider | 9.0.0-preview.5.24306.7
Microsoft.Bcl.AsyncInterfaces | 9.0.0-preview.5.24306.7
Microsoft.DotNet.ILCompiler | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Caching.Abstractions | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Caching.Memory | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Configuration.Json | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Configuration.UserSecrets | 9.0.0-preview.5.24306.7
Microsoft.Extensions.DependencyInjection | 9.0.0-preview.5.24306.7
Microsoft.Extensions.FileProviders.Composite | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Logging.Abstractions | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Logging | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Logging.Configuration | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Logging.Console | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Logging.Debug | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Logging.EventLog | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Primitives | 9.0.0-preview.5.24306.7
Microsoft.ILVerification | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.Android.Sample.Mono | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.WebAssembly.Templates | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.linux-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.linux-musl-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.win-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.win-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.wasi-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-preview.5.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Crossgen2.win-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Crossgen2.win-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Crossgen2.osx-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.linux-musl-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.linux-bionic-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.linux-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.osx-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.wasi-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.browser-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.browser-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.linux-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-preview.5 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-preview.5.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.osx-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.browser-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x86.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.wasi-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.wasi-wasm.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 9.0.0-preview.5.24306.7
dotnet-ilverify | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Options.DataAnnotations | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Options | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Options.ConfigurationExtensions | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.WebAssembly.Sdk | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Crossgen2.win-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.linux-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.linux-musl-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Host.win-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.wasi-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-musl-x64.Cross.android-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.browser-wasm.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.win-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
Microsoft.NETCore.ILAsm | 9.0.0-preview.5.24306.7
Microsoft.Win32.SystemEvents | 9.0.0-preview.5.24306.7
Microsoft.XmlSerializer.Generator | 9.0.0-preview.5.24306.7
runtime.android-arm.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.android-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.android-x64.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.linux-arm64.Microsoft.NETCore.ILAsm | 9.0.0-preview.5.24306.7
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
runtime.linux-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.5.24306.7
runtime.win-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.5.24306.7
runtime.win-x64.Microsoft.NETCore.ILAsm | 9.0.0-preview.5.24306.7
runtime.win-x64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.5.24306.7
runtime.win-x86.Microsoft.NETCore.ILDAsm | 9.0.0-preview.5.24306.7
Microsoft.NET.Sdk.WebAssembly.Pack.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Sdk.WebAssembly.Pack.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Sdk.WebAssembly.Pack.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NET.WebAssembly.Threading | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Crossgen2.linux-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.wasi-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.linux-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.linux-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 9.0.0-preview.5.24306.7
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.win-x86.Microsoft.DotNet.ILCompiler | 9.0.0-preview.5.24306.7
runtime.osx-x64.Microsoft.NETCore.ILAsm | 9.0.0-preview.5.24306.7
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.5.24306.7
runtime.win-x64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.5.24306.7
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
runtime.win-x86.Microsoft.NETCore.ILAsm | 9.0.0-preview.5.24306.7
System.ComponentModel.Composition | 9.0.0-preview.5.24306.7
System.CodeDom | 9.0.0-preview.5.24306.7
System.Collections.Immutable | 9.0.0-preview.5.24306.7
System.ComponentModel.Composition.Registration | 9.0.0-preview.5.24306.7
System.Composition.Hosting | 9.0.0-preview.5.24306.7
System.Composition.Convention | 9.0.0-preview.5.24306.7
System.Data.Odbc | 9.0.0-preview.5.24306.7
System.Composition.Runtime | 9.0.0-preview.5.24306.7
System.Composition.TypedParts | 9.0.0-preview.5.24306.7
System.Configuration.ConfigurationManager | 9.0.0-preview.5.24306.7
System.Data.OleDb | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.linux-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.ILDAsm | 9.0.0-preview.5.24306.7
Microsoft.Win32.Registry.AccessControl | 9.0.0-preview.5.24306.7
System.Management | 9.0.0-preview.5.24306.7
System.Threading.Tasks.Dataflow | 9.0.0-preview.5.24306.7
Microsoft.Bcl.Cryptography | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Configuration | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Configuration.Abstractions | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Configuration.Ini | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Configuration.Xml | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Configuration.CommandLine | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Configuration.Binder | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Hosting.Systemd | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Hosting.WindowsServices | 9.0.0-preview.5.24306.7
Microsoft.Extensions.FileProviders.Physical | 9.0.0-preview.5.24306.7
Microsoft.Extensions.FileSystemGlobbing | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Http | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Logging.TraceSource | 9.0.0-preview.5.24306.7
Microsoft.NET.ILLink.Tasks | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.MonoTargets.Sdk | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.wasm.Sample.Mono | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-preview.5.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-preview.5.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-preview.5 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-preview.5.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Crossgen2.linux-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-arm64.Cross.android-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.wasi-wasm.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.linux-musl-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.win-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 9.0.0-preview.5.24306.7
runtime.linux-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
runtime.linux-bionic-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.linux-x64.Microsoft.NETCore.ILAsm | 9.0.0-preview.5.24306.7
runtime.linux-x64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.5.24306.7
runtime.linux-x64.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.osx-arm64.Microsoft.NETCore.ILAsm | 9.0.0-preview.5.24306.7
runtime.osx-x64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.5.24306.7
System.Diagnostics.DiagnosticSource | 9.0.0-preview.5.24306.7
System.Diagnostics.EventLog | 9.0.0-preview.5.24306.7
System.DirectoryServices.AccountManagement | 9.0.0-preview.5.24306.7
System.DirectoryServices.Protocols | 9.0.0-preview.5.24306.7
System.Formats.Cbor | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.linux-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.linux-musl-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.linux-musl-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.win-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.win-x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.win-x86 | 9.0.0-preview.5.24306.7
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
runtime.android-x86.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.5.24306.7
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
System.Composition | 9.0.0-preview.5.24306.7
System.Diagnostics.PerformanceCounter | 9.0.0-preview.5.24306.7
System.DirectoryServices | 9.0.0-preview.5.24306.7
System.IO.Pipelines | 9.0.0-preview.5.24306.7
System.Reflection.MetadataLoadContext | 9.0.0-preview.5.24306.7
System.Security.Cryptography.ProtectedData | 9.0.0-preview.5.24306.7
System.Speech | 9.0.0-preview.5.24306.7
System.Security.Permissions | 9.0.0-preview.5.24306.7
System.Text.Encoding.CodePages | 9.0.0-preview.5.24306.7
System.Memory.Data | 9.0.0-preview.5.24306.7
System.Runtime.Serialization.Schema | 9.0.0-preview.5.24306.7
System.Security.Cryptography.Pkcs | 9.0.0-preview.5.24306.7
System.ServiceModel.Syndication | 9.0.0-preview.5.24306.7
System.Text.Encodings.Web | 9.0.0-preview.5.24306.7
System.Windows.Extensions | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.win-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 9.0.0-preview.5.24306.7
runtime.linux-musl-arm.Microsoft.NETCore.ILDAsm | 9.0.0-preview.5.24306.7
runtime.linux-musl-arm.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.linux-musl-arm64.Microsoft.NETCore.ILAsm | 9.0.0-preview.5.24306.7
runtime.linux-musl-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.5.24306.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
runtime.linux-musl-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.linux-musl-x64.Microsoft.NETCore.ILAsm | 9.0.0-preview.5.24306.7
runtime.linux-musl-x64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.5.24306.7
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
runtime.maccatalyst-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.5.24306.7
runtime.osx-x64.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
System.Formats.Asn1 | 9.0.0-preview.5.24306.7
System.IO.Hashing | 9.0.0-preview.5.24306.7
System.IO.Packaging | 9.0.0-preview.5.24306.7
System.Text.Json | 9.0.0-preview.5.24306.7
Microsoft.NET.Sdk.WebAssembly.Pack | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-preview.5 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-9.0.100-preview.5.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-preview.5.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-9.0.100-preview.5.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-preview.5.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-9.0.100-preview.5.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-preview.5.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-preview.5.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Ref | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.wasi-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.linux-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.osx-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.osx-x64 | 9.0.0-preview.5.24306.7
runtime.linux-arm.Microsoft.NETCore.ILDAsm | 9.0.0-preview.5.24306.7
runtime.linux-arm.Microsoft.NETCore.ILAsm | 9.0.0-preview.5.24306.7
runtime.linux-arm.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.linux-musl-arm.Microsoft.DotNet.ILCompiler | 9.0.0-preview.5.24306.7
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.5.24306.7
runtime.linux-bionic-x64.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.linux-musl-x64.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
Microsoft.Extensions.DependencyInjection.Specification.Tests | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Configuration.EnvironmentVariables | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Configuration.FileExtensions | 9.0.0-preview.5.24306.7
Microsoft.Extensions.DependencyInjection.Abstractions | 9.0.0-preview.5.24306.7
Microsoft.Extensions.DependencyModel | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Diagnostics.Abstractions | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Diagnostics | 9.0.0-preview.5.24306.7
Microsoft.Extensions.FileProviders.Abstractions | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Hosting | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Hosting.Abstractions | 9.0.0-preview.5.24306.7
Microsoft.Extensions.Logging.EventSource | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.iOS.Sample.Mono | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NET.Sdk.IL | 9.0.0-preview.5.24306.7
Microsoft.NET.Workload.Mono.ToolChain.net8.Manifest-9.0.100-preview.5 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-musl-arm64.Cross.android-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.wasi-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.wasi-wasm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.linux-musl-arm | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 9.0.0-preview.5.24306.7
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 9.0.0-preview.5.24306.7
runtime.linux-arm.Microsoft.DotNet.ILCompiler | 9.0.0-preview.5.24306.7
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.5.24306.7
runtime.linux-musl-arm.Microsoft.NETCore.ILAsm | 9.0.0-preview.5.24306.7
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.5.24306.7
runtime.maccatalyst-x64.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.osx-arm64.Microsoft.NETCore.ILDAsm | 9.0.0-preview.5.24306.7
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 9.0.0-preview.5.24306.7
runtime.osx-arm64.runtime.native.System.IO.Ports | 9.0.0-preview.5.24306.7
runtime.win-arm64.Microsoft.NETCore.ILAsm | 9.0.0-preview.5.24306.7
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 9.0.0-preview.5.24306.7
System.Composition.AttributedModel | 9.0.0-preview.5.24306.7
System.IO.Ports | 9.0.0-preview.5.24306.7
System.Net.Http.Json | 9.0.0-preview.5.24306.7
System.Net.Http.WinHttpHandler | 9.0.0-preview.5.24306.7
System.Numerics.Tensors | 9.0.0-preview.5.24306.7
System.Reflection.Context | 9.0.0-preview.5.24306.7
System.Reflection.Metadata | 9.0.0-preview.5.24306.7
System.Resources.Extensions | 9.0.0-preview.5.24306.7
System.Runtime.Caching | 9.0.0-preview.5.24306.7
System.Security.Cryptography.Cose | 9.0.0-preview.5.24306.7
System.Security.Cryptography.Xml | 9.0.0-preview.5.24306.7
System.Threading.AccessControl | 9.0.0-preview.5.24306.7
System.ServiceProcess.ServiceController | 9.0.0-preview.5.24306.7
System.Threading.Channels | 9.0.0-preview.5.24306.7
System.Threading.RateLimiting | 9.0.0-preview.5.24306.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-musl-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-preview.5.Msi.arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-preview.5.Msi.x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-musl-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-musl-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-preview.5.Msi.x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-preview.5.Msi.arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-musl-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-preview.5.Msi.x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-preview.5.Msi.x86 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-musl-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-musl-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-preview.5.Msi.x86 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-preview.5.Msi.arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-preview.5.Msi.x86 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.Current.Manifest-9.0.100-preview.5 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-9.0.100-preview.5 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-preview.5 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-preview.5.Msi.x86 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-preview.5.Msi.arm64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.net8.Manifest-9.0.100-preview.5.Msi.x64 | 9.0.0-preview.5.24306.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-9.0.100-preview.5 | 9.0.0-preview.5.24306.1
Microsoft.Net.Compilers.Toolset.Framework | 4.11.0-3.24280.3
Microsoft.AspNetCore.Http.Connections.Client | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.App.Runtime.linux-arm | 9.0.0-preview.5.24306.11
AspNetCoreRuntime.9.0.x86 | 9.0.0-preview-5-24306-11
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.App.Runtime.linux-x64 | 9.0.0-preview.5.24306.11
dotnet-sql-cache | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Authentication.Facebook | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Authentication.JwtBearer | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Authorization | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components.Authorization | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components.CustomElements | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.AzureAppServicesIntegration | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components.Analyzers | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components.QuickGrid | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components.WebAssembly.Server | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Identity.UI | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.SignalR.Specification.Tests | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.SpaProxy | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.SpaServices.Extensions | 9.0.0-preview.5.24306.11
AspNetCoreRuntime.9.0.x64 | 9.0.0-preview-5-24306-11
Microsoft.AspNetCore.App.Runtime.win-arm64 | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Authentication.WsFederation | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components.Forms | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Cryptography.Internal | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Cryptography.KeyDerivation | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.DataProtection.Extensions | 9.0.0-preview.5.24306.11
Microsoft.DotNet.Web.ProjectTemplates.9.0 | 9.0.0-preview.5.24306.11
Microsoft.Extensions.ApiDescription.Client | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Caching.SqlServer | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Localization.Abstractions | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.App.Runtime.win-x86 | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.App.Ref | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Authentication.Google | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Authentication.Negotiate | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Authentication.OpenIdConnect | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Authentication.Twitter | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components.Web | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.DataProtection.Abstractions | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Grpc.Swagger.0 | 9.0-preview.5.24306.11
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Grpc.JsonTranscoding | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.HeaderPropagation | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Hosting.WindowsServices | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.JsonPatch | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.MiddlewareAnalysis | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Metadata | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Mvc.Testing | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Owin | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.OpenApi | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.SignalR.Client.Core | 9.0.0-preview.5.24306.11
Microsoft.Extensions.ApiDescription.Server | 9.0.0-preview.5.24306.11
Microsoft.DotNet.Web.ItemTemplates.9.0 | 9.0.0-preview.5.24306.11
Microsoft.JSInterop.WebAssembly | 9.0.0-preview.5.24306.11
Microsoft.Net.Http.Headers | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.App.Runtime.osx-x64 | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.App.Runtime.win-x64 | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Authentication.Certificate | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components.WebAssembly | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Components.WebView | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.ConcurrencyLimiter | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Connections.Abstractions | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.DataProtection | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.Http.Connections.Common | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.SignalR.Client | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.SignalR.Common | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.SignalR.Protocols.Json | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.TestHost | 9.0.0-preview.5.24306.11
Microsoft.AspNetCore.WebUtilities | 9.0.0-preview.5.24306.11
Microsoft.Authentication.WebAssembly.Msal | 9.0.0-preview.5.24306.11
Microsoft.dotnet-openapi | 9.0.0-preview.5.24306.11
Microsoft.DotNet.Web.Client.ItemTemplates | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Caching.Hybrid | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Caching.StackExchangeRedis | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Configuration.KeyPerFile | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Diagnostics.HealthChecks | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Features | 9.0.0-preview.5.24306.11
Microsoft.Extensions.FileProviders.Embedded | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Http.Polly | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Identity.Core | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Localization | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Identity.Stores | 9.0.0-preview.5.24306.11
Microsoft.Extensions.ObjectPool | 9.0.0-preview.5.24306.11
Microsoft.Extensions.WebEncoders | 9.0.0-preview.5.24306.11
Microsoft.Extensions.Logging.AzureAppServices | 9.0.0-preview.5.24306.11
Microsoft.JSInterop | 9.0.0-preview.5.24306.11
Microsoft.WindowsDesktop.App.Ref | 9.0.0-preview.5.24306.8
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 9.0.0-preview.5.24306.8
Microsoft.Windows.Compatibility | 9.0.0-preview.5.24306.8
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 9.0.0-preview.5.24306.8
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 9.0.0-preview.5.24306.8
System.Drawing.Common | 9.0.0-preview.5.24306.5
Microsoft.CodeAnalysis.Metrics | 4.0.0-beta1.24225.1
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter | 3.11.0-beta1.24225.1
Microsoft.CodeAnalysis.NetAnalyzers | 9.0.0-preview.24225.1
Text.Analyzers | 3.11.0-beta1.24225.1
Roslyn.Diagnostics.Analyzers | 3.11.0-beta1.24225.1
Microsoft.CodeAnalysis.BannedApiAnalyzers | 3.11.0-beta1.24225.1
Microsoft.CodeAnalysis.Analyzers | 3.11.0-beta1.24225.1
Microsoft.CodeAnalysis.PerformanceSensitiveAnalyzers | 3.11.0-beta1.24225.1
Microsoft.CodeAnalysis.PublicApiAnalyzers | 3.11.0-beta1.24225.1
Microsoft.CodeAnalysis.ResxSourceGenerator | 3.11.0-beta1.24225.1
Microsoft.CodeAnalysis.AnalyzerUtilities | 3.11.0-beta1.24225.1
Microsoft.EntityFrameworkCore.Abstractions | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.Relational | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.SqlServer | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.Sqlite | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.Sqlite.Core | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.Tools | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 9.0.0-preview.5.24306.3
dotnet-ef | 9.0.0-preview.5.24306.3
Microsoft.Data.Sqlite | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore | 9.0.0-preview.5.24306.3
Microsoft.Data.Sqlite.Core | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.Cosmos | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.Design | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.Analyzers | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.Specification.Tests | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.InMemory | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.Proxies | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.Templates | 9.0.0-preview.5.24306.3
Microsoft.EntityFrameworkCore.Tasks | 9.0.0-preview.5.24306.3
Microsoft.Net.Compilers.Toolset.Framework | 4.11.0-2.24269.3

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 9.0.0-preview.5.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/9.0.0-preview.5-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/9.0.0-preview.5-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: ../../install-linux.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-9-preview-4
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-9-preview-4/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef9-preview-4/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A9.0.0-preview5+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A9.0.0-preview5+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A9.0.0-preview5+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A9.0.0-preview5+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A9.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A9.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A9.0.1xx
[linux-packages]: ../../install-linux.md


[//]: # ( Runtime 9.0.0-preview.5.24306.7)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/31e7d9fb-9414-40f5-a12a-bee1649c4402/09ca8c548f4492c664ab654a225bc1cc/dotnet-runtime-9.0.0-preview.5.24306.7-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7ac3c308-bdeb-4fff-98b8-b22ff6c479aa/31e3d32e7732b17506d41cb6cd7a51b2/dotnet-runtime-9.0.0-preview.5.24306.7-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/76b19839-edc8-47ce-9d60-72aa67ff8c41/6d659b8e3ff0b7bd76e2f79b82d6cdf2/dotnet-runtime-9.0.0-preview.5.24306.7-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9dfae8d9-9567-49de-8872-3f8a1f218380/6ce317e891b4426f435cf5189d1ea925/dotnet-runtime-9.0.0-preview.5.24306.7-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/36b2f309-949b-4366-be8f-cdcf152c617e/8ea218ed0b23fc78a351cab9b1ed1f0c/dotnet-runtime-9.0.0-preview.5.24306.7-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/acc83ac1-a75a-453d-beb1-ab0eef7544b6/fc1c9260c812441c5c51370aa57ea1f9/dotnet-runtime-9.0.0-preview.5.24306.7-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/127371ea-846e-4a3a-9f2b-9d9f4058caba/9fdf695f9a388cef6a0af6a92dc18c18/dotnet-runtime-9.0.0-preview.5.24306.7-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/42df8bc2-3414-4253-99f0-50d52d4b0c36/a9b0b1664e2dcba0622b9dc6c6a8a8e8/dotnet-runtime-9.0.0-preview.5.24306.7-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/509552cc-02e8-438f-8c88-dd82b3775550/382bb36a28229b8c5f9798c91822a2b9/dotnet-runtime-9.0.0-preview.5.24306.7-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4a7db5f1-a6b4-4232-ba81-f848a8f6dde7/20b9502eb9b73e2f7ae047ae53cd1f21/dotnet-runtime-9.0.0-preview.5.24306.7-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/4933af57-6528-4320-bd0a-6ff672c6aaa7/1b7989cd8590fe25af0b915cb61cf100/dotnet-runtime-9.0.0-preview.5.24306.7-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b5a8db69-0aed-41ea-b6e2-18f59b74e8a3/f241e4b6b0e8b837fcfd4c0c320cb6eb/dotnet-runtime-9.0.0-preview.5.24306.7-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/aa73bf2d-5bdf-4c20-b673-9bb003e6fa1c/0c0fab1e7c74c74bdef199ac814a13d1/dotnet-runtime-9.0.0-preview.5.24306.7-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d4578076-c2c1-4083-931e-4bdfc0545d3d/c153c8ea28930c65a3247e24c18d85fc/dotnet-runtime-9.0.0-preview.5.24306.7-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6bf7d5fa-0998-4ed1-b595-7fa89efe5782/5f52d09fff08eb17ccb7586174b67471/dotnet-runtime-9.0.0-preview.5.24306.7-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b169201c-2a05-4555-a923-7054c5f3f912/3b53906e9a1b455e09edb80e0e7d3428/dotnet-runtime-9.0.0-preview.5.24306.7-win-x86.zip

[//]: # ( WindowsDesktop 9.0.0-preview.5.24306.8)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/fabdb881-9c52-4744-ae24-b529aca98806/c5b048d0f5d46b66ddec6643b3b8bbb7/windowsdesktop-runtime-9.0.0-preview.5.24306.8-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2ed957d2-54c3-479c-a17b-e4c721d25a86/0f56cbf7a7454a15de16fe20273ed8cb/windowsdesktop-runtime-9.0.0-preview.5.24306.8-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6c481981-dc6b-4e69-9c60-7f0c3ce64e0d/0b5a8d18e2014143af7faed2e2c5e251/windowsdesktop-runtime-9.0.0-preview.5.24306.8-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2790489a-2b90-47f5-a281-353a05c4cdd9/0833d5448b6481a29d8a58b6db98feca/windowsdesktop-runtime-9.0.0-preview.5.24306.8-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/976bdb90-8f89-49f0-871d-8aafcc1337c6/67bf6ba2ff55915f3c99dd88b0bbb6c0/windowsdesktop-runtime-9.0.0-preview.5.24306.8-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4dea813a-bc32-49f9-96c3-09b1762b4034/0b3bac88273cbce4e1d939114801c396/windowsdesktop-runtime-9.0.0-preview.5.24306.8-win-x86.zip

[//]: # ( ASP 9.0.0-preview.5.24306.11)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9885e829-9401-4f84-8948-33bfbec4a486/40b414d190c0c85614c18f42f6c4d1a9/aspnetcore-runtime-9.0.0-preview.5.24306.11-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e8849fb4-309b-4008-b697-4b5af127cc8e/285762b4db9cfb18abad4e005b37f2cb/aspnetcore-runtime-9.0.0-preview.5.24306.11-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0ac17d7b-df82-4c78-8be8-cedd92c28f23/f80b29a59db088239e19970058cd6c49/aspnetcore-runtime-9.0.0-preview.5.24306.11-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d1c32044-fdd8-49b9-90ee-87531de750e8/8c2d4018226292cebbe470335614f9e3/aspnetcore-runtime-9.0.0-preview.5.24306.11-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f6f9b71c-095a-4aeb-8eb7-fada01704860/117e89d575a73207194a9cffdbec78b9/aspnetcore-runtime-9.0.0-preview.5.24306.11-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f43de71b-3bf6-49ae-99ec-66499bfa6990/438e1533bbb47d3d7e1f58983677a4f6/aspnetcore-runtime-9.0.0-preview.5.24306.11-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b4c5eec1-4026-4e58-adfd-64dbf4426b1e/1f05059da0484ade0ba1ce6a3e8f6bd5/aspnetcore-runtime-9.0.0-preview.5.24306.11-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f07ad200-6654-4341-a594-9a1eb1ca66f9/929c2533f6fe9c402fcb5fee99ee1103/aspnetcore-runtime-9.0.0-preview.5.24306.11-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c78c4ab8-5fad-4d72-b5c5-6edd4c51fa2d/2154d7e93cc29caa92df1f8d990a8ea8/aspnetcore-runtime-9.0.0-preview.5.24306.11-win-arm64.exe
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8d13b17d-912a-4f52-bc64-05113d585ab3/40cab8f4d7efdf30ea9d5178e8f16de3/aspnetcore-runtime-9.0.0-preview.5.24306.11-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/33d48eed-15df-40b1-86db-86cfd602b8a9/f68eedd88c935d4e73028861f95f001b/aspnetcore-runtime-9.0.0-preview.5.24306.11-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b341e7de-2607-407e-a539-744dc7c0af3a/2a78d3e9a34f4e5f23150554921cdf6c/aspnetcore-runtime-9.0.0-preview.5.24306.11-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9b5c5c65-532f-4498-93a9-5b38449f577a/3369bf02ce5d8b74a109cb221baf5c2d/aspnetcore-runtime-9.0.0-preview.5.24306.11-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/86db0409-ec32-4dc6-bcc9-d5534ec20220/b5ed337c859e403f4b33a31891e1cd22/aspnetcore-runtime-9.0.0-preview.5.24306.11-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e04de0f4-59e6-42a8-9530-16af0bf369cc/c66a4ec5be50872a6606a8f8b2f78404/aspnetcore-runtime-composite-9.0.0-preview.5.24306.11-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b0f62525-01d8-4ed4-a091-086fd0210846/00a6b88fc1c125bde4a47b3ba9d6b209/aspnetcore-runtime-composite-9.0.0-preview.5.24306.11-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1d24de4-4253-4689-b74c-49200f858bb2/302418f944d071fc5add18730a928c9f/aspnetcore-runtime-composite-9.0.0-preview.5.24306.11-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/060552c1-2c74-40d7-b625-b35a7e41f827/c5b91c025b6ef6bf62b6fd1050fa67d2/aspnetcore-runtime-composite-9.0.0-preview.5.24306.11-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e1b305a5-cee3-47c6-919e-8772e5dd76ff/8dba7a53c74a331a667de203b2d2191f/aspnetcore-runtime-composite-9.0.0-preview.5.24306.11-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/44d88b11-6c78-407c-8f2b-c1c08065afc1/1e62a37ac72e089926415447b1989f8e/aspnetcore-runtime-composite-9.0.0-preview.5.24306.11-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/1eb7f78f-c605-4e38-b5b0-33b58ccb8460/c7421e8b5616b751a9a66c0c5abba81d/dotnet-hosting-9.0.0-preview.5.24306.11-win.exe

[//]: # ( SDK 9.0.100-preview.5.24307.3)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ff4f1830-f8bb-4be5-a065-ca27005ee25b/ab73d8a64752e5f94ca5de8e45871e5d/dotnet-sdk-9.0.100-preview.5.24307.3-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25f41d0d-d27c-4dc5-8884-6c49897d89d1/c51387b8bde1d278a0982b03c3e8c1b1/dotnet-sdk-9.0.100-preview.5.24307.3-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2a31f873-8093-4c63-8481-1d3cdc8f6f0a/c305f1ca9f40bad90c380fbb5f0de559/dotnet-sdk-9.0.100-preview.5.24307.3-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9281b5de-3ec7-4452-8e0c-5b18d02f0203/76790fd16370719461f1ee565fdf1142/dotnet-sdk-9.0.100-preview.5.24307.3-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/26ae7803-8ea9-4fb3-8b86-fc7218e5f57b/18b08c66b2a5872ba0b71078f0a80a80/dotnet-sdk-9.0.100-preview.5.24307.3-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/96e19e8f-579e-4a1d-a18e-6773a44d7cd1/092cfc588686cc698c449998b7d5ae35/dotnet-sdk-9.0.100-preview.5.24307.3-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4138605e-d1df-4672-b024-862b8b1bc4dc/bbf19075238cb836aa0483014f8174e3/dotnet-sdk-9.0.100-preview.5.24307.3-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/090175ff-fe42-4064-98fe-b6d90e08162d/bc72a57ada79f0ee7b71d74f5deb66a0/dotnet-sdk-9.0.100-preview.5.24307.3-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f4139839-15fa-4ef6-a1b0-fb77ee467b2e/7529958cc121871a79d3da1a0f851333/dotnet-sdk-9.0.100-preview.5.24307.3-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a6731f1c-ffd0-4cca-a309-89576e55552c/3000f43ca4b3b51bb034bd7daa514841/dotnet-sdk-9.0.100-preview.5.24307.3-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/4f58d46d-3ff2-4ad5-9e25-6abaf2a98699/d96c5e7e2b2f7bba1f56b73875a2f764/dotnet-sdk-9.0.100-preview.5.24307.3-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2c38b883-86fd-4970-b5fc-3486740fcb4e/17024f80e99c45f74ef69700c982d214/dotnet-sdk-9.0.100-preview.5.24307.3-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ad4f7358-9797-4301-bb3f-2bbaeffb1aea/7e740c0f41c8dd1e2282e5b88a65e727/dotnet-sdk-9.0.100-preview.5.24307.3-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b08c26a7-83de-4d9a-b4d7-d87942b6d35e/d6d973d0cfe914189692af1154690935/dotnet-sdk-9.0.100-preview.5.24307.3-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/99dfb394-02cb-4ab6-82ee-b15c7b5bb69a/cf6e482460f5237237f9232e9f9afedc/dotnet-sdk-9.0.100-preview.5.24307.3-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7e6cadfb-b694-4d94-9f0c-55b3a72e6089/11c7bbd8d2f072e483e274fec5e8654d/dotnet-sdk-9.0.100-preview.5.24307.3-win-x86.zip
