# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
     public abstract class ComponentBase : IComponent, IHandleAfterRender, IHandleEvent {
+        protected IComponentRenderMode? AssignedRenderMode { get; }
+        protected ComponentPlatform Platform { get; }
     }
+    public sealed class ComponentPlatform {
+        public ComponentPlatform(string platformName, bool isInteractive);
+        public bool IsInteractive { get; }
+        public string Name { get; }
+    }
     public readonly struct RenderHandle {
+        public ComponentPlatform Platform { get; }
+        public IComponentRenderMode? RenderMode { get; }
     }
 }
```

