# System.ComponentModel

``` diff
 namespace System.ComponentModel {
     public class ComponentResourceManager : ResourceManager {
+        public virtual void ApplyResourcesToRegisteredType(object value, string objectName, CultureInfo? culture);
     }
     public abstract class CustomTypeDescriptor : ICustomTypeDescriptor {
-        protected CustomTypeDescriptor(ICustomTypeDescriptor parent);
+        protected CustomTypeDescriptor(ICustomTypeDescriptor? parent);
+        public virtual bool? RequireRegisteredTypes { get; }
-        public virtual string GetClassName();
+        public virtual string? GetClassName();
-        public virtual string GetComponentName();
+        public virtual string? GetComponentName();
-        public virtual TypeConverter GetConverter();
+        public virtual TypeConverter? GetConverter();
+        public virtual TypeConverter? GetConverterFromRegisteredType();
-        public virtual EventDescriptor GetDefaultEvent();
+        public virtual EventDescriptor? GetDefaultEvent();
-        public virtual PropertyDescriptor GetDefaultProperty();
+        public virtual PropertyDescriptor? GetDefaultProperty();
+        public virtual EventDescriptorCollection GetEventsFromRegisteredType();
+        public virtual PropertyDescriptorCollection GetPropertiesFromRegisteredType();
-        public virtual object GetPropertyOwner(PropertyDescriptor pd);
+        public virtual object? GetPropertyOwner(PropertyDescriptor? pd);
     }
     public interface ICustomTypeDescriptor {
+        bool? RequireRegisteredTypes { get; }
+        TypeConverter? GetConverterFromRegisteredType();
+        EventDescriptorCollection GetEventsFromRegisteredType();
+        PropertyDescriptorCollection GetPropertiesFromRegisteredType();
     }
     public abstract class PropertyDescriptor : MemberDescriptor {
+        public virtual TypeConverter ConverterFromRegisteredType { get; }
     }
     public abstract class TypeDescriptionProvider {
+        public virtual bool? RequireRegisteredTypes { get; }
+        public virtual ICustomTypeDescriptor GetExtendedTypeDescriptorFromRegisteredType(object instance);
+        public ICustomTypeDescriptor? GetTypeDescriptorFromRegisteredType(object instance);
+        public ICustomTypeDescriptor? GetTypeDescriptorFromRegisteredType(Type objectType);
+        public virtual ICustomTypeDescriptor? GetTypeDescriptorFromRegisteredType(Type objectType, object? instance);
+        public virtual bool IsRegisteredType(Type type);
+        public virtual void RegisterType<T>();
     }
     public sealed class TypeDescriptor {
+        public static TypeConverter GetConverterFromRegisteredType(object component);
+        public static TypeConverter GetConverterFromRegisteredType(Type type);
+        public static EventDescriptorCollection GetEventsFromRegisteredType(Type componentType);
+        public static PropertyDescriptorCollection GetPropertiesFromRegisteredType(object component);
+        public static PropertyDescriptorCollection GetPropertiesFromRegisteredType(Type componentType);
+        public static void RegisterType<T>();
     }
 }
```

