# System.Numerics

``` diff
 namespace System.Numerics {
     public readonly struct BigInteger : IAdditionOperators<BigInteger, BigInteger, BigInteger>, IAdditiveIdentity<BigInteger, BigInteger>, IBinaryInteger<BigInteger>, IBinaryNumber<BigInteger>, IBitwiseOperators<BigInteger, BigInteger, BigInteger>, IComparable, IComparable<BigInteger>, IComparisonOperators<BigInteger, BigInteger, bool>, IDecrementOperators<BigInteger>, IDivisionOperators<BigInteger, BigInteger, BigInteger>, IEqualityOperators<BigInteger, BigInteger, bool>, IEquatable<BigInteger>, IFormattable, IIncrementOperators<BigInteger>, IModulusOperators<BigInteger, BigInteger, BigInteger>, IMultiplicativeIdentity<BigInteger, BigInteger>, IMultiplyOperators<BigInteger, BigInteger, BigInteger>, INumber<BigInteger>, INumberBase<BigInteger>, IParsable<BigInteger>, IShiftOperators<BigInteger, int, BigInteger>, ISignedNumber<BigInteger>, ISpanFormattable, ISpanParsable<BigInteger>, ISubtractionOperators<BigInteger, BigInteger, BigInteger>, IUnaryNegationOperators<BigInteger, BigInteger>, IUnaryPlusOperators<BigInteger, BigInteger>, IUtf8SpanFormattable, IUtf8SpanParsable<BigInteger> {
+        static BigInteger System.Numerics.INumberBase<System.Numerics.BigInteger>.MultiplyAddEstimate(BigInteger left, BigInteger right, BigInteger addend);
     }
     public readonly struct Complex : IAdditionOperators<Complex, Complex, Complex>, IAdditiveIdentity<Complex, Complex>, IDecrementOperators<Complex>, IDivisionOperators<Complex, Complex, Complex>, IEqualityOperators<Complex, Complex, bool>, IEquatable<Complex>, IFormattable, IIncrementOperators<Complex>, IMultiplicativeIdentity<Complex, Complex>, IMultiplyOperators<Complex, Complex, Complex>, INumberBase<Complex>, IParsable<Complex>, ISignedNumber<Complex>, ISpanFormattable, ISpanParsable<Complex>, ISubtractionOperators<Complex, Complex, Complex>, IUnaryNegationOperators<Complex, Complex>, IUnaryPlusOperators<Complex, Complex>, IUtf8SpanFormattable, IUtf8SpanParsable<Complex> {
+        static Complex System.Numerics.INumberBase<System.Numerics.Complex>.MultiplyAddEstimate(Complex left, Complex right, Complex addend);
     }
     public interface INumberBase<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : INumberBase<TSelf>? {
+        TSelf MultiplyAddEstimate(TSelf left, TSelf right, TSelf addend);
     }
     public static class Vector {
+        public static Vector<Double> FusedMultiplyAdd(Vector<Double> left, Vector<Double> right, Vector<Double> addend);
+        public static Vector<Single> FusedMultiplyAdd(Vector<Single> left, Vector<Single> right, Vector<Single> addend);
+        public static Vector<Double> MultiplyAddEstimate(Vector<Double> left, Vector<Double> right, Vector<Double> addend);
+        public static Vector<Single> MultiplyAddEstimate(Vector<Single> left, Vector<Single> right, Vector<Single> addend);
     }
     public struct Vector2 : IEquatable<Vector2>, IFormattable {
+        public static Vector2 FusedMultiplyAdd(Vector2 left, Vector2 right, Vector2 addend);
+        public static Vector2 MultiplyAddEstimate(Vector2 left, Vector2 right, Vector2 addend);
     }
     public struct Vector3 : IEquatable<Vector3>, IFormattable {
+        public static Vector3 FusedMultiplyAdd(Vector3 left, Vector3 right, Vector3 addend);
+        public static Vector3 MultiplyAddEstimate(Vector3 left, Vector3 right, Vector3 addend);
     }
     public struct Vector4 : IEquatable<Vector4>, IFormattable {
+        public static Vector4 FusedMultiplyAdd(Vector4 left, Vector4 right, Vector4 addend);
+        public static Vector4 MultiplyAddEstimate(Vector4 left, Vector4 right, Vector4 addend);
     }
 }
```

