# System.Reflection.Metadata

``` diff
 namespace System.Reflection.Metadata {
+    public sealed class AssemblyNameInfo {
+        public AssemblyNameInfo(string name, Version? version = null, string? cultureName = null, AssemblyNameFlags flags = AssemblyNameFlags.None, ImmutableArray<byte> publicKeyOrToken = default(ImmutableArray<byte>));
+        public string? CultureName { get; }
+        public AssemblyNameFlags Flags { get; }
+        public string FullName { get; }
+        public string Name { get; }
+        public ImmutableArray<byte> PublicKeyOrToken { get; }
+        public Version? Version { get; }
+        public static AssemblyNameInfo Parse(ReadOnlySpan<char> assemblyName);
+        public AssemblyName ToAssemblyName();
+        public static bool TryParse(ReadOnlySpan<char> assemblyName, out AssemblyNameInfo? result);
+    }
+    public sealed class TypeName {
+        public AssemblyNameInfo? AssemblyName { get; }
+        public string AssemblyQualifiedName { get; }
+        public TypeName? DeclaringType { get; }
+        public string FullName { get; }
+        public bool IsArray { get; }
+        public bool IsByRef { get; }
+        public bool IsConstructedGenericType { get; }
+        public bool IsNested { get; }
+        public bool IsPointer { get; }
+        public bool IsSimple { get; }
+        public bool IsSZArray { get; }
+        public bool IsVariableBoundArrayType { get; }
+        public string Name { get; }
+        public int GetArrayRank();
+        public TypeName GetElementType();
+        public ImmutableArray<TypeName> GetGenericArguments();
+        public TypeName GetGenericTypeDefinition();
+        public int GetNodeCount();
+        public static TypeName Parse(ReadOnlySpan<char> typeName, TypeNameParseOptions? options = null);
+        public static bool TryParse(ReadOnlySpan<char> typeName, out TypeName? result, TypeNameParseOptions? options = null);
+    }
+    public sealed class TypeNameParseOptions {
+        public TypeNameParseOptions();
+        public int MaxNodes { get; set; }
+    }
 }
```

