# System.Runtime.Intrinsics.Arm

``` diff
 namespace System.Runtime.Intrinsics.Arm {
     public abstract class Sve : AdvSimd {
+        public static Vector<double> Abs(Vector<double> value);
+        public static Vector<short> Abs(Vector<short> value);
+        public static Vector<int> Abs(Vector<int> value);
+        public static Vector<long> Abs(Vector<long> value);
+        public static Vector<sbyte> Abs(Vector<sbyte> value);
+        public static Vector<float> Abs(Vector<float> value);
+        public static Vector<byte> AbsoluteDifference(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> AbsoluteDifference(Vector<double> left, Vector<double> right);
+        public static Vector<short> AbsoluteDifference(Vector<short> left, Vector<short> right);
+        public static Vector<int> AbsoluteDifference(Vector<int> left, Vector<int> right);
+        public static Vector<long> AbsoluteDifference(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> AbsoluteDifference(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> AbsoluteDifference(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> AbsoluteDifference(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> AbsoluteDifference(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> AbsoluteDifference(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> Add(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> Add(Vector<double> left, Vector<double> right);
+        public static Vector<short> Add(Vector<short> left, Vector<short> right);
+        public static Vector<int> Add(Vector<int> left, Vector<int> right);
+        public static Vector<long> Add(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> Add(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> Add(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> Add(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> Add(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> Add(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<ulong> AddAcross(Vector<byte> value);
+        public static Vector<double> AddAcross(Vector<double> value);
+        public static Vector<long> AddAcross(Vector<short> value);
+        public static Vector<long> AddAcross(Vector<int> value);
+        public static Vector<long> AddAcross(Vector<long> value);
+        public static Vector<long> AddAcross(Vector<sbyte> value);
+        public static Vector<float> AddAcross(Vector<float> value);
+        public static Vector<ulong> AddAcross(Vector<ushort> value);
+        public static Vector<ulong> AddAcross(Vector<uint> value);
+        public static Vector<ulong> AddAcross(Vector<ulong> value);
+        public static Vector<byte> AddSaturate(Vector<byte> left, Vector<byte> right);
+        public static Vector<short> AddSaturate(Vector<short> left, Vector<short> right);
+        public static Vector<int> AddSaturate(Vector<int> left, Vector<int> right);
+        public static Vector<long> AddSaturate(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> AddSaturate(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<ushort> AddSaturate(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> AddSaturate(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> AddSaturate(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> And(Vector<byte> left, Vector<byte> right);
+        public static Vector<short> And(Vector<short> left, Vector<short> right);
+        public static Vector<int> And(Vector<int> left, Vector<int> right);
+        public static Vector<long> And(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> And(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<ushort> And(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> And(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> And(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> AndAcross(Vector<byte> value);
+        public static Vector<short> AndAcross(Vector<short> value);
+        public static Vector<int> AndAcross(Vector<int> value);
+        public static Vector<long> AndAcross(Vector<long> value);
+        public static Vector<sbyte> AndAcross(Vector<sbyte> value);
+        public static Vector<ushort> AndAcross(Vector<ushort> value);
+        public static Vector<uint> AndAcross(Vector<uint> value);
+        public static Vector<ulong> AndAcross(Vector<ulong> value);
+        public static Vector<byte> BitwiseClear(Vector<byte> left, Vector<byte> right);
+        public static Vector<short> BitwiseClear(Vector<short> left, Vector<short> right);
+        public static Vector<int> BitwiseClear(Vector<int> left, Vector<int> right);
+        public static Vector<long> BitwiseClear(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> BitwiseClear(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<ushort> BitwiseClear(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> BitwiseClear(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> BitwiseClear(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> BooleanNot(Vector<byte> value);
+        public static Vector<short> BooleanNot(Vector<short> value);
+        public static Vector<int> BooleanNot(Vector<int> value);
+        public static Vector<long> BooleanNot(Vector<long> value);
+        public static Vector<sbyte> BooleanNot(Vector<sbyte> value);
+        public static Vector<ushort> BooleanNot(Vector<ushort> value);
+        public static Vector<uint> BooleanNot(Vector<uint> value);
+        public static Vector<ulong> BooleanNot(Vector<ulong> value);
+        public static Vector<byte> ConditionalSelect(Vector<byte> mask, Vector<byte> left, Vector<byte> right);
+        public static Vector<double> ConditionalSelect(Vector<double> mask, Vector<double> left, Vector<double> right);
+        public static Vector<short> ConditionalSelect(Vector<short> mask, Vector<short> left, Vector<short> right);
+        public static Vector<int> ConditionalSelect(Vector<int> mask, Vector<int> left, Vector<int> right);
+        public static Vector<long> ConditionalSelect(Vector<long> mask, Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> ConditionalSelect(Vector<sbyte> mask, Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> ConditionalSelect(Vector<float> mask, Vector<float> left, Vector<float> right);
+        public static Vector<ushort> ConditionalSelect(Vector<ushort> mask, Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> ConditionalSelect(Vector<uint> mask, Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> ConditionalSelect(Vector<ulong> mask, Vector<ulong> left, Vector<ulong> right);
+        public static ulong Count16BitElements(SveMaskPattern pattern = SveMaskPattern.All);
+        public static ulong Count32BitElements(SveMaskPattern pattern = SveMaskPattern.All);
+        public static ulong Count64BitElements(SveMaskPattern pattern = SveMaskPattern.All);
+        public static ulong Count8BitElements(SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<byte> CreateFalseMaskByte();
+        public static Vector<double> CreateFalseMaskDouble();
+        public static Vector<short> CreateFalseMaskInt16();
+        public static Vector<int> CreateFalseMaskInt32();
+        public static Vector<long> CreateFalseMaskInt64();
+        public static Vector<sbyte> CreateFalseMaskSByte();
+        public static Vector<float> CreateFalseMaskSingle();
+        public static Vector<ushort> CreateFalseMaskUInt16();
+        public static Vector<uint> CreateFalseMaskUInt32();
+        public static Vector<ulong> CreateFalseMaskUInt64();
+        public static Vector<ushort> CreateWhileLessThanMask16Bit(int left, int right);
+        public static Vector<ushort> CreateWhileLessThanMask16Bit(long left, long right);
+        public static Vector<ushort> CreateWhileLessThanMask16Bit(uint left, uint right);
+        public static Vector<ushort> CreateWhileLessThanMask16Bit(ulong left, ulong right);
+        public static Vector<uint> CreateWhileLessThanMask32Bit(int left, int right);
+        public static Vector<uint> CreateWhileLessThanMask32Bit(long left, long right);
+        public static Vector<uint> CreateWhileLessThanMask32Bit(uint left, uint right);
+        public static Vector<uint> CreateWhileLessThanMask32Bit(ulong left, ulong right);
+        public static Vector<ulong> CreateWhileLessThanMask64Bit(int left, int right);
+        public static Vector<ulong> CreateWhileLessThanMask64Bit(long left, long right);
+        public static Vector<ulong> CreateWhileLessThanMask64Bit(uint left, uint right);
+        public static Vector<ulong> CreateWhileLessThanMask64Bit(ulong left, ulong right);
+        public static Vector<byte> CreateWhileLessThanMask8Bit(int left, int right);
+        public static Vector<byte> CreateWhileLessThanMask8Bit(long left, long right);
+        public static Vector<byte> CreateWhileLessThanMask8Bit(uint left, uint right);
+        public static Vector<byte> CreateWhileLessThanMask8Bit(ulong left, ulong right);
+        public static Vector<ushort> CreateWhileLessThanOrEqualMask16Bit(int left, int right);
+        public static Vector<ushort> CreateWhileLessThanOrEqualMask16Bit(long left, long right);
+        public static Vector<ushort> CreateWhileLessThanOrEqualMask16Bit(uint left, uint right);
+        public static Vector<ushort> CreateWhileLessThanOrEqualMask16Bit(ulong left, ulong right);
+        public static Vector<uint> CreateWhileLessThanOrEqualMask32Bit(int left, int right);
+        public static Vector<uint> CreateWhileLessThanOrEqualMask32Bit(long left, long right);
+        public static Vector<uint> CreateWhileLessThanOrEqualMask32Bit(uint left, uint right);
+        public static Vector<uint> CreateWhileLessThanOrEqualMask32Bit(ulong left, ulong right);
+        public static Vector<ulong> CreateWhileLessThanOrEqualMask64Bit(int left, int right);
+        public static Vector<ulong> CreateWhileLessThanOrEqualMask64Bit(long left, long right);
+        public static Vector<ulong> CreateWhileLessThanOrEqualMask64Bit(uint left, uint right);
+        public static Vector<ulong> CreateWhileLessThanOrEqualMask64Bit(ulong left, ulong right);
+        public static Vector<byte> CreateWhileLessThanOrEqualMask8Bit(int left, int right);
+        public static Vector<byte> CreateWhileLessThanOrEqualMask8Bit(long left, long right);
+        public static Vector<byte> CreateWhileLessThanOrEqualMask8Bit(uint left, uint right);
+        public static Vector<byte> CreateWhileLessThanOrEqualMask8Bit(ulong left, ulong right);
+        public static Vector<double> Divide(Vector<double> left, Vector<double> right);
+        public static Vector<float> Divide(Vector<float> left, Vector<float> right);
+        public static Vector<int> DotProduct(Vector<int> addend, Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<long> DotProduct(Vector<long> addend, Vector<short> left, Vector<short> right);
+        public static Vector<uint> DotProduct(Vector<uint> addend, Vector<byte> left, Vector<byte> right);
+        public static Vector<ulong> DotProduct(Vector<ulong> addend, Vector<ushort> left, Vector<ushort> right);
+        public static Vector<int> DotProductBySelectedScalar(Vector<int> addend, Vector<sbyte> left, Vector<sbyte> right, byte rightIndex);
+        public static Vector<long> DotProductBySelectedScalar(Vector<long> addend, Vector<short> left, Vector<short> right, byte rightIndex);
+        public static Vector<uint> DotProductBySelectedScalar(Vector<uint> addend, Vector<byte> left, Vector<byte> right, byte rightIndex);
+        public static Vector<ulong> DotProductBySelectedScalar(Vector<ulong> addend, Vector<ushort> left, Vector<ushort> right, byte rightIndex);
+        public static Vector<double> FusedMultiplyAdd(Vector<double> addend, Vector<double> left, Vector<double> right);
+        public static Vector<float> FusedMultiplyAdd(Vector<float> addend, Vector<float> left, Vector<float> right);
+        public static Vector<double> FusedMultiplyAddBySelectedScalar(Vector<double> addend, Vector<double> left, Vector<double> right, byte rightIndex);
+        public static Vector<float> FusedMultiplyAddBySelectedScalar(Vector<float> addend, Vector<float> left, Vector<float> right, byte rightIndex);
+        public static Vector<double> FusedMultiplyAddNegated(Vector<double> addend, Vector<double> left, Vector<double> right);
+        public static Vector<float> FusedMultiplyAddNegated(Vector<float> addend, Vector<float> left, Vector<float> right);
+        public static Vector<double> FusedMultiplySubtract(Vector<double> minuend, Vector<double> left, Vector<double> right);
+        public static Vector<float> FusedMultiplySubtract(Vector<float> minuend, Vector<float> left, Vector<float> right);
+        public static Vector<double> FusedMultiplySubtractBySelectedScalar(Vector<double> minuend, Vector<double> left, Vector<double> right, byte rightIndex);
+        public static Vector<float> FusedMultiplySubtractBySelectedScalar(Vector<float> minuend, Vector<float> left, Vector<float> right, byte rightIndex);
+        public static Vector<double> FusedMultiplySubtractNegated(Vector<double> minuend, Vector<double> left, Vector<double> right);
+        public static Vector<float> FusedMultiplySubtractNegated(Vector<float> minuend, Vector<float> left, Vector<float> right);
+        public unsafe static Vector<short> LoadVectorByteZeroExtendToInt16(Vector<short> mask, byte* address);
+        public unsafe static Vector<int> LoadVectorByteZeroExtendToInt32(Vector<int> mask, byte* address);
+        public unsafe static Vector<long> LoadVectorByteZeroExtendToInt64(Vector<long> mask, byte* address);
+        public unsafe static Vector<ushort> LoadVectorByteZeroExtendToUInt16(Vector<ushort> mask, byte* address);
+        public unsafe static Vector<uint> LoadVectorByteZeroExtendToUInt32(Vector<uint> mask, byte* address);
+        public unsafe static Vector<ulong> LoadVectorByteZeroExtendToUInt64(Vector<ulong> mask, byte* address);
+        public unsafe static Vector<int> LoadVectorInt16SignExtendToInt32(Vector<int> mask, short* address);
+        public unsafe static Vector<long> LoadVectorInt16SignExtendToInt64(Vector<long> mask, short* address);
+        public unsafe static Vector<uint> LoadVectorInt16SignExtendToUInt32(Vector<uint> mask, short* address);
+        public unsafe static Vector<ulong> LoadVectorInt16SignExtendToUInt64(Vector<ulong> mask, short* address);
+        public unsafe static Vector<long> LoadVectorInt32SignExtendToInt64(Vector<long> mask, int* address);
+        public unsafe static Vector<ulong> LoadVectorInt32SignExtendToUInt64(Vector<ulong> mask, int* address);
+        public unsafe static Vector<short> LoadVectorSByteSignExtendToInt16(Vector<short> mask, sbyte* address);
+        public unsafe static Vector<int> LoadVectorSByteSignExtendToInt32(Vector<int> mask, sbyte* address);
+        public unsafe static Vector<long> LoadVectorSByteSignExtendToInt64(Vector<long> mask, sbyte* address);
+        public unsafe static Vector<ushort> LoadVectorSByteSignExtendToUInt16(Vector<ushort> mask, sbyte* address);
+        public unsafe static Vector<uint> LoadVectorSByteSignExtendToUInt32(Vector<uint> mask, sbyte* address);
+        public unsafe static Vector<ulong> LoadVectorSByteSignExtendToUInt64(Vector<ulong> mask, sbyte* address);
+        public unsafe static Vector<int> LoadVectorUInt16ZeroExtendToInt32(Vector<int> mask, ushort* address);
+        public unsafe static Vector<long> LoadVectorUInt16ZeroExtendToInt64(Vector<long> mask, ushort* address);
+        public unsafe static Vector<uint> LoadVectorUInt16ZeroExtendToUInt32(Vector<uint> mask, ushort* address);
+        public unsafe static Vector<ulong> LoadVectorUInt16ZeroExtendToUInt64(Vector<ulong> mask, ushort* address);
+        public unsafe static Vector<long> LoadVectorUInt32ZeroExtendToInt64(Vector<long> mask, uint* address);
+        public unsafe static Vector<ulong> LoadVectorUInt32ZeroExtendToUInt64(Vector<ulong> mask, uint* address);
+        public static Vector<byte> Max(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> Max(Vector<double> left, Vector<double> right);
+        public static Vector<short> Max(Vector<short> left, Vector<short> right);
+        public static Vector<int> Max(Vector<int> left, Vector<int> right);
+        public static Vector<long> Max(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> Max(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> Max(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> Max(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> Max(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> Max(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> MaxAcross(Vector<byte> value);
+        public static Vector<double> MaxAcross(Vector<double> value);
+        public static Vector<short> MaxAcross(Vector<short> value);
+        public static Vector<int> MaxAcross(Vector<int> value);
+        public static Vector<long> MaxAcross(Vector<long> value);
+        public static Vector<sbyte> MaxAcross(Vector<sbyte> value);
+        public static Vector<float> MaxAcross(Vector<float> value);
+        public static Vector<ushort> MaxAcross(Vector<ushort> value);
+        public static Vector<uint> MaxAcross(Vector<uint> value);
+        public static Vector<ulong> MaxAcross(Vector<ulong> value);
+        public static Vector<double> MaxNumber(Vector<double> left, Vector<double> right);
+        public static Vector<float> MaxNumber(Vector<float> left, Vector<float> right);
+        public static Vector<double> MaxNumberAcross(Vector<double> value);
+        public static Vector<float> MaxNumberAcross(Vector<float> value);
+        public static Vector<byte> Min(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> Min(Vector<double> left, Vector<double> right);
+        public static Vector<short> Min(Vector<short> left, Vector<short> right);
+        public static Vector<int> Min(Vector<int> left, Vector<int> right);
+        public static Vector<long> Min(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> Min(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> Min(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> Min(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> Min(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> Min(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> MinAcross(Vector<byte> value);
+        public static Vector<double> MinAcross(Vector<double> value);
+        public static Vector<short> MinAcross(Vector<short> value);
+        public static Vector<int> MinAcross(Vector<int> value);
+        public static Vector<long> MinAcross(Vector<long> value);
+        public static Vector<sbyte> MinAcross(Vector<sbyte> value);
+        public static Vector<float> MinAcross(Vector<float> value);
+        public static Vector<ushort> MinAcross(Vector<ushort> value);
+        public static Vector<uint> MinAcross(Vector<uint> value);
+        public static Vector<ulong> MinAcross(Vector<ulong> value);
+        public static Vector<double> MinNumber(Vector<double> left, Vector<double> right);
+        public static Vector<float> MinNumber(Vector<float> left, Vector<float> right);
+        public static Vector<double> MinNumberAcross(Vector<double> value);
+        public static Vector<float> MinNumberAcross(Vector<float> value);
+        public static Vector<byte> Multiply(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> Multiply(Vector<double> left, Vector<double> right);
+        public static Vector<short> Multiply(Vector<short> left, Vector<short> right);
+        public static Vector<int> Multiply(Vector<int> left, Vector<int> right);
+        public static Vector<long> Multiply(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> Multiply(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> Multiply(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> Multiply(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> Multiply(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> Multiply(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> MultiplyAdd(Vector<byte> addend, Vector<byte> left, Vector<byte> right);
+        public static Vector<short> MultiplyAdd(Vector<short> addend, Vector<short> left, Vector<short> right);
+        public static Vector<int> MultiplyAdd(Vector<int> addend, Vector<int> left, Vector<int> right);
+        public static Vector<long> MultiplyAdd(Vector<long> addend, Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> MultiplyAdd(Vector<sbyte> addend, Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<ushort> MultiplyAdd(Vector<ushort> addend, Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> MultiplyAdd(Vector<uint> addend, Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> MultiplyAdd(Vector<ulong> addend, Vector<ulong> left, Vector<ulong> right);
+        public static Vector<double> MultiplyBySelectedScalar(Vector<double> left, Vector<double> right, byte rightIndex);
+        public static Vector<float> MultiplyBySelectedScalar(Vector<float> left, Vector<float> right, byte rightIndex);
+        public static Vector<double> MultiplyExtended(Vector<double> left, Vector<double> right);
+        public static Vector<float> MultiplyExtended(Vector<float> left, Vector<float> right);
+        public static Vector<byte> MultiplySubtract(Vector<byte> minuend, Vector<byte> left, Vector<byte> right);
+        public static Vector<short> MultiplySubtract(Vector<short> minuend, Vector<short> left, Vector<short> right);
+        public static Vector<int> MultiplySubtract(Vector<int> minuend, Vector<int> left, Vector<int> right);
+        public static Vector<long> MultiplySubtract(Vector<long> minuend, Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> MultiplySubtract(Vector<sbyte> minuend, Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<ushort> MultiplySubtract(Vector<ushort> minuend, Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> MultiplySubtract(Vector<uint> minuend, Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> MultiplySubtract(Vector<ulong> minuend, Vector<ulong> left, Vector<ulong> right);
+        public static Vector<double> Negate(Vector<double> value);
+        public static Vector<short> Negate(Vector<short> value);
+        public static Vector<int> Negate(Vector<int> value);
+        public static Vector<long> Negate(Vector<long> value);
+        public static Vector<sbyte> Negate(Vector<sbyte> value);
+        public static Vector<float> Negate(Vector<float> value);
+        public static Vector<byte> Or(Vector<byte> left, Vector<byte> right);
+        public static Vector<short> Or(Vector<short> left, Vector<short> right);
+        public static Vector<int> Or(Vector<int> left, Vector<int> right);
+        public static Vector<long> Or(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> Or(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<ushort> Or(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> Or(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> Or(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> OrAcross(Vector<byte> value);
+        public static Vector<short> OrAcross(Vector<short> value);
+        public static Vector<int> OrAcross(Vector<int> value);
+        public static Vector<long> OrAcross(Vector<long> value);
+        public static Vector<sbyte> OrAcross(Vector<sbyte> value);
+        public static Vector<ushort> OrAcross(Vector<ushort> value);
+        public static Vector<uint> OrAcross(Vector<uint> value);
+        public static Vector<ulong> OrAcross(Vector<ulong> value);
+        public static Vector<int> SignExtend16(Vector<int> value);
+        public static Vector<long> SignExtend16(Vector<long> value);
+        public static Vector<long> SignExtend32(Vector<long> value);
+        public static Vector<short> SignExtend8(Vector<short> value);
+        public static Vector<int> SignExtend8(Vector<int> value);
+        public static Vector<long> SignExtend8(Vector<long> value);
+        public static Vector<int> SignExtendWideningLower(Vector<short> value);
+        public static Vector<long> SignExtendWideningLower(Vector<int> value);
+        public static Vector<short> SignExtendWideningLower(Vector<sbyte> value);
+        public static Vector<int> SignExtendWideningUpper(Vector<short> value);
+        public static Vector<long> SignExtendWideningUpper(Vector<int> value);
+        public static Vector<short> SignExtendWideningUpper(Vector<sbyte> value);
+        public unsafe static void StoreAndZip(Vector<byte> mask, byte* address, Vector<byte> data);
+        public unsafe static void StoreAndZip(Vector<byte> mask, byte* address, (Vector<byte> Value1, Vector<byte> Value2, Vector<byte> Value3, Vector<byte> Value4) data);
+        public unsafe static void StoreAndZip(Vector<byte> mask, byte* address, (Vector<byte> Value1, Vector<byte> Value2, Vector<byte> Value3) data);
+        public unsafe static void StoreAndZip(Vector<byte> mask, byte* address, (Vector<byte> Value1, Vector<byte> Value2) data);
+        public unsafe static void StoreAndZip(Vector<double> mask, double* address, Vector<double> data);
+        public unsafe static void StoreAndZip(Vector<double> mask, double* address, (Vector<double> Value1, Vector<double> Value2, Vector<double> Value3, Vector<double> Value4) data);
+        public unsafe static void StoreAndZip(Vector<double> mask, double* address, (Vector<double> Value1, Vector<double> Value2, Vector<double> Value3) data);
+        public unsafe static void StoreAndZip(Vector<double> mask, double* address, (Vector<double> Value1, Vector<double> Value2) data);
+        public unsafe static void StoreAndZip(Vector<short> mask, short* address, Vector<short> data);
+        public unsafe static void StoreAndZip(Vector<short> mask, short* address, (Vector<short> Value1, Vector<short> Value2, Vector<short> Value3, Vector<short> Value4) data);
+        public unsafe static void StoreAndZip(Vector<short> mask, short* address, (Vector<short> Value1, Vector<short> Value2, Vector<short> Value3) data);
+        public unsafe static void StoreAndZip(Vector<short> mask, short* address, (Vector<short> Value1, Vector<short> Value2) data);
+        public unsafe static void StoreAndZip(Vector<int> mask, int* address, Vector<int> data);
+        public unsafe static void StoreAndZip(Vector<int> mask, int* address, (Vector<int> Value1, Vector<int> Value2, Vector<int> Value3, Vector<int> Value4) data);
+        public unsafe static void StoreAndZip(Vector<int> mask, int* address, (Vector<int> Value1, Vector<int> Value2, Vector<int> Value3) data);
+        public unsafe static void StoreAndZip(Vector<int> mask, int* address, (Vector<int> Value1, Vector<int> Value2) data);
+        public unsafe static void StoreAndZip(Vector<long> mask, long* address, Vector<long> data);
+        public unsafe static void StoreAndZip(Vector<long> mask, long* address, (Vector<long> Value1, Vector<long> Value2, Vector<long> Value3, Vector<long> Value4) data);
+        public unsafe static void StoreAndZip(Vector<long> mask, long* address, (Vector<long> Value1, Vector<long> Value2, Vector<long> Value3) data);
+        public unsafe static void StoreAndZip(Vector<long> mask, long* address, (Vector<long> Value1, Vector<long> Value2) data);
+        public unsafe static void StoreAndZip(Vector<sbyte> mask, sbyte* address, Vector<sbyte> data);
+        public unsafe static void StoreAndZip(Vector<sbyte> mask, sbyte* address, (Vector<sbyte> Value1, Vector<sbyte> Value2, Vector<sbyte> Value3, Vector<sbyte> Value4) data);
+        public unsafe static void StoreAndZip(Vector<sbyte> mask, sbyte* address, (Vector<sbyte> Value1, Vector<sbyte> Value2, Vector<sbyte> Value3) data);
+        public unsafe static void StoreAndZip(Vector<sbyte> mask, sbyte* address, (Vector<sbyte> Value1, Vector<sbyte> Value2) data);
+        public unsafe static void StoreAndZip(Vector<float> mask, float* address, Vector<float> data);
+        public unsafe static void StoreAndZip(Vector<float> mask, float* address, (Vector<float> Value1, Vector<float> Value2, Vector<float> Value3, Vector<float> Value4) data);
+        public unsafe static void StoreAndZip(Vector<float> mask, float* address, (Vector<float> Value1, Vector<float> Value2, Vector<float> Value3) data);
+        public unsafe static void StoreAndZip(Vector<float> mask, float* address, (Vector<float> Value1, Vector<float> Value2) data);
+        public unsafe static void StoreAndZip(Vector<ushort> mask, ushort* address, Vector<ushort> data);
+        public unsafe static void StoreAndZip(Vector<ushort> mask, ushort* address, (Vector<ushort> Value1, Vector<ushort> Value2, Vector<ushort> Value3, Vector<ushort> Value4) data);
+        public unsafe static void StoreAndZip(Vector<ushort> mask, ushort* address, (Vector<ushort> Value1, Vector<ushort> Value2, Vector<ushort> Value3) data);
+        public unsafe static void StoreAndZip(Vector<ushort> mask, ushort* address, (Vector<ushort> Value1, Vector<ushort> Value2) data);
+        public unsafe static void StoreAndZip(Vector<uint> mask, uint* address, Vector<uint> data);
+        public unsafe static void StoreAndZip(Vector<uint> mask, uint* address, (Vector<uint> Value1, Vector<uint> Value2, Vector<uint> Value3, Vector<uint> Value4) data);
+        public unsafe static void StoreAndZip(Vector<uint> mask, uint* address, (Vector<uint> Value1, Vector<uint> Value2, Vector<uint> Value3) data);
+        public unsafe static void StoreAndZip(Vector<uint> mask, uint* address, (Vector<uint> Value1, Vector<uint> Value2) data);
+        public unsafe static void StoreAndZip(Vector<ulong> mask, ulong* address, Vector<ulong> data);
+        public unsafe static void StoreAndZip(Vector<ulong> mask, ulong* address, (Vector<ulong> Value1, Vector<ulong> Value2, Vector<ulong> Value3, Vector<ulong> Value4) data);
+        public unsafe static void StoreAndZip(Vector<ulong> mask, ulong* address, (Vector<ulong> Value1, Vector<ulong> Value2, Vector<ulong> Value3) data);
+        public unsafe static void StoreAndZip(Vector<ulong> mask, ulong* address, (Vector<ulong> Value1, Vector<ulong> Value2) data);
+        public static Vector<byte> Subtract(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> Subtract(Vector<double> left, Vector<double> right);
+        public static Vector<short> Subtract(Vector<short> left, Vector<short> right);
+        public static Vector<int> Subtract(Vector<int> left, Vector<int> right);
+        public static Vector<long> Subtract(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> Subtract(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> Subtract(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> Subtract(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> Subtract(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> Subtract(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> SubtractSaturate(Vector<byte> left, Vector<byte> right);
+        public static Vector<short> SubtractSaturate(Vector<short> left, Vector<short> right);
+        public static Vector<int> SubtractSaturate(Vector<int> left, Vector<int> right);
+        public static Vector<long> SubtractSaturate(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> SubtractSaturate(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<ushort> SubtractSaturate(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> SubtractSaturate(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> SubtractSaturate(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> UnzipEven(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> UnzipEven(Vector<double> left, Vector<double> right);
+        public static Vector<short> UnzipEven(Vector<short> left, Vector<short> right);
+        public static Vector<int> UnzipEven(Vector<int> left, Vector<int> right);
+        public static Vector<long> UnzipEven(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> UnzipEven(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> UnzipEven(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> UnzipEven(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> UnzipEven(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> UnzipEven(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> UnzipOdd(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> UnzipOdd(Vector<double> left, Vector<double> right);
+        public static Vector<short> UnzipOdd(Vector<short> left, Vector<short> right);
+        public static Vector<int> UnzipOdd(Vector<int> left, Vector<int> right);
+        public static Vector<long> UnzipOdd(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> UnzipOdd(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> UnzipOdd(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> UnzipOdd(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> UnzipOdd(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> UnzipOdd(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> Xor(Vector<byte> left, Vector<byte> right);
+        public static Vector<short> Xor(Vector<short> left, Vector<short> right);
+        public static Vector<int> Xor(Vector<int> left, Vector<int> right);
+        public static Vector<long> Xor(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> Xor(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<ushort> Xor(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> Xor(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> Xor(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> XorAcross(Vector<byte> value);
+        public static Vector<short> XorAcross(Vector<short> value);
+        public static Vector<int> XorAcross(Vector<int> value);
+        public static Vector<long> XorAcross(Vector<long> value);
+        public static Vector<sbyte> XorAcross(Vector<sbyte> value);
+        public static Vector<ushort> XorAcross(Vector<ushort> value);
+        public static Vector<uint> XorAcross(Vector<uint> value);
+        public static Vector<ulong> XorAcross(Vector<ulong> value);
+        public static Vector<uint> ZeroExtend16(Vector<uint> value);
+        public static Vector<ulong> ZeroExtend16(Vector<ulong> value);
+        public static Vector<ulong> ZeroExtend32(Vector<ulong> value);
+        public static Vector<ushort> ZeroExtend8(Vector<ushort> value);
+        public static Vector<uint> ZeroExtend8(Vector<uint> value);
+        public static Vector<ulong> ZeroExtend8(Vector<ulong> value);
+        public static Vector<ushort> ZeroExtendWideningLower(Vector<byte> value);
+        public static Vector<uint> ZeroExtendWideningLower(Vector<ushort> value);
+        public static Vector<ulong> ZeroExtendWideningLower(Vector<uint> value);
+        public static Vector<ushort> ZeroExtendWideningUpper(Vector<byte> value);
+        public static Vector<uint> ZeroExtendWideningUpper(Vector<ushort> value);
+        public static Vector<ulong> ZeroExtendWideningUpper(Vector<uint> value);
+        public static Vector<byte> ZipHigh(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> ZipHigh(Vector<double> left, Vector<double> right);
+        public static Vector<short> ZipHigh(Vector<short> left, Vector<short> right);
+        public static Vector<int> ZipHigh(Vector<int> left, Vector<int> right);
+        public static Vector<long> ZipHigh(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> ZipHigh(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> ZipHigh(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> ZipHigh(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> ZipHigh(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> ZipHigh(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> ZipLow(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> ZipLow(Vector<double> left, Vector<double> right);
+        public static Vector<short> ZipLow(Vector<short> left, Vector<short> right);
+        public static Vector<int> ZipLow(Vector<int> left, Vector<int> right);
+        public static Vector<long> ZipLow(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> ZipLow(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> ZipLow(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> ZipLow(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> ZipLow(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> ZipLow(Vector<ulong> left, Vector<ulong> right);
     }
 }
```

