# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
     public abstract class ComponentBase : IComponent, IHandleAfterRender, IHandleEvent {
+        protected ResourceAssetCollection Assets { get; }
-        protected ComponentPlatform Platform { get; }

+        protected RendererInfo RendererInfo { get; }
     }
-    public sealed class ComponentPlatform {
 {
-        public ComponentPlatform(string platformName, bool isInteractive);

-        public bool IsInteractive { get; }

-        public string Name { get; }

-    }
+    public sealed class ImportMap : IComponent {
+        public ImportMap();
+        public HttpContext HttpContext { get; set; }
+        public ImportMapDefinition ImportMapDefinition { get; set; }
+        void IComponent.Attach(RenderHandle renderHandle);
+        Task IComponent.SetParametersAsync(ParameterView parameters);
+    }
+    public sealed class ImportMapDefinition {
+        public ImportMapDefinition(IReadOnlyDictionary<string, string>? imports, IReadOnlyDictionary<string, IReadOnlyDictionary<string, string>>? scopes, IReadOnlyDictionary<string, string>? integrity);
+        public IReadOnlyDictionary<string, string>? Imports { get; }
+        public IReadOnlyDictionary<string, string>? Integrity { get; }
+        public IReadOnlyDictionary<string, IReadOnlyDictionary<string, string>>? Scopes { get; }
+        public static ImportMapDefinition Combine(params ImportMapDefinition[] sources);
+        public static ImportMapDefinition FromResourceCollection(ResourceAssetCollection assets);
+        public override string ToString();
+    }
+    public sealed class RendererInfo {
+        public RendererInfo(string rendererName, bool isInteractive);
+        public bool IsInteractive { get; }
+        public string Name { get; }
+    }
     public readonly struct RenderHandle {
+        public ResourceAssetCollection Assets { get; }
-        public ComponentPlatform Platform { get; }

+        public RendererInfo RendererInfo { get; }
     }
+    public sealed class ResourceAsset {
+        public ResourceAsset(string url, IReadOnlyList<ResourceAssetProperty>? properties);
+        public IReadOnlyList<ResourceAssetProperty>? Properties { get; }
+        public string Url { get; }
+    }
+    public sealed class ResourceAssetCollection : IEnumerable, IEnumerable<ResourceAsset>, IReadOnlyCollection<ResourceAsset>, IReadOnlyList<ResourceAsset> {
+        public static readonly ResourceAssetCollection Empty;
+        public ResourceAssetCollection(IReadOnlyList<ResourceAsset> resources);
+        int IReadOnlyCollection<ResourceAsset>.Count { get; }
+        ResourceAsset IReadOnlyList<ResourceAsset>.this[int index] { get; }
+        public string this[string key] { get; }
+        public bool IsContentSpecificUrl(string path);
+        IEnumerator<ResourceAsset> IEnumerable<ResourceAsset>.GetEnumerator();
+        IEnumerator IEnumerable.GetEnumerator();
+    }
+    public sealed class ResourceAssetProperty {
+        public ResourceAssetProperty(string name, string value);
+        public string Name { get; }
+        public string Value { get; }
+    }
 }
```

