# System.Buffers.Text

``` diff
 namespace System.Buffers.Text {
+    public static class Base64Url {
+        public static byte[] DecodeFromChars(ReadOnlySpan<char> source);
+        public static int DecodeFromChars(ReadOnlySpan<char> source, Span<byte> destination);
+        public static OperationStatus DecodeFromChars(ReadOnlySpan<char> source, Span<byte> destination, out int charsConsumed, out int bytesWritten, bool isFinalBlock = true);
+        public static byte[] DecodeFromUtf8(ReadOnlySpan<byte> source);
+        public static int DecodeFromUtf8(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static OperationStatus DecodeFromUtf8(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesConsumed, out int bytesWritten, bool isFinalBlock = true);
+        public static int DecodeFromUtf8InPlace(Span<byte> buffer);
+        public static char[] EncodeToChars(ReadOnlySpan<byte> source);
+        public static int EncodeToChars(ReadOnlySpan<byte> source, Span<char> destination);
+        public static OperationStatus EncodeToChars(ReadOnlySpan<byte> source, Span<char> destination, out int bytesConsumed, out int charsWritten, bool isFinalBlock = true);
+        public static string EncodeToString(ReadOnlySpan<byte> source);
+        public static byte[] EncodeToUtf8(ReadOnlySpan<byte> source);
+        public static int EncodeToUtf8(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static OperationStatus EncodeToUtf8(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesConsumed, out int bytesWritten, bool isFinalBlock = true);
+        public static int GetEncodedLength(int bytesLength);
+        public static int GetMaxDecodedLength(int base64Length);
+        public static bool IsValid(ReadOnlySpan<byte> utf8Base64UrlText);
+        public static bool IsValid(ReadOnlySpan<byte> utf8Base64UrlText, out int decodedLength);
+        public static bool IsValid(ReadOnlySpan<char> base64UrlText);
+        public static bool IsValid(ReadOnlySpan<char> base64UrlText, out int decodedLength);
+        public static bool TryDecodeFromChars(ReadOnlySpan<char> source, Span<byte> destination, out int bytesWritten);
+        public static bool TryDecodeFromUtf8(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        public static bool TryEncodeToChars(ReadOnlySpan<byte> source, Span<char> destination, out int charsWritten);
+        public static bool TryEncodeToUtf8(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        public static bool TryEncodeToUtf8InPlace(Span<byte> buffer, int dataLength, out int bytesWritten);
+    }
 }
```

