# System.Collections.Generic

``` diff
 namespace System.Collections.Generic {
     public static class CollectionExtensions {
+        public static HashSet.AlternateLookup<TAlternate> GetAlternateLookup<T, TAlternate>(this HashSet<T> @set);
+        public static Dictionary.AlternateLookup<TAlternateKey> GetAlternateLookup<TKey, TValue, TAlternateKey>(this Dictionary<TKey, TValue> dictionary);
+        public static bool TryGetAlternateLookup<T, TAlternate>(this HashSet<T> @set, out HashSet.AlternateLookup<TAlternate> lookup);
+        public static bool TryGetAlternateLookup<TKey, TValue, TAlternateKey>(this Dictionary<TKey, TValue> dictionary, out Dictionary.AlternateLookup<TAlternateKey> lookup);
     }
     public class Dictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDeserializationCallback, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue>, ISerializable {
+        public readonly struct AlternateLookup<TAlternateKey> {
+            public Dictionary<TKey, TValue> Dictionary { get; }
+            public TValue this[TAlternateKey key] { get; set; }
+            public bool ContainsKey(TAlternateKey key);
+            public bool Remove(TAlternateKey key);
+            public bool Remove(TAlternateKey key, out TKey actualKey, out TValue value);
+            public bool TryAdd(TAlternateKey key, TValue value);
+            public bool TryGetValue(TAlternateKey key, out TKey actualKey, out TValue value);
+            public bool TryGetValue(TAlternateKey key, out TValue value);
+        }
     }
     public class HashSet<T> : ICollection<T>, IDeserializationCallback, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, IReadOnlySet<T>, ISerializable, ISet<T> {
+        public readonly struct AlternateLookup<TAlternate> {
+            public HashSet<T> Set { get; }
+            public bool Add(TAlternate item);
+            public bool Contains(TAlternate item);
+            public bool Remove(TAlternate item);
+            public bool TryGetValue(TAlternate equalValue, out T actualValue);
+        }
     }
+    public interface IAlternateEqualityComparer<in TAlternate, T> {
+        T Create(TAlternate alternate);
+        bool Equals(TAlternate alternate, T other);
+        int GetHashCode(TAlternate alternate);
+    }
+    public class OrderedDictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IList, IList<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue>, IReadOnlyList<KeyValuePair<TKey, TValue>> {
+        public OrderedDictionary();
+        public OrderedDictionary(IDictionary<TKey, TValue> dictionary);
+        public OrderedDictionary(IDictionary<TKey, TValue> dictionary, IEqualityComparer<TKey>? comparer);
+        public OrderedDictionary(IEnumerable<KeyValuePair<TKey, TValue>> collection);
+        public OrderedDictionary(IEnumerable<KeyValuePair<TKey, TValue>> collection, IEqualityComparer<TKey>? comparer);
+        public OrderedDictionary(IEqualityComparer<TKey>? comparer);
+        public OrderedDictionary(int capacity);
+        public OrderedDictionary(int capacity, IEqualityComparer<TKey>? comparer);
+        public int Capacity { get; }
+        public IEqualityComparer<TKey> Comparer { get; }
+        public int Count { get; }
+        public OrderedDictionary<TKey, TValue>.KeyCollection Keys { get; }
+        bool ICollection<KeyValuePair<TKey, TValue>>.IsReadOnly { get; }
+        ICollection<TKey> IDictionary<TKey, TValue>.Keys { get; }
+        ICollection<TValue> IDictionary<TKey, TValue>.Values { get; }
+        KeyValuePair<TKey, TValue> IList<KeyValuePair<TKey, TValue>>.this[int index] { get; set; }
+        IEnumerable<TKey> IReadOnlyDictionary<TKey, TValue>.Keys { get; }
+        IEnumerable<TValue> IReadOnlyDictionary<TKey, TValue>.Values { get; }
+        KeyValuePair<TKey, TValue> IReadOnlyList<KeyValuePair<TKey, TValue>>.this[int index] { get; }
+        bool ICollection.IsSynchronized { get; }
+        object ICollection.SyncRoot { get; }
+        bool IDictionary.IsFixedSize { get; }
+        bool IDictionary.IsReadOnly { get; }
+        object? IDictionary.this[object key] { get; set; }
+        ICollection IDictionary.Keys { get; }
+        ICollection IDictionary.Values { get; }
+        bool IList.IsFixedSize { get; }
+        bool IList.IsReadOnly { get; }
+        object? IList.this[int index] { get; set; }
+        public TValue this[TKey key] { get; set; }
+        public OrderedDictionary<TKey, TValue>.ValueCollection Values { get; }
+        public void Add(TKey key, TValue value);
+        public void Clear();
+        public bool ContainsKey(TKey key);
+        public bool ContainsValue(TValue value);
+        public int EnsureCapacity(int capacity);
+        public KeyValuePair<TKey, TValue> GetAt(int index);
+        public OrderedDictionary<TKey, TValue>.Enumerator GetEnumerator();
+        public int IndexOf(TKey key);
+        public void Insert(int index, TKey key, TValue value);
+        public bool Remove(TKey key);
+        public bool Remove(TKey key, out TValue value);
+        public void RemoveAt(int index);
+        public void SetAt(int index, TKey key, TValue value);
+        public void SetAt(int index, TValue value);
+        void ICollection<KeyValuePair<TKey, TValue>>.Add(KeyValuePair<TKey, TValue> item);
+        bool ICollection<KeyValuePair<TKey, TValue>>.Contains(KeyValuePair<TKey, TValue> item);
+        void ICollection<KeyValuePair<TKey, TValue>>.CopyTo(KeyValuePair<TKey, TValue>[] array, int arrayIndex);
+        bool ICollection<KeyValuePair<TKey, TValue>>.Remove(KeyValuePair<TKey, TValue> item);
+        IEnumerator<KeyValuePair<TKey, TValue>> IEnumerable<KeyValuePair<TKey, TValue>>.GetEnumerator();
+        int IList<KeyValuePair<TKey, TValue>>.IndexOf(KeyValuePair<TKey, TValue> item);
+        void IList<KeyValuePair<TKey, TValue>>.Insert(int index, KeyValuePair<TKey, TValue> item);
+        void ICollection.CopyTo(Array array, int index);
+        void IDictionary.Add(object key, object value);
+        bool IDictionary.Contains(object key);
+        IDictionaryEnumerator IDictionary.GetEnumerator();
+        void IDictionary.Remove(object key);
+        IEnumerator IEnumerable.GetEnumerator();
+        int IList.Add(object value);
+        bool IList.Contains(object value);
+        int IList.IndexOf(object value);
+        void IList.Insert(int index, object value);
+        void IList.Remove(object value);
+        public void TrimExcess();
+        public void TrimExcess(int capacity);
+        public bool TryAdd(TKey key, TValue value);
+        public bool TryGetValue(TKey key, out TValue value);
+        public struct Enumerator : IDictionaryEnumerator, IDisposable, IEnumerator, IEnumerator<KeyValuePair<TKey, TValue>> {
+            public KeyValuePair<TKey, TValue> Current { get; }
+            DictionaryEntry System.Collections.IDictionaryEnumerator.Entry { get; }
+            object System.Collections.IDictionaryEnumerator.Key { get; }
+            object? System.Collections.IDictionaryEnumerator.Value { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+        public sealed class KeyCollection : ICollection, ICollection<TKey>, IEnumerable, IEnumerable<TKey>, IList, IList<TKey>, IReadOnlyCollection<TKey>, IReadOnlyList<TKey> {
+            public int Count { get; }
+            bool ICollection<TKey>.IsReadOnly { get; }
+            TKey IList<TKey>.this[int index] { get; set; }
+            TKey IReadOnlyList<TKey>.this[int index] { get; }
+            bool System.Collections.ICollection.IsSynchronized { get; }
+            object System.Collections.ICollection.SyncRoot { get; }
+            bool System.Collections.IList.IsFixedSize { get; }
+            bool System.Collections.IList.IsReadOnly { get; }
+            object? System.Collections.IList.this[int index] { get; set; }
+            public bool Contains(TKey key);
+            public void CopyTo(TKey[] array, int arrayIndex);
+            public OrderedDictionary<TKey, TValue>.KeyCollection.Enumerator GetEnumerator();
+            void ICollection<TKey>.Add(TKey item);
+            void ICollection<TKey>.Clear();
+            bool ICollection<TKey>.Remove(TKey item);
+            IEnumerator<TKey> IEnumerable<TKey>.GetEnumerator();
+            int IList<TKey>.IndexOf(TKey item);
+            void IList<TKey>.Insert(int index, TKey item);
+            void IList<TKey>.RemoveAt(int index);
+            void System.Collections.ICollection.CopyTo(Array array, int index);
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            int System.Collections.IList.Add(object value);
+            void System.Collections.IList.Clear();
+            bool System.Collections.IList.Contains(object value);
+            int System.Collections.IList.IndexOf(object value);
+            void System.Collections.IList.Insert(int index, object value);
+            void System.Collections.IList.Remove(object value);
+            void System.Collections.IList.RemoveAt(int index);
+            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<TKey> {
+                public TKey Current { get; }
+                object System.Collections.IEnumerator.Current { get; }
+                public bool MoveNext();
+                void System.Collections.IEnumerator.Reset();
+                void System.IDisposable.Dispose();
+            }
+        }
+        public sealed class ValueCollection : ICollection, ICollection<TValue>, IEnumerable, IEnumerable<TValue>, IList, IList<TValue>, IReadOnlyCollection<TValue>, IReadOnlyList<TValue> {
+            public int Count { get; }
+            bool ICollection<TValue>.IsReadOnly { get; }
+            TValue IList<TValue>.this[int index] { get; set; }
+            TValue IReadOnlyList<TValue>.this[int index] { get; }
+            bool System.Collections.ICollection.IsSynchronized { get; }
+            object System.Collections.ICollection.SyncRoot { get; }
+            bool System.Collections.IList.IsFixedSize { get; }
+            bool System.Collections.IList.IsReadOnly { get; }
+            object? System.Collections.IList.this[int index] { get; set; }
+            public void CopyTo(TValue[] array, int arrayIndex);
+            public OrderedDictionary<TKey, TValue>.ValueCollection.Enumerator GetEnumerator();
+            void ICollection<TValue>.Add(TValue item);
+            void ICollection<TValue>.Clear();
+            bool ICollection<TValue>.Contains(TValue item);
+            bool ICollection<TValue>.Remove(TValue item);
+            IEnumerator<TValue> IEnumerable<TValue>.GetEnumerator();
+            int IList<TValue>.IndexOf(TValue item);
+            void IList<TValue>.Insert(int index, TValue item);
+            void IList<TValue>.RemoveAt(int index);
+            void System.Collections.ICollection.CopyTo(Array array, int index);
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            int System.Collections.IList.Add(object value);
+            void System.Collections.IList.Clear();
+            bool System.Collections.IList.Contains(object value);
+            int System.Collections.IList.IndexOf(object value);
+            void System.Collections.IList.Insert(int index, object value);
+            void System.Collections.IList.Remove(object value);
+            void System.Collections.IList.RemoveAt(int index);
+            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<TValue> {
+                public TValue Current { get; }
+                object? System.Collections.IEnumerator.Current { get; }
+                public bool MoveNext();
+                void System.Collections.IEnumerator.Reset();
+                void System.IDisposable.Dispose();
+            }
+        }
+    }
 }
```

