# System.Diagnostics.Metrics

``` diff
 namespace System.Diagnostics.Metrics {
+    public sealed class Gauge<T> : Instrument<T> where T : struct {
+        public void Record(T value);
+        public void Record(T value, KeyValuePair<string, object?> tag);
+        public void Record(T value, KeyValuePair<string, object?> tag1, KeyValuePair<string, object?> tag2);
+        public void Record(T value, KeyValuePair<string, object?> tag1, KeyValuePair<string, object?> tag2, KeyValuePair<string, object?> tag3);
+        public void Record(T value, params KeyValuePair<string, object>[] tags);
+        public void Record(T value, in TagList tagList);
+        public void Record(T value, ReadOnlySpan<KeyValuePair<string, object?>> tags);
+    }
     public abstract class Instrument {
+        protected Instrument(Meter meter, string name);
-        protected Instrument(Meter meter, string name, string? unit, string? description, IEnumerable<KeyValuePair<string, object?>>? tags);
+        protected Instrument(Meter meter, string name, string? unit = null, string? description = null, IEnumerable<KeyValuePair<string, object?>>? tags = null);
     }
     public abstract class Instrument<T> : Instrument where T : struct {
+        protected Instrument(Meter meter, string name);
+        protected Instrument(Meter meter, string name, string? unit = null, string? description = null, IEnumerable<KeyValuePair<string, object?>>? tags = null, InstrumentAdvice<T>? advice = null);
+        public InstrumentAdvice<T>? Advice { get; }
     }
+    public sealed class InstrumentAdvice<T> where T : struct {
+        public InstrumentAdvice();
+        public IReadOnlyList<T>? HistogramBucketBoundaries { get; set; }
+    }
     public class Meter : IDisposable {
+        public Gauge<T> CreateGauge<T>(string name) where T : struct;
+        public Gauge<T> CreateGauge<T>(string name, string unit = null, string description = null, IEnumerable<KeyValuePair<string, object?>>? tags = null) where T : struct;
+        public Histogram<T> CreateHistogram<T>(string name) where T : struct;
-        public Histogram<T> CreateHistogram<T>(string name, string unit = null, string description = null) where T : struct;
+        public Histogram<T> CreateHistogram<T>(string name, string unit, string description) where T : struct;
-        public Histogram<T> CreateHistogram<T>(string name, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        public Histogram<T> CreateHistogram<T>(string name, string unit, string description, IEnumerable<KeyValuePair<string, object?>>? tags) where T : struct;
+        public Histogram<T> CreateHistogram<T>(string name, string unit = null, string description = null, IEnumerable<KeyValuePair<string, object?>>? tags = null, InstrumentAdvice<T>? advice = null) where T : struct;
     }
 }
```

