# System.Numerics

``` diff
 namespace System.Numerics {
     public static class Vector {
+        public static Plane AsPlane(this Vector4 value);
+        public static Quaternion AsQuaternion(this Vector4 value);
+        public static Vector2 AsVector2(this Vector4 value);
+        public static Vector3 AsVector3(this Vector4 value);
+        public static Vector4 AsVector4(this Plane value);
+        public static Vector4 AsVector4(this Quaternion value);
+        public static Vector4 AsVector4(this Vector2 value);
+        public static Vector4 AsVector4(this Vector3 value);
+        public static Vector4 AsVector4Unsafe(this Vector2 value);
+        public static Vector4 AsVector4Unsafe(this Vector3 value);
+        public static Vector<T> Create<T>(ReadOnlySpan<T> values);
+        public static Vector<T> Create<T>(T value);
     }
     public struct Vector2 : IEquatable<Vector2>, IFormattable {
+        public static Vector2 Create(ReadOnlySpan<float> values);
+        public static Vector2 Create(float value);
+        public static Vector2 Create(float x, float y);
     }
     public struct Vector3 : IEquatable<Vector3>, IFormattable {
+        public static Vector3 Create(Vector2 vector, float z);
+        public static Vector3 Create(ReadOnlySpan<float> values);
+        public static Vector3 Create(float value);
+        public static Vector3 Create(float x, float y, float z);
     }
     public struct Vector4 : IEquatable<Vector4>, IFormattable {
+        public static Vector4 Create(Vector2 vector, float z, float w);
+        public static Vector4 Create(Vector3 vector, float w);
+        public static Vector4 Create(ReadOnlySpan<float> values);
+        public static Vector4 Create(float value);
+        public static Vector4 Create(float x, float y, float z, float w);
     }
 }
```

