# System.Runtime.Intrinsics.Arm

``` diff
 namespace System.Runtime.Intrinsics.Arm {
     public abstract class AdvSimd : ArmBase {
+        public unsafe static (Vector64<byte> Value1, Vector64<byte> Value2) Load2xVector64(byte* address);
+        public unsafe static (Vector64<short> Value1, Vector64<short> Value2) Load2xVector64(short* address);
+        public unsafe static (Vector64<int> Value1, Vector64<int> Value2) Load2xVector64(int* address);
+        public unsafe static (Vector64<sbyte> Value1, Vector64<sbyte> Value2) Load2xVector64(sbyte* address);
+        public unsafe static (Vector64<float> Value1, Vector64<float> Value2) Load2xVector64(float* address);
+        public unsafe static (Vector64<ushort> Value1, Vector64<ushort> Value2) Load2xVector64(ushort* address);
+        public unsafe static (Vector64<uint> Value1, Vector64<uint> Value2) Load2xVector64(uint* address);
+        public unsafe static (Vector64<byte> Value1, Vector64<byte> Value2) Load2xVector64AndUnzip(byte* address);
+        public unsafe static (Vector64<short> Value1, Vector64<short> Value2) Load2xVector64AndUnzip(short* address);
+        public unsafe static (Vector64<int> Value1, Vector64<int> Value2) Load2xVector64AndUnzip(int* address);
+        public unsafe static (Vector64<sbyte> Value1, Vector64<sbyte> Value2) Load2xVector64AndUnzip(sbyte* address);
+        public unsafe static (Vector64<float> Value1, Vector64<float> Value2) Load2xVector64AndUnzip(float* address);
+        public unsafe static (Vector64<ushort> Value1, Vector64<ushort> Value2) Load2xVector64AndUnzip(ushort* address);
+        public unsafe static (Vector64<uint> Value1, Vector64<uint> Value2) Load2xVector64AndUnzip(uint* address);
+        public unsafe static (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3) Load3xVector64(byte* address);
+        public unsafe static (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3) Load3xVector64(short* address);
+        public unsafe static (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3) Load3xVector64(int* address);
+        public unsafe static (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3) Load3xVector64(sbyte* address);
+        public unsafe static (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3) Load3xVector64(float* address);
+        public unsafe static (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3) Load3xVector64(ushort* address);
+        public unsafe static (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3) Load3xVector64(uint* address);
+        public unsafe static (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3) Load3xVector64AndUnzip(byte* address);
+        public unsafe static (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3) Load3xVector64AndUnzip(short* address);
+        public unsafe static (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3) Load3xVector64AndUnzip(int* address);
+        public unsafe static (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3) Load3xVector64AndUnzip(sbyte* address);
+        public unsafe static (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3) Load3xVector64AndUnzip(float* address);
+        public unsafe static (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3) Load3xVector64AndUnzip(ushort* address);
+        public unsafe static (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3) Load3xVector64AndUnzip(uint* address);
+        public unsafe static (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3, Vector64<byte> Value4) Load4xVector64(byte* address);
+        public unsafe static (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3, Vector64<short> Value4) Load4xVector64(short* address);
+        public unsafe static (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3, Vector64<int> Value4) Load4xVector64(int* address);
+        public unsafe static (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3, Vector64<sbyte> Value4) Load4xVector64(sbyte* address);
+        public unsafe static (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3, Vector64<float> Value4) Load4xVector64(float* address);
+        public unsafe static (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3, Vector64<ushort> Value4) Load4xVector64(ushort* address);
+        public unsafe static (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3, Vector64<uint> Value4) Load4xVector64(uint* address);
+        public unsafe static (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3, Vector64<byte> Value4) Load4xVector64AndUnzip(byte* address);
+        public unsafe static (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3, Vector64<short> Value4) Load4xVector64AndUnzip(short* address);
+        public unsafe static (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3, Vector64<int> Value4) Load4xVector64AndUnzip(int* address);
+        public unsafe static (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3, Vector64<sbyte> Value4) Load4xVector64AndUnzip(sbyte* address);
+        public unsafe static (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3, Vector64<float> Value4) Load4xVector64AndUnzip(float* address);
+        public unsafe static (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3, Vector64<ushort> Value4) Load4xVector64AndUnzip(ushort* address);
+        public unsafe static (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3, Vector64<uint> Value4) Load4xVector64AndUnzip(uint* address);
-        public unsafe static (Vector64<byte> Value1, Vector64<byte> Value2) LoadVector64x2(byte* address);

-        public unsafe static (Vector64<short> Value1, Vector64<short> Value2) LoadVector64x2(short* address);

-        public unsafe static (Vector64<int> Value1, Vector64<int> Value2) LoadVector64x2(int* address);

-        public unsafe static (Vector64<sbyte> Value1, Vector64<sbyte> Value2) LoadVector64x2(sbyte* address);

-        public unsafe static (Vector64<float> Value1, Vector64<float> Value2) LoadVector64x2(float* address);

-        public unsafe static (Vector64<ushort> Value1, Vector64<ushort> Value2) LoadVector64x2(ushort* address);

-        public unsafe static (Vector64<uint> Value1, Vector64<uint> Value2) LoadVector64x2(uint* address);

-        public unsafe static (Vector64<byte> Value1, Vector64<byte> Value2) LoadVector64x2AndUnzip(byte* address);

-        public unsafe static (Vector64<short> Value1, Vector64<short> Value2) LoadVector64x2AndUnzip(short* address);

-        public unsafe static (Vector64<int> Value1, Vector64<int> Value2) LoadVector64x2AndUnzip(int* address);

-        public unsafe static (Vector64<sbyte> Value1, Vector64<sbyte> Value2) LoadVector64x2AndUnzip(sbyte* address);

-        public unsafe static (Vector64<float> Value1, Vector64<float> Value2) LoadVector64x2AndUnzip(float* address);

-        public unsafe static (Vector64<ushort> Value1, Vector64<ushort> Value2) LoadVector64x2AndUnzip(ushort* address);

-        public unsafe static (Vector64<uint> Value1, Vector64<uint> Value2) LoadVector64x2AndUnzip(uint* address);

-        public unsafe static (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3) LoadVector64x3(byte* address);

-        public unsafe static (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3) LoadVector64x3(short* address);

-        public unsafe static (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3) LoadVector64x3(int* address);

-        public unsafe static (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3) LoadVector64x3(sbyte* address);

-        public unsafe static (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3) LoadVector64x3(float* address);

-        public unsafe static (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3) LoadVector64x3(ushort* address);

-        public unsafe static (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3) LoadVector64x3(uint* address);

-        public unsafe static (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3) LoadVector64x3AndUnzip(byte* address);

-        public unsafe static (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3) LoadVector64x3AndUnzip(short* address);

-        public unsafe static (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3) LoadVector64x3AndUnzip(int* address);

-        public unsafe static (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3) LoadVector64x3AndUnzip(sbyte* address);

-        public unsafe static (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3) LoadVector64x3AndUnzip(float* address);

-        public unsafe static (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3) LoadVector64x3AndUnzip(ushort* address);

-        public unsafe static (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3) LoadVector64x3AndUnzip(uint* address);

-        public unsafe static (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3, Vector64<byte> Value4) LoadVector64x4(byte* address);

-        public unsafe static (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3, Vector64<short> Value4) LoadVector64x4(short* address);

-        public unsafe static (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3, Vector64<int> Value4) LoadVector64x4(int* address);

-        public unsafe static (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3, Vector64<sbyte> Value4) LoadVector64x4(sbyte* address);

-        public unsafe static (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3, Vector64<float> Value4) LoadVector64x4(float* address);

-        public unsafe static (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3, Vector64<ushort> Value4) LoadVector64x4(ushort* address);

-        public unsafe static (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3, Vector64<uint> Value4) LoadVector64x4(uint* address);

-        public unsafe static (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3, Vector64<byte> Value4) LoadVector64x4AndUnzip(byte* address);

-        public unsafe static (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3, Vector64<short> Value4) LoadVector64x4AndUnzip(short* address);

-        public unsafe static (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3, Vector64<int> Value4) LoadVector64x4AndUnzip(int* address);

-        public unsafe static (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3, Vector64<sbyte> Value4) LoadVector64x4AndUnzip(sbyte* address);

-        public unsafe static (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3, Vector64<float> Value4) LoadVector64x4AndUnzip(float* address);

-        public unsafe static (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3, Vector64<ushort> Value4) LoadVector64x4AndUnzip(ushort* address);

-        public unsafe static (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3, Vector64<uint> Value4) LoadVector64x4AndUnzip(uint* address);

+        public unsafe static void Store(byte* address, (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3, Vector64<byte> Value4) value);
+        public unsafe static void Store(byte* address, (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3) value);
+        public unsafe static void Store(byte* address, (Vector64<byte> Value1, Vector64<byte> Value2) value);
+        public unsafe static void Store(short* address, (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3, Vector64<short> Value4) value);
+        public unsafe static void Store(short* address, (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3) value);
+        public unsafe static void Store(short* address, (Vector64<short> Value1, Vector64<short> Value2) value);
+        public unsafe static void Store(int* address, (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3, Vector64<int> Value4) value);
+        public unsafe static void Store(int* address, (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3) value);
+        public unsafe static void Store(int* address, (Vector64<int> Value1, Vector64<int> Value2) value);
+        public unsafe static void Store(sbyte* address, (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3, Vector64<sbyte> Value4) value);
+        public unsafe static void Store(sbyte* address, (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3) value);
+        public unsafe static void Store(sbyte* address, (Vector64<sbyte> Value1, Vector64<sbyte> Value2) value);
+        public unsafe static void Store(float* address, (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3, Vector64<float> Value4) value);
+        public unsafe static void Store(float* address, (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3) value);
+        public unsafe static void Store(float* address, (Vector64<float> Value1, Vector64<float> Value2) value);
+        public unsafe static void Store(ushort* address, (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3, Vector64<ushort> Value4) value);
+        public unsafe static void Store(ushort* address, (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3) value);
+        public unsafe static void Store(ushort* address, (Vector64<ushort> Value1, Vector64<ushort> Value2) value);
+        public unsafe static void Store(uint* address, (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3, Vector64<uint> Value4) value);
+        public unsafe static void Store(uint* address, (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3) value);
+        public unsafe static void Store(uint* address, (Vector64<uint> Value1, Vector64<uint> Value2) value);
-        public unsafe static void StoreVector64x2(byte* address, (Vector64<byte> Value1, Vector64<byte> Value2) value);

-        public unsafe static void StoreVector64x2(short* address, (Vector64<short> Value1, Vector64<short> Value2) value);

-        public unsafe static void StoreVector64x2(int* address, (Vector64<int> Value1, Vector64<int> Value2) value);

-        public unsafe static void StoreVector64x2(sbyte* address, (Vector64<sbyte> Value1, Vector64<sbyte> Value2) value);

-        public unsafe static void StoreVector64x2(float* address, (Vector64<float> Value1, Vector64<float> Value2) value);

-        public unsafe static void StoreVector64x2(ushort* address, (Vector64<ushort> Value1, Vector64<ushort> Value2) value);

-        public unsafe static void StoreVector64x2(uint* address, (Vector64<uint> Value1, Vector64<uint> Value2) value);

-        public unsafe static void StoreVector64x2AndZip(byte* address, (Vector64<byte> Value1, Vector64<byte> Value2) value);

-        public unsafe static void StoreVector64x2AndZip(short* address, (Vector64<short> Value1, Vector64<short> Value2) value);

-        public unsafe static void StoreVector64x2AndZip(int* address, (Vector64<int> Value1, Vector64<int> Value2) value);

-        public unsafe static void StoreVector64x2AndZip(sbyte* address, (Vector64<sbyte> Value1, Vector64<sbyte> Value2) value);

-        public unsafe static void StoreVector64x2AndZip(float* address, (Vector64<float> Value1, Vector64<float> Value2) value);

-        public unsafe static void StoreVector64x2AndZip(ushort* address, (Vector64<ushort> Value1, Vector64<ushort> Value2) value);

-        public unsafe static void StoreVector64x2AndZip(uint* address, (Vector64<uint> Value1, Vector64<uint> Value2) value);

-        public unsafe static void StoreVector64x3(byte* address, (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3) value);

-        public unsafe static void StoreVector64x3(short* address, (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3) value);

-        public unsafe static void StoreVector64x3(int* address, (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3) value);

-        public unsafe static void StoreVector64x3(sbyte* address, (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3) value);

-        public unsafe static void StoreVector64x3(float* address, (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3) value);

-        public unsafe static void StoreVector64x3(ushort* address, (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3) value);

-        public unsafe static void StoreVector64x3(uint* address, (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3) value);

-        public unsafe static void StoreVector64x3AndZip(byte* address, (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3) value);

-        public unsafe static void StoreVector64x3AndZip(short* address, (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3) value);

-        public unsafe static void StoreVector64x3AndZip(int* address, (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3) value);

-        public unsafe static void StoreVector64x3AndZip(sbyte* address, (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3) value);

-        public unsafe static void StoreVector64x3AndZip(float* address, (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3) value);

-        public unsafe static void StoreVector64x3AndZip(ushort* address, (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3) value);

-        public unsafe static void StoreVector64x3AndZip(uint* address, (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3) value);

-        public unsafe static void StoreVector64x4(byte* address, (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3, Vector64<byte> Value4) value);

-        public unsafe static void StoreVector64x4(short* address, (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3, Vector64<short> Value4) value);

-        public unsafe static void StoreVector64x4(int* address, (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3, Vector64<int> Value4) value);

-        public unsafe static void StoreVector64x4(sbyte* address, (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3, Vector64<sbyte> Value4) value);

-        public unsafe static void StoreVector64x4(float* address, (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3, Vector64<float> Value4) value);

-        public unsafe static void StoreVector64x4(ushort* address, (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3, Vector64<ushort> Value4) value);

-        public unsafe static void StoreVector64x4(uint* address, (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3, Vector64<uint> Value4) value);

-        public unsafe static void StoreVector64x4AndZip(byte* address, (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3, Vector64<byte> Value4) value);

-        public unsafe static void StoreVector64x4AndZip(short* address, (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3, Vector64<short> Value4) value);

-        public unsafe static void StoreVector64x4AndZip(int* address, (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3, Vector64<int> Value4) value);

-        public unsafe static void StoreVector64x4AndZip(sbyte* address, (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3, Vector64<sbyte> Value4) value);

-        public unsafe static void StoreVector64x4AndZip(float* address, (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3, Vector64<float> Value4) value);

-        public unsafe static void StoreVector64x4AndZip(ushort* address, (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3, Vector64<ushort> Value4) value);

-        public unsafe static void StoreVector64x4AndZip(uint* address, (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3, Vector64<uint> Value4) value);

+        public unsafe static void StoreVectorAndZip(byte* address, (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3, Vector64<byte> Value4) value);
+        public unsafe static void StoreVectorAndZip(byte* address, (Vector64<byte> Value1, Vector64<byte> Value2, Vector64<byte> Value3) value);
+        public unsafe static void StoreVectorAndZip(byte* address, (Vector64<byte> Value1, Vector64<byte> Value2) value);
+        public unsafe static void StoreVectorAndZip(short* address, (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3, Vector64<short> Value4) value);
+        public unsafe static void StoreVectorAndZip(short* address, (Vector64<short> Value1, Vector64<short> Value2, Vector64<short> Value3) value);
+        public unsafe static void StoreVectorAndZip(short* address, (Vector64<short> Value1, Vector64<short> Value2) value);
+        public unsafe static void StoreVectorAndZip(int* address, (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3, Vector64<int> Value4) value);
+        public unsafe static void StoreVectorAndZip(int* address, (Vector64<int> Value1, Vector64<int> Value2, Vector64<int> Value3) value);
+        public unsafe static void StoreVectorAndZip(int* address, (Vector64<int> Value1, Vector64<int> Value2) value);
+        public unsafe static void StoreVectorAndZip(sbyte* address, (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3, Vector64<sbyte> Value4) value);
+        public unsafe static void StoreVectorAndZip(sbyte* address, (Vector64<sbyte> Value1, Vector64<sbyte> Value2, Vector64<sbyte> Value3) value);
+        public unsafe static void StoreVectorAndZip(sbyte* address, (Vector64<sbyte> Value1, Vector64<sbyte> Value2) value);
+        public unsafe static void StoreVectorAndZip(float* address, (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3, Vector64<float> Value4) value);
+        public unsafe static void StoreVectorAndZip(float* address, (Vector64<float> Value1, Vector64<float> Value2, Vector64<float> Value3) value);
+        public unsafe static void StoreVectorAndZip(float* address, (Vector64<float> Value1, Vector64<float> Value2) value);
+        public unsafe static void StoreVectorAndZip(ushort* address, (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3, Vector64<ushort> Value4) value);
+        public unsafe static void StoreVectorAndZip(ushort* address, (Vector64<ushort> Value1, Vector64<ushort> Value2, Vector64<ushort> Value3) value);
+        public unsafe static void StoreVectorAndZip(ushort* address, (Vector64<ushort> Value1, Vector64<ushort> Value2) value);
+        public unsafe static void StoreVectorAndZip(uint* address, (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3, Vector64<uint> Value4) value);
+        public unsafe static void StoreVectorAndZip(uint* address, (Vector64<uint> Value1, Vector64<uint> Value2, Vector64<uint> Value3) value);
+        public unsafe static void StoreVectorAndZip(uint* address, (Vector64<uint> Value1, Vector64<uint> Value2) value);
         public new abstract class Arm64 : ArmBase.Arm64 {
+            public unsafe static (Vector128<byte> Value1, Vector128<byte> Value2) Load2xVector128(byte* address);
+            public unsafe static (Vector128<double> Value1, Vector128<double> Value2) Load2xVector128(double* address);
+            public unsafe static (Vector128<short> Value1, Vector128<short> Value2) Load2xVector128(short* address);
+            public unsafe static (Vector128<int> Value1, Vector128<int> Value2) Load2xVector128(int* address);
+            public unsafe static (Vector128<long> Value1, Vector128<long> Value2) Load2xVector128(long* address);
+            public unsafe static (Vector128<sbyte> Value1, Vector128<sbyte> Value2) Load2xVector128(sbyte* address);
+            public unsafe static (Vector128<float> Value1, Vector128<float> Value2) Load2xVector128(float* address);
+            public unsafe static (Vector128<ushort> Value1, Vector128<ushort> Value2) Load2xVector128(ushort* address);
+            public unsafe static (Vector128<uint> Value1, Vector128<uint> Value2) Load2xVector128(uint* address);
+            public unsafe static (Vector128<ulong> Value1, Vector128<ulong> Value2) Load2xVector128(ulong* address);
+            public unsafe static (Vector128<byte> Value1, Vector128<byte> Value2) Load2xVector128AndUnzip(byte* address);
+            public unsafe static (Vector128<double> Value1, Vector128<double> Value2) Load2xVector128AndUnzip(double* address);
+            public unsafe static (Vector128<short> Value1, Vector128<short> Value2) Load2xVector128AndUnzip(short* address);
+            public unsafe static (Vector128<int> Value1, Vector128<int> Value2) Load2xVector128AndUnzip(int* address);
+            public unsafe static (Vector128<long> Value1, Vector128<long> Value2) Load2xVector128AndUnzip(long* address);
+            public unsafe static (Vector128<sbyte> Value1, Vector128<sbyte> Value2) Load2xVector128AndUnzip(sbyte* address);
+            public unsafe static (Vector128<float> Value1, Vector128<float> Value2) Load2xVector128AndUnzip(float* address);
+            public unsafe static (Vector128<ushort> Value1, Vector128<ushort> Value2) Load2xVector128AndUnzip(ushort* address);
+            public unsafe static (Vector128<uint> Value1, Vector128<uint> Value2) Load2xVector128AndUnzip(uint* address);
+            public unsafe static (Vector128<ulong> Value1, Vector128<ulong> Value2) Load2xVector128AndUnzip(ulong* address);
+            public unsafe static (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3) Load3xVector128(byte* address);
+            public unsafe static (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3) Load3xVector128(double* address);
+            public unsafe static (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3) Load3xVector128(short* address);
+            public unsafe static (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3) Load3xVector128(int* address);
+            public unsafe static (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3) Load3xVector128(long* address);
+            public unsafe static (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3) Load3xVector128(sbyte* address);
+            public unsafe static (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3) Load3xVector128(float* address);
+            public unsafe static (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3) Load3xVector128(ushort* address);
+            public unsafe static (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3) Load3xVector128(uint* address);
+            public unsafe static (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3) Load3xVector128(ulong* address);
+            public unsafe static (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3) Load3xVector128AndUnzip(byte* address);
+            public unsafe static (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3) Load3xVector128AndUnzip(double* address);
+            public unsafe static (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3) Load3xVector128AndUnzip(short* address);
+            public unsafe static (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3) Load3xVector128AndUnzip(int* address);
+            public unsafe static (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3) Load3xVector128AndUnzip(long* address);
+            public unsafe static (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3) Load3xVector128AndUnzip(sbyte* address);
+            public unsafe static (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3) Load3xVector128AndUnzip(float* address);
+            public unsafe static (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3) Load3xVector128AndUnzip(ushort* address);
+            public unsafe static (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3) Load3xVector128AndUnzip(uint* address);
+            public unsafe static (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3) Load3xVector128AndUnzip(ulong* address);
+            public unsafe static (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3, Vector128<byte> Value4) Load4xVector128(byte* address);
+            public unsafe static (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3, Vector128<double> Value4) Load4xVector128(double* address);
+            public unsafe static (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3, Vector128<short> Value4) Load4xVector128(short* address);
+            public unsafe static (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3, Vector128<int> Value4) Load4xVector128(int* address);
+            public unsafe static (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3, Vector128<long> Value4) Load4xVector128(long* address);
+            public unsafe static (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3, Vector128<sbyte> Value4) Load4xVector128(sbyte* address);
+            public unsafe static (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3, Vector128<float> Value4) Load4xVector128(float* address);
+            public unsafe static (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3, Vector128<ushort> Value4) Load4xVector128(ushort* address);
+            public unsafe static (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3, Vector128<uint> Value4) Load4xVector128(uint* address);
+            public unsafe static (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3, Vector128<ulong> Value4) Load4xVector128(ulong* address);
+            public unsafe static (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3, Vector128<byte> Value4) Load4xVector128AndUnzip(byte* address);
+            public unsafe static (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3, Vector128<double> Value4) Load4xVector128AndUnzip(double* address);
+            public unsafe static (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3, Vector128<short> Value4) Load4xVector128AndUnzip(short* address);
+            public unsafe static (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3, Vector128<int> Value4) Load4xVector128AndUnzip(int* address);
+            public unsafe static (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3, Vector128<long> Value4) Load4xVector128AndUnzip(long* address);
+            public unsafe static (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3, Vector128<sbyte> Value4) Load4xVector128AndUnzip(sbyte* address);
+            public unsafe static (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3, Vector128<float> Value4) Load4xVector128AndUnzip(float* address);
+            public unsafe static (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3, Vector128<ushort> Value4) Load4xVector128AndUnzip(ushort* address);
+            public unsafe static (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3, Vector128<uint> Value4) Load4xVector128AndUnzip(uint* address);
+            public unsafe static (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3, Vector128<ulong> Value4) Load4xVector128AndUnzip(ulong* address);
-            public unsafe static (Vector128<byte> Value1, Vector128<byte> Value2) LoadVector128x2(byte* address);

-            public unsafe static (Vector128<double> Value1, Vector128<double> Value2) LoadVector128x2(double* address);

-            public unsafe static (Vector128<short> Value1, Vector128<short> Value2) LoadVector128x2(short* address);

-            public unsafe static (Vector128<int> Value1, Vector128<int> Value2) LoadVector128x2(int* address);

-            public unsafe static (Vector128<long> Value1, Vector128<long> Value2) LoadVector128x2(long* address);

-            public unsafe static (Vector128<sbyte> Value1, Vector128<sbyte> Value2) LoadVector128x2(sbyte* address);

-            public unsafe static (Vector128<float> Value1, Vector128<float> Value2) LoadVector128x2(float* address);

-            public unsafe static (Vector128<ushort> Value1, Vector128<ushort> Value2) LoadVector128x2(ushort* address);

-            public unsafe static (Vector128<uint> Value1, Vector128<uint> Value2) LoadVector128x2(uint* address);

-            public unsafe static (Vector128<ulong> Value1, Vector128<ulong> Value2) LoadVector128x2(ulong* address);

-            public unsafe static (Vector128<byte> Value1, Vector128<byte> Value2) LoadVector128x2AndUnzip(byte* address);

-            public unsafe static (Vector128<double> Value1, Vector128<double> Value2) LoadVector128x2AndUnzip(double* address);

-            public unsafe static (Vector128<short> Value1, Vector128<short> Value2) LoadVector128x2AndUnzip(short* address);

-            public unsafe static (Vector128<int> Value1, Vector128<int> Value2) LoadVector128x2AndUnzip(int* address);

-            public unsafe static (Vector128<long> Value1, Vector128<long> Value2) LoadVector128x2AndUnzip(long* address);

-            public unsafe static (Vector128<sbyte> Value1, Vector128<sbyte> Value2) LoadVector128x2AndUnzip(sbyte* address);

-            public unsafe static (Vector128<float> Value1, Vector128<float> Value2) LoadVector128x2AndUnzip(float* address);

-            public unsafe static (Vector128<ushort> Value1, Vector128<ushort> Value2) LoadVector128x2AndUnzip(ushort* address);

-            public unsafe static (Vector128<uint> Value1, Vector128<uint> Value2) LoadVector128x2AndUnzip(uint* address);

-            public unsafe static (Vector128<ulong> Value1, Vector128<ulong> Value2) LoadVector128x2AndUnzip(ulong* address);

-            public unsafe static (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3) LoadVector128x3(byte* address);

-            public unsafe static (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3) LoadVector128x3(double* address);

-            public unsafe static (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3) LoadVector128x3(short* address);

-            public unsafe static (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3) LoadVector128x3(int* address);

-            public unsafe static (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3) LoadVector128x3(long* address);

-            public unsafe static (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3) LoadVector128x3(sbyte* address);

-            public unsafe static (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3) LoadVector128x3(float* address);

-            public unsafe static (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3) LoadVector128x3(ushort* address);

-            public unsafe static (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3) LoadVector128x3(uint* address);

-            public unsafe static (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3) LoadVector128x3(ulong* address);

-            public unsafe static (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3) LoadVector128x3AndUnzip(byte* address);

-            public unsafe static (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3) LoadVector128x3AndUnzip(double* address);

-            public unsafe static (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3) LoadVector128x3AndUnzip(short* address);

-            public unsafe static (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3) LoadVector128x3AndUnzip(int* address);

-            public unsafe static (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3) LoadVector128x3AndUnzip(long* address);

-            public unsafe static (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3) LoadVector128x3AndUnzip(sbyte* address);

-            public unsafe static (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3) LoadVector128x3AndUnzip(float* address);

-            public unsafe static (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3) LoadVector128x3AndUnzip(ushort* address);

-            public unsafe static (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3) LoadVector128x3AndUnzip(uint* address);

-            public unsafe static (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3) LoadVector128x3AndUnzip(ulong* address);

-            public unsafe static (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3, Vector128<byte> Value4) LoadVector128x4(byte* address);

-            public unsafe static (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3, Vector128<double> Value4) LoadVector128x4(double* address);

-            public unsafe static (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3, Vector128<short> Value4) LoadVector128x4(short* address);

-            public unsafe static (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3, Vector128<int> Value4) LoadVector128x4(int* address);

-            public unsafe static (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3, Vector128<long> Value4) LoadVector128x4(long* address);

-            public unsafe static (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3, Vector128<sbyte> Value4) LoadVector128x4(sbyte* address);

-            public unsafe static (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3, Vector128<float> Value4) LoadVector128x4(float* address);

-            public unsafe static (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3, Vector128<ushort> Value4) LoadVector128x4(ushort* address);

-            public unsafe static (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3, Vector128<uint> Value4) LoadVector128x4(uint* address);

-            public unsafe static (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3, Vector128<ulong> Value4) LoadVector128x4(ulong* address);

-            public unsafe static (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3, Vector128<byte> Value4) LoadVector128x4AndUnzip(byte* address);

-            public unsafe static (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3, Vector128<double> Value4) LoadVector128x4AndUnzip(double* address);

-            public unsafe static (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3, Vector128<short> Value4) LoadVector128x4AndUnzip(short* address);

-            public unsafe static (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3, Vector128<int> Value4) LoadVector128x4AndUnzip(int* address);

-            public unsafe static (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3, Vector128<long> Value4) LoadVector128x4AndUnzip(long* address);

-            public unsafe static (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3, Vector128<sbyte> Value4) LoadVector128x4AndUnzip(sbyte* address);

-            public unsafe static (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3, Vector128<float> Value4) LoadVector128x4AndUnzip(float* address);

-            public unsafe static (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3, Vector128<ushort> Value4) LoadVector128x4AndUnzip(ushort* address);

-            public unsafe static (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3, Vector128<uint> Value4) LoadVector128x4AndUnzip(uint* address);

-            public unsafe static (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3, Vector128<ulong> Value4) LoadVector128x4AndUnzip(ulong* address);

+            public unsafe static void Store(byte* address, (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3, Vector128<byte> Value4) value);
+            public unsafe static void Store(byte* address, (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3) value);
+            public unsafe static void Store(byte* address, (Vector128<byte> Value1, Vector128<byte> Value2) value);
+            public unsafe static void Store(double* address, (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3, Vector128<double> Value4) value);
+            public unsafe static void Store(double* address, (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3) value);
+            public unsafe static void Store(double* address, (Vector128<double> Value1, Vector128<double> Value2) value);
+            public unsafe static void Store(short* address, (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3, Vector128<short> Value4) value);
+            public unsafe static void Store(short* address, (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3) value);
+            public unsafe static void Store(short* address, (Vector128<short> Value1, Vector128<short> Value2) value);
+            public unsafe static void Store(int* address, (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3, Vector128<int> Value4) value);
+            public unsafe static void Store(int* address, (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3) value);
+            public unsafe static void Store(int* address, (Vector128<int> Value1, Vector128<int> Value2) value);
+            public unsafe static void Store(long* address, (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3, Vector128<long> Value4) value);
+            public unsafe static void Store(long* address, (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3) value);
+            public unsafe static void Store(long* address, (Vector128<long> Value1, Vector128<long> Value2) value);
+            public unsafe static void Store(sbyte* address, (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3, Vector128<sbyte> Value4) value);
+            public unsafe static void Store(sbyte* address, (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3) value);
+            public unsafe static void Store(sbyte* address, (Vector128<sbyte> Value1, Vector128<sbyte> Value2) value);
+            public unsafe static void Store(float* address, (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3, Vector128<float> Value4) value);
+            public unsafe static void Store(float* address, (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3) value);
+            public unsafe static void Store(float* address, (Vector128<float> Value1, Vector128<float> Value2) value);
+            public unsafe static void Store(ushort* address, (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3, Vector128<ushort> Value4) value);
+            public unsafe static void Store(ushort* address, (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3) value);
+            public unsafe static void Store(ushort* address, (Vector128<ushort> Value1, Vector128<ushort> Value2) value);
+            public unsafe static void Store(uint* address, (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3, Vector128<uint> Value4) value);
+            public unsafe static void Store(uint* address, (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3) value);
+            public unsafe static void Store(uint* address, (Vector128<uint> Value1, Vector128<uint> Value2) value);
+            public unsafe static void Store(ulong* address, (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3, Vector128<ulong> Value4) value);
+            public unsafe static void Store(ulong* address, (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3) value);
+            public unsafe static void Store(ulong* address, (Vector128<ulong> Value1, Vector128<ulong> Value2) value);
-            public unsafe static void StoreVector128x2(byte* address, (Vector128<byte> Value1, Vector128<byte> Value2) value);

-            public unsafe static void StoreVector128x2(double* address, (Vector128<double> Value1, Vector128<double> Value2) value);

-            public unsafe static void StoreVector128x2(short* address, (Vector128<short> Value1, Vector128<short> Value2) value);

-            public unsafe static void StoreVector128x2(int* address, (Vector128<int> Value1, Vector128<int> Value2) value);

-            public unsafe static void StoreVector128x2(long* address, (Vector128<long> Value1, Vector128<long> Value2) value);

-            public unsafe static void StoreVector128x2(sbyte* address, (Vector128<sbyte> Value1, Vector128<sbyte> Value2) value);

-            public unsafe static void StoreVector128x2(float* address, (Vector128<float> Value1, Vector128<float> Value2) value);

-            public unsafe static void StoreVector128x2(ushort* address, (Vector128<ushort> Value1, Vector128<ushort> Value2) value);

-            public unsafe static void StoreVector128x2(uint* address, (Vector128<uint> Value1, Vector128<uint> Value2) value);

-            public unsafe static void StoreVector128x2(ulong* address, (Vector128<ulong> Value1, Vector128<ulong> Value2) value);

-            public unsafe static void StoreVector128x2AndZip(byte* address, (Vector128<byte> Value1, Vector128<byte> Value2) value);

-            public unsafe static void StoreVector128x2AndZip(double* address, (Vector128<double> Value1, Vector128<double> Value2) value);

-            public unsafe static void StoreVector128x2AndZip(short* address, (Vector128<short> Value1, Vector128<short> Value2) value);

-            public unsafe static void StoreVector128x2AndZip(int* address, (Vector128<int> Value1, Vector128<int> Value2) value);

-            public unsafe static void StoreVector128x2AndZip(long* address, (Vector128<long> Value1, Vector128<long> Value2) value);

-            public unsafe static void StoreVector128x2AndZip(sbyte* address, (Vector128<sbyte> Value1, Vector128<sbyte> Value2) value);

-            public unsafe static void StoreVector128x2AndZip(float* address, (Vector128<float> Value1, Vector128<float> Value2) value);

-            public unsafe static void StoreVector128x2AndZip(ushort* address, (Vector128<ushort> Value1, Vector128<ushort> Value2) value);

-            public unsafe static void StoreVector128x2AndZip(uint* address, (Vector128<uint> Value1, Vector128<uint> Value2) value);

-            public unsafe static void StoreVector128x2AndZip(ulong* address, (Vector128<ulong> Value1, Vector128<ulong> Value2) value);

-            public unsafe static void StoreVector128x3(byte* address, (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3) value);

-            public unsafe static void StoreVector128x3(double* address, (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3) value);

-            public unsafe static void StoreVector128x3(short* address, (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3) value);

-            public unsafe static void StoreVector128x3(int* address, (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3) value);

-            public unsafe static void StoreVector128x3(long* address, (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3) value);

-            public unsafe static void StoreVector128x3(sbyte* address, (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3) value);

-            public unsafe static void StoreVector128x3(float* address, (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3) value);

-            public unsafe static void StoreVector128x3(ushort* address, (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3) value);

-            public unsafe static void StoreVector128x3(uint* address, (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3) value);

-            public unsafe static void StoreVector128x3(ulong* address, (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3) value);

-            public unsafe static void StoreVector128x3AndZip(byte* address, (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3) value);

-            public unsafe static void StoreVector128x3AndZip(double* address, (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3) value);

-            public unsafe static void StoreVector128x3AndZip(short* address, (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3) value);

-            public unsafe static void StoreVector128x3AndZip(int* address, (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3) value);

-            public unsafe static void StoreVector128x3AndZip(long* address, (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3) value);

-            public unsafe static void StoreVector128x3AndZip(sbyte* address, (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3) value);

-            public unsafe static void StoreVector128x3AndZip(float* address, (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3) value);

-            public unsafe static void StoreVector128x3AndZip(ushort* address, (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3) value);

-            public unsafe static void StoreVector128x3AndZip(uint* address, (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3) value);

-            public unsafe static void StoreVector128x3AndZip(ulong* address, (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3) value);

-            public unsafe static void StoreVector128x4(byte* address, (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3, Vector128<byte> Value4) value);

-            public unsafe static void StoreVector128x4(double* address, (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3, Vector128<double> Value4) value);

-            public unsafe static void StoreVector128x4(short* address, (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3, Vector128<short> Value4) value);

-            public unsafe static void StoreVector128x4(int* address, (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3, Vector128<int> Value4) value);

-            public unsafe static void StoreVector128x4(long* address, (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3, Vector128<long> Value4) value);

-            public unsafe static void StoreVector128x4(sbyte* address, (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3, Vector128<sbyte> Value4) value);

-            public unsafe static void StoreVector128x4(float* address, (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3, Vector128<float> Value4) value);

-            public unsafe static void StoreVector128x4(ushort* address, (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3, Vector128<ushort> Value4) value);

-            public unsafe static void StoreVector128x4(uint* address, (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3, Vector128<uint> Value4) value);

-            public unsafe static void StoreVector128x4(ulong* address, (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3, Vector128<ulong> Value4) value);

-            public unsafe static void StoreVector128x4AndZip(byte* address, (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3, Vector128<byte> Value4) value);

-            public unsafe static void StoreVector128x4AndZip(double* address, (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3, Vector128<double> Value4) value);

-            public unsafe static void StoreVector128x4AndZip(short* address, (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3, Vector128<short> Value4) value);

-            public unsafe static void StoreVector128x4AndZip(int* address, (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3, Vector128<int> Value4) value);

-            public unsafe static void StoreVector128x4AndZip(long* address, (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3, Vector128<long> Value4) value);

-            public unsafe static void StoreVector128x4AndZip(sbyte* address, (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3, Vector128<sbyte> Value4) value);

-            public unsafe static void StoreVector128x4AndZip(float* address, (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3, Vector128<float> Value4) value);

-            public unsafe static void StoreVector128x4AndZip(ushort* address, (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3, Vector128<ushort> Value4) value);

-            public unsafe static void StoreVector128x4AndZip(uint* address, (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3, Vector128<uint> Value4) value);

-            public unsafe static void StoreVector128x4AndZip(ulong* address, (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3, Vector128<ulong> Value4) value);

+            public unsafe static void StoreVectorAndZip(byte* address, (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3, Vector128<byte> Value4) value);
+            public unsafe static void StoreVectorAndZip(byte* address, (Vector128<byte> Value1, Vector128<byte> Value2, Vector128<byte> Value3) value);
+            public unsafe static void StoreVectorAndZip(byte* address, (Vector128<byte> Value1, Vector128<byte> Value2) value);
+            public unsafe static void StoreVectorAndZip(double* address, (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3, Vector128<double> Value4) value);
+            public unsafe static void StoreVectorAndZip(double* address, (Vector128<double> Value1, Vector128<double> Value2, Vector128<double> Value3) value);
+            public unsafe static void StoreVectorAndZip(double* address, (Vector128<double> Value1, Vector128<double> Value2) value);
+            public unsafe static void StoreVectorAndZip(short* address, (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3, Vector128<short> Value4) value);
+            public unsafe static void StoreVectorAndZip(short* address, (Vector128<short> Value1, Vector128<short> Value2, Vector128<short> Value3) value);
+            public unsafe static void StoreVectorAndZip(short* address, (Vector128<short> Value1, Vector128<short> Value2) value);
+            public unsafe static void StoreVectorAndZip(int* address, (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3, Vector128<int> Value4) value);
+            public unsafe static void StoreVectorAndZip(int* address, (Vector128<int> Value1, Vector128<int> Value2, Vector128<int> Value3) value);
+            public unsafe static void StoreVectorAndZip(int* address, (Vector128<int> Value1, Vector128<int> Value2) value);
+            public unsafe static void StoreVectorAndZip(long* address, (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3, Vector128<long> Value4) value);
+            public unsafe static void StoreVectorAndZip(long* address, (Vector128<long> Value1, Vector128<long> Value2, Vector128<long> Value3) value);
+            public unsafe static void StoreVectorAndZip(long* address, (Vector128<long> Value1, Vector128<long> Value2) value);
+            public unsafe static void StoreVectorAndZip(sbyte* address, (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3, Vector128<sbyte> Value4) value);
+            public unsafe static void StoreVectorAndZip(sbyte* address, (Vector128<sbyte> Value1, Vector128<sbyte> Value2, Vector128<sbyte> Value3) value);
+            public unsafe static void StoreVectorAndZip(sbyte* address, (Vector128<sbyte> Value1, Vector128<sbyte> Value2) value);
+            public unsafe static void StoreVectorAndZip(float* address, (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3, Vector128<float> Value4) value);
+            public unsafe static void StoreVectorAndZip(float* address, (Vector128<float> Value1, Vector128<float> Value2, Vector128<float> Value3) value);
+            public unsafe static void StoreVectorAndZip(float* address, (Vector128<float> Value1, Vector128<float> Value2) value);
+            public unsafe static void StoreVectorAndZip(ushort* address, (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3, Vector128<ushort> Value4) value);
+            public unsafe static void StoreVectorAndZip(ushort* address, (Vector128<ushort> Value1, Vector128<ushort> Value2, Vector128<ushort> Value3) value);
+            public unsafe static void StoreVectorAndZip(ushort* address, (Vector128<ushort> Value1, Vector128<ushort> Value2) value);
+            public unsafe static void StoreVectorAndZip(uint* address, (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3, Vector128<uint> Value4) value);
+            public unsafe static void StoreVectorAndZip(uint* address, (Vector128<uint> Value1, Vector128<uint> Value2, Vector128<uint> Value3) value);
+            public unsafe static void StoreVectorAndZip(uint* address, (Vector128<uint> Value1, Vector128<uint> Value2) value);
+            public unsafe static void StoreVectorAndZip(ulong* address, (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3, Vector128<ulong> Value4) value);
+            public unsafe static void StoreVectorAndZip(ulong* address, (Vector128<ulong> Value1, Vector128<ulong> Value2, Vector128<ulong> Value3) value);
+            public unsafe static void StoreVectorAndZip(ulong* address, (Vector128<ulong> Value1, Vector128<ulong> Value2) value);
         }
     }
     public abstract class Sve : AdvSimd {
+        public static Vector<double> Compact(Vector<double> mask, Vector<double> value);
+        public static Vector<int> Compact(Vector<int> mask, Vector<int> value);
+        public static Vector<long> Compact(Vector<long> mask, Vector<long> value);
+        public static Vector<float> Compact(Vector<float> mask, Vector<float> value);
+        public static Vector<uint> Compact(Vector<uint> mask, Vector<uint> value);
+        public static Vector<ulong> Compact(Vector<ulong> mask, Vector<ulong> value);
+        public static Vector<uint> Compute16BitAddresses(Vector<uint> bases, Vector<int> indices);
+        public static Vector<uint> Compute16BitAddresses(Vector<uint> bases, Vector<uint> indices);
+        public static Vector<ulong> Compute16BitAddresses(Vector<ulong> bases, Vector<long> indices);
+        public static Vector<ulong> Compute16BitAddresses(Vector<ulong> bases, Vector<ulong> indices);
+        public static Vector<uint> Compute32BitAddresses(Vector<uint> bases, Vector<int> indices);
+        public static Vector<uint> Compute32BitAddresses(Vector<uint> bases, Vector<uint> indices);
+        public static Vector<ulong> Compute32BitAddresses(Vector<ulong> bases, Vector<long> indices);
+        public static Vector<ulong> Compute32BitAddresses(Vector<ulong> bases, Vector<ulong> indices);
+        public static Vector<uint> Compute64BitAddresses(Vector<uint> bases, Vector<int> indices);
+        public static Vector<uint> Compute64BitAddresses(Vector<uint> bases, Vector<uint> indices);
+        public static Vector<ulong> Compute64BitAddresses(Vector<ulong> bases, Vector<long> indices);
+        public static Vector<ulong> Compute64BitAddresses(Vector<ulong> bases, Vector<ulong> indices);
+        public static Vector<uint> Compute8BitAddresses(Vector<uint> bases, Vector<int> indices);
+        public static Vector<uint> Compute8BitAddresses(Vector<uint> bases, Vector<uint> indices);
+        public static Vector<ulong> Compute8BitAddresses(Vector<ulong> bases, Vector<long> indices);
+        public static Vector<ulong> Compute8BitAddresses(Vector<ulong> bases, Vector<ulong> indices);
+        public static Vector<int> ConvertToInt32(Vector<double> value);
+        public static Vector<int> ConvertToInt32(Vector<float> value);
+        public static Vector<uint> ConvertToUInt32(Vector<double> value);
+        public static Vector<uint> ConvertToUInt32(Vector<float> value);
+        public unsafe static Vector<double> GatherVector(Vector<double> mask, double* address, Vector<long> indices);
+        public unsafe static Vector<double> GatherVector(Vector<double> mask, double* address, Vector<ulong> indices);
+        public static Vector<double> GatherVector(Vector<double> mask, Vector<ulong> addresses);
+        public unsafe static Vector<int> GatherVector(Vector<int> mask, int* address, Vector<int> indices);
+        public unsafe static Vector<int> GatherVector(Vector<int> mask, int* address, Vector<uint> indices);
+        public unsafe static Vector<long> GatherVector(Vector<long> mask, long* address, Vector<long> indices);
+        public unsafe static Vector<long> GatherVector(Vector<long> mask, long* address, Vector<ulong> indices);
+        public static Vector<long> GatherVector(Vector<long> mask, Vector<ulong> addresses);
+        public unsafe static Vector<float> GatherVector(Vector<float> mask, float* address, Vector<int> indices);
+        public unsafe static Vector<float> GatherVector(Vector<float> mask, float* address, Vector<uint> indices);
+        public unsafe static Vector<uint> GatherVector(Vector<uint> mask, uint* address, Vector<int> indices);
+        public unsafe static Vector<uint> GatherVector(Vector<uint> mask, uint* address, Vector<uint> indices);
+        public static Vector<ulong> GatherVector(Vector<ulong> mask, Vector<ulong> addresses);
+        public unsafe static Vector<ulong> GatherVector(Vector<ulong> mask, ulong* address, Vector<long> indices);
+        public unsafe static Vector<ulong> GatherVector(Vector<ulong> mask, ulong* address, Vector<ulong> indices);
+        public unsafe static Vector<int> GatherVectorByteZeroExtend(Vector<int> mask, byte* address, Vector<int> indices);
+        public unsafe static Vector<int> GatherVectorByteZeroExtend(Vector<int> mask, byte* address, Vector<uint> indices);
+        public unsafe static Vector<long> GatherVectorByteZeroExtend(Vector<long> mask, byte* address, Vector<long> indices);
+        public unsafe static Vector<long> GatherVectorByteZeroExtend(Vector<long> mask, byte* address, Vector<ulong> indices);
+        public static Vector<long> GatherVectorByteZeroExtend(Vector<long> mask, Vector<ulong> addresses);
+        public unsafe static Vector<uint> GatherVectorByteZeroExtend(Vector<uint> mask, byte* address, Vector<int> indices);
+        public unsafe static Vector<uint> GatherVectorByteZeroExtend(Vector<uint> mask, byte* address, Vector<uint> indices);
+        public unsafe static Vector<ulong> GatherVectorByteZeroExtend(Vector<ulong> mask, byte* address, Vector<long> indices);
+        public unsafe static Vector<ulong> GatherVectorByteZeroExtend(Vector<ulong> mask, byte* address, Vector<ulong> indices);
+        public static Vector<ulong> GatherVectorByteZeroExtend(Vector<ulong> mask, Vector<ulong> addresses);
+        public unsafe static Vector<int> GatherVectorInt16SignExtend(Vector<int> mask, short* address, Vector<int> indices);
+        public unsafe static Vector<int> GatherVectorInt16SignExtend(Vector<int> mask, short* address, Vector<uint> indices);
+        public unsafe static Vector<long> GatherVectorInt16SignExtend(Vector<long> mask, short* address, Vector<long> indices);
+        public unsafe static Vector<long> GatherVectorInt16SignExtend(Vector<long> mask, short* address, Vector<ulong> indices);
+        public static Vector<long> GatherVectorInt16SignExtend(Vector<long> mask, Vector<ulong> addresses);
+        public unsafe static Vector<uint> GatherVectorInt16SignExtend(Vector<uint> mask, short* address, Vector<int> indices);
+        public unsafe static Vector<uint> GatherVectorInt16SignExtend(Vector<uint> mask, short* address, Vector<uint> indices);
+        public unsafe static Vector<ulong> GatherVectorInt16SignExtend(Vector<ulong> mask, short* address, Vector<long> indices);
+        public unsafe static Vector<ulong> GatherVectorInt16SignExtend(Vector<ulong> mask, short* address, Vector<ulong> indices);
+        public static Vector<ulong> GatherVectorInt16SignExtend(Vector<ulong> mask, Vector<ulong> addresses);
+        public unsafe static Vector<int> GatherVectorInt16WithByteOffsetsSignExtend(Vector<int> mask, short* address, Vector<int> offsets);
+        public unsafe static Vector<int> GatherVectorInt16WithByteOffsetsSignExtend(Vector<int> mask, short* address, Vector<uint> offsets);
+        public unsafe static Vector<long> GatherVectorInt16WithByteOffsetsSignExtend(Vector<long> mask, short* address, Vector<long> offsets);
+        public unsafe static Vector<long> GatherVectorInt16WithByteOffsetsSignExtend(Vector<long> mask, short* address, Vector<ulong> offsets);
+        public unsafe static Vector<uint> GatherVectorInt16WithByteOffsetsSignExtend(Vector<uint> mask, short* address, Vector<int> offsets);
+        public unsafe static Vector<uint> GatherVectorInt16WithByteOffsetsSignExtend(Vector<uint> mask, short* address, Vector<uint> offsets);
+        public unsafe static Vector<ulong> GatherVectorInt16WithByteOffsetsSignExtend(Vector<ulong> mask, short* address, Vector<long> offsets);
+        public unsafe static Vector<ulong> GatherVectorInt16WithByteOffsetsSignExtend(Vector<ulong> mask, short* address, Vector<ulong> offsets);
+        public unsafe static Vector<long> GatherVectorInt32SignExtend(Vector<long> mask, int* address, Vector<long> indices);
+        public unsafe static Vector<long> GatherVectorInt32SignExtend(Vector<long> mask, int* address, Vector<ulong> indices);
+        public static Vector<long> GatherVectorInt32SignExtend(Vector<long> mask, Vector<ulong> addresses);
+        public unsafe static Vector<ulong> GatherVectorInt32SignExtend(Vector<ulong> mask, int* address, Vector<long> indices);
+        public unsafe static Vector<ulong> GatherVectorInt32SignExtend(Vector<ulong> mask, int* address, Vector<ulong> indices);
+        public static Vector<ulong> GatherVectorInt32SignExtend(Vector<ulong> mask, Vector<ulong> addresses);
+        public unsafe static Vector<long> GatherVectorInt32WithByteOffsetsSignExtend(Vector<long> mask, int* address, Vector<long> offsets);
+        public unsafe static Vector<long> GatherVectorInt32WithByteOffsetsSignExtend(Vector<long> mask, int* address, Vector<ulong> offsets);
+        public unsafe static Vector<ulong> GatherVectorInt32WithByteOffsetsSignExtend(Vector<ulong> mask, int* address, Vector<long> offsets);
+        public unsafe static Vector<ulong> GatherVectorInt32WithByteOffsetsSignExtend(Vector<ulong> mask, int* address, Vector<ulong> offsets);
+        public unsafe static Vector<int> GatherVectorSByteSignExtend(Vector<int> mask, sbyte* address, Vector<int> indices);
+        public unsafe static Vector<int> GatherVectorSByteSignExtend(Vector<int> mask, sbyte* address, Vector<uint> indices);
+        public static Vector<long> GatherVectorSByteSignExtend(Vector<long> mask, Vector<ulong> addresses);
+        public unsafe static Vector<long> GatherVectorSByteSignExtend(Vector<long> mask, sbyte* address, Vector<long> indices);
+        public unsafe static Vector<long> GatherVectorSByteSignExtend(Vector<long> mask, sbyte* address, Vector<ulong> indices);
+        public unsafe static Vector<uint> GatherVectorSByteSignExtend(Vector<uint> mask, sbyte* address, Vector<int> indices);
+        public unsafe static Vector<uint> GatherVectorSByteSignExtend(Vector<uint> mask, sbyte* address, Vector<uint> indices);
+        public static Vector<ulong> GatherVectorSByteSignExtend(Vector<ulong> mask, Vector<ulong> addresses);
+        public unsafe static Vector<ulong> GatherVectorSByteSignExtend(Vector<ulong> mask, sbyte* address, Vector<long> indices);
+        public unsafe static Vector<ulong> GatherVectorSByteSignExtend(Vector<ulong> mask, sbyte* address, Vector<ulong> indices);
+        public unsafe static Vector<int> GatherVectorUInt16WithByteOffsetsZeroExtend(Vector<int> mask, ushort* address, Vector<int> offsets);
+        public unsafe static Vector<int> GatherVectorUInt16WithByteOffsetsZeroExtend(Vector<int> mask, ushort* address, Vector<uint> offsets);
+        public unsafe static Vector<long> GatherVectorUInt16WithByteOffsetsZeroExtend(Vector<long> mask, ushort* address, Vector<long> offsets);
+        public unsafe static Vector<long> GatherVectorUInt16WithByteOffsetsZeroExtend(Vector<long> mask, ushort* address, Vector<ulong> offsets);
+        public unsafe static Vector<uint> GatherVectorUInt16WithByteOffsetsZeroExtend(Vector<uint> mask, ushort* address, Vector<int> offsets);
+        public unsafe static Vector<uint> GatherVectorUInt16WithByteOffsetsZeroExtend(Vector<uint> mask, ushort* address, Vector<uint> offsets);
+        public unsafe static Vector<ulong> GatherVectorUInt16WithByteOffsetsZeroExtend(Vector<ulong> mask, ushort* address, Vector<long> offsets);
+        public unsafe static Vector<ulong> GatherVectorUInt16WithByteOffsetsZeroExtend(Vector<ulong> mask, ushort* address, Vector<ulong> offsets);
+        public unsafe static Vector<int> GatherVectorUInt16ZeroExtend(Vector<int> mask, ushort* address, Vector<int> indices);
+        public unsafe static Vector<int> GatherVectorUInt16ZeroExtend(Vector<int> mask, ushort* address, Vector<uint> indices);
+        public static Vector<long> GatherVectorUInt16ZeroExtend(Vector<long> mask, Vector<ulong> addresses);
+        public unsafe static Vector<long> GatherVectorUInt16ZeroExtend(Vector<long> mask, ushort* address, Vector<long> indices);
+        public unsafe static Vector<long> GatherVectorUInt16ZeroExtend(Vector<long> mask, ushort* address, Vector<ulong> indices);
+        public unsafe static Vector<uint> GatherVectorUInt16ZeroExtend(Vector<uint> mask, ushort* address, Vector<int> indices);
+        public unsafe static Vector<uint> GatherVectorUInt16ZeroExtend(Vector<uint> mask, ushort* address, Vector<uint> indices);
+        public static Vector<ulong> GatherVectorUInt16ZeroExtend(Vector<ulong> mask, Vector<ulong> addresses);
+        public unsafe static Vector<ulong> GatherVectorUInt16ZeroExtend(Vector<ulong> mask, ushort* address, Vector<long> indices);
+        public unsafe static Vector<ulong> GatherVectorUInt16ZeroExtend(Vector<ulong> mask, ushort* address, Vector<ulong> indices);
+        public unsafe static Vector<int> GatherVectorUInt32WithByteOffsetsZeroExtend(Vector<int> mask, uint* address, Vector<int> offsets);
+        public unsafe static Vector<int> GatherVectorUInt32WithByteOffsetsZeroExtend(Vector<int> mask, uint* address, Vector<uint> offsets);
+        public unsafe static Vector<long> GatherVectorUInt32WithByteOffsetsZeroExtend(Vector<long> mask, uint* address, Vector<long> offsets);
+        public unsafe static Vector<long> GatherVectorUInt32WithByteOffsetsZeroExtend(Vector<long> mask, uint* address, Vector<ulong> offsets);
+        public unsafe static Vector<uint> GatherVectorUInt32WithByteOffsetsZeroExtend(Vector<uint> mask, uint* address, Vector<int> offsets);
+        public unsafe static Vector<uint> GatherVectorUInt32WithByteOffsetsZeroExtend(Vector<uint> mask, uint* address, Vector<uint> offsets);
+        public unsafe static Vector<ulong> GatherVectorUInt32WithByteOffsetsZeroExtend(Vector<ulong> mask, uint* address, Vector<long> offsets);
+        public unsafe static Vector<ulong> GatherVectorUInt32WithByteOffsetsZeroExtend(Vector<ulong> mask, uint* address, Vector<ulong> offsets);
+        public unsafe static Vector<int> GatherVectorUInt32ZeroExtend(Vector<int> mask, uint* address, Vector<int> indices);
+        public unsafe static Vector<int> GatherVectorUInt32ZeroExtend(Vector<int> mask, uint* address, Vector<uint> indices);
+        public static Vector<long> GatherVectorUInt32ZeroExtend(Vector<long> mask, Vector<ulong> addresses);
+        public unsafe static Vector<long> GatherVectorUInt32ZeroExtend(Vector<long> mask, uint* address, Vector<long> indices);
+        public unsafe static Vector<long> GatherVectorUInt32ZeroExtend(Vector<long> mask, uint* address, Vector<ulong> indices);
+        public unsafe static Vector<uint> GatherVectorUInt32ZeroExtend(Vector<uint> mask, uint* address, Vector<int> indices);
+        public unsafe static Vector<uint> GatherVectorUInt32ZeroExtend(Vector<uint> mask, uint* address, Vector<uint> indices);
+        public static Vector<ulong> GatherVectorUInt32ZeroExtend(Vector<ulong> mask, Vector<ulong> addresses);
+        public unsafe static Vector<ulong> GatherVectorUInt32ZeroExtend(Vector<ulong> mask, uint* address, Vector<long> indices);
+        public unsafe static Vector<ulong> GatherVectorUInt32ZeroExtend(Vector<ulong> mask, uint* address, Vector<ulong> indices);
+        public unsafe static Vector<double> GatherVectorWithByteOffsets(Vector<double> mask, double* address, Vector<long> offsets);
+        public unsafe static Vector<double> GatherVectorWithByteOffsets(Vector<double> mask, double* address, Vector<ulong> offsets);
+        public unsafe static Vector<int> GatherVectorWithByteOffsets(Vector<int> mask, int* address, Vector<int> offsets);
+        public unsafe static Vector<int> GatherVectorWithByteOffsets(Vector<int> mask, int* address, Vector<uint> offsets);
+        public unsafe static Vector<long> GatherVectorWithByteOffsets(Vector<long> mask, long* address, Vector<long> offsets);
+        public unsafe static Vector<long> GatherVectorWithByteOffsets(Vector<long> mask, long* address, Vector<ulong> offsets);
+        public unsafe static Vector<float> GatherVectorWithByteOffsets(Vector<float> mask, float* address, Vector<int> offsets);
+        public unsafe static Vector<float> GatherVectorWithByteOffsets(Vector<float> mask, float* address, Vector<uint> offsets);
+        public unsafe static Vector<uint> GatherVectorWithByteOffsets(Vector<uint> mask, uint* address, Vector<int> offsets);
+        public unsafe static Vector<uint> GatherVectorWithByteOffsets(Vector<uint> mask, uint* address, Vector<uint> offsets);
+        public unsafe static Vector<ulong> GatherVectorWithByteOffsets(Vector<ulong> mask, ulong* address, Vector<long> offsets);
+        public unsafe static Vector<ulong> GatherVectorWithByteOffsets(Vector<ulong> mask, ulong* address, Vector<ulong> offsets);
+        public static ulong GetActiveElementCount(Vector<byte> mask, Vector<byte> from);
+        public static ulong GetActiveElementCount(Vector<double> mask, Vector<double> from);
+        public static ulong GetActiveElementCount(Vector<short> mask, Vector<short> from);
+        public static ulong GetActiveElementCount(Vector<int> mask, Vector<int> from);
+        public static ulong GetActiveElementCount(Vector<long> mask, Vector<long> from);
+        public static ulong GetActiveElementCount(Vector<sbyte> mask, Vector<sbyte> from);
+        public static ulong GetActiveElementCount(Vector<float> mask, Vector<float> from);
+        public static ulong GetActiveElementCount(Vector<ushort> mask, Vector<ushort> from);
+        public static ulong GetActiveElementCount(Vector<uint> mask, Vector<uint> from);
+        public static ulong GetActiveElementCount(Vector<ulong> mask, Vector<ulong> from);
+        public static Vector<ushort> LeadingSignCount(Vector<short> value);
+        public static Vector<uint> LeadingSignCount(Vector<int> value);
+        public static Vector<ulong> LeadingSignCount(Vector<long> value);
+        public static Vector<byte> LeadingSignCount(Vector<sbyte> value);
+        public static Vector<byte> LeadingZeroCount(Vector<byte> value);
+        public static Vector<ushort> LeadingZeroCount(Vector<short> value);
+        public static Vector<uint> LeadingZeroCount(Vector<int> value);
+        public static Vector<ulong> LeadingZeroCount(Vector<long> value);
+        public static Vector<byte> LeadingZeroCount(Vector<sbyte> value);
+        public static Vector<ushort> LeadingZeroCount(Vector<ushort> value);
+        public static Vector<uint> LeadingZeroCount(Vector<uint> value);
+        public static Vector<ulong> LeadingZeroCount(Vector<ulong> value);
+        public unsafe static (Vector<byte>, Vector<byte>) Load2xVectorAndUnzip(Vector<byte> mask, byte* address);
+        public unsafe static (Vector<double>, Vector<double>) Load2xVectorAndUnzip(Vector<double> mask, double* address);
+        public unsafe static (Vector<short>, Vector<short>) Load2xVectorAndUnzip(Vector<short> mask, short* address);
+        public unsafe static (Vector<int>, Vector<int>) Load2xVectorAndUnzip(Vector<int> mask, int* address);
+        public unsafe static (Vector<long>, Vector<long>) Load2xVectorAndUnzip(Vector<long> mask, long* address);
+        public unsafe static (Vector<sbyte>, Vector<sbyte>) Load2xVectorAndUnzip(Vector<sbyte> mask, sbyte* address);
+        public unsafe static (Vector<float>, Vector<float>) Load2xVectorAndUnzip(Vector<float> mask, float* address);
+        public unsafe static (Vector<ushort>, Vector<ushort>) Load2xVectorAndUnzip(Vector<ushort> mask, ushort* address);
+        public unsafe static (Vector<uint>, Vector<uint>) Load2xVectorAndUnzip(Vector<uint> mask, uint* address);
+        public unsafe static (Vector<ulong>, Vector<ulong>) Load2xVectorAndUnzip(Vector<ulong> mask, ulong* address);
+        public unsafe static (Vector<byte>, Vector<byte>, Vector<byte>) Load3xVectorAndUnzip(Vector<byte> mask, byte* address);
+        public unsafe static (Vector<double>, Vector<double>, Vector<double>) Load3xVectorAndUnzip(Vector<double> mask, double* address);
+        public unsafe static (Vector<short>, Vector<short>, Vector<short>) Load3xVectorAndUnzip(Vector<short> mask, short* address);
+        public unsafe static (Vector<int>, Vector<int>, Vector<int>) Load3xVectorAndUnzip(Vector<int> mask, int* address);
+        public unsafe static (Vector<long>, Vector<long>, Vector<long>) Load3xVectorAndUnzip(Vector<long> mask, long* address);
+        public unsafe static (Vector<sbyte>, Vector<sbyte>, Vector<sbyte>) Load3xVectorAndUnzip(Vector<sbyte> mask, sbyte* address);
+        public unsafe static (Vector<float>, Vector<float>, Vector<float>) Load3xVectorAndUnzip(Vector<float> mask, float* address);
+        public unsafe static (Vector<ushort>, Vector<ushort>, Vector<ushort>) Load3xVectorAndUnzip(Vector<ushort> mask, ushort* address);
+        public unsafe static (Vector<uint>, Vector<uint>, Vector<uint>) Load3xVectorAndUnzip(Vector<uint> mask, uint* address);
+        public unsafe static (Vector<ulong>, Vector<ulong>, Vector<ulong>) Load3xVectorAndUnzip(Vector<ulong> mask, ulong* address);
+        public unsafe static (Vector<byte>, Vector<byte>, Vector<byte>, Vector<byte>) Load4xVectorAndUnzip(Vector<byte> mask, byte* address);
+        public unsafe static (Vector<double>, Vector<double>, Vector<double>, Vector<double>) Load4xVectorAndUnzip(Vector<double> mask, double* address);
+        public unsafe static (Vector<short>, Vector<short>, Vector<short>, Vector<short>) Load4xVectorAndUnzip(Vector<short> mask, short* address);
+        public unsafe static (Vector<int>, Vector<int>, Vector<int>, Vector<int>) Load4xVectorAndUnzip(Vector<int> mask, int* address);
+        public unsafe static (Vector<long>, Vector<long>, Vector<long>, Vector<long>) Load4xVectorAndUnzip(Vector<long> mask, long* address);
+        public unsafe static (Vector<sbyte>, Vector<sbyte>, Vector<sbyte>, Vector<sbyte>) Load4xVectorAndUnzip(Vector<sbyte> mask, sbyte* address);
+        public unsafe static (Vector<float>, Vector<float>, Vector<float>, Vector<float>) Load4xVectorAndUnzip(Vector<float> mask, float* address);
+        public unsafe static (Vector<ushort>, Vector<ushort>, Vector<ushort>, Vector<ushort>) Load4xVectorAndUnzip(Vector<ushort> mask, ushort* address);
+        public unsafe static (Vector<uint>, Vector<uint>, Vector<uint>, Vector<uint>) Load4xVectorAndUnzip(Vector<uint> mask, uint* address);
+        public unsafe static (Vector<ulong>, Vector<ulong>, Vector<ulong>, Vector<ulong>) Load4xVectorAndUnzip(Vector<ulong> mask, ulong* address);
+        public unsafe static Vector<byte> LoadVector128AndReplicateToVector(Vector<byte> mask, byte* address);
+        public unsafe static Vector<double> LoadVector128AndReplicateToVector(Vector<double> mask, double* address);
+        public unsafe static Vector<short> LoadVector128AndReplicateToVector(Vector<short> mask, short* address);
+        public unsafe static Vector<int> LoadVector128AndReplicateToVector(Vector<int> mask, int* address);
+        public unsafe static Vector<long> LoadVector128AndReplicateToVector(Vector<long> mask, long* address);
+        public unsafe static Vector<sbyte> LoadVector128AndReplicateToVector(Vector<sbyte> mask, sbyte* address);
+        public unsafe static Vector<float> LoadVector128AndReplicateToVector(Vector<float> mask, float* address);
+        public unsafe static Vector<ushort> LoadVector128AndReplicateToVector(Vector<ushort> mask, ushort* address);
+        public unsafe static Vector<uint> LoadVector128AndReplicateToVector(Vector<uint> mask, uint* address);
+        public unsafe static Vector<ulong> LoadVector128AndReplicateToVector(Vector<ulong> mask, ulong* address);
+        public unsafe static Vector<short> LoadVectorByteNonFaultingZeroExtendToInt16(byte* address);
+        public unsafe static Vector<int> LoadVectorByteNonFaultingZeroExtendToInt32(byte* address);
+        public unsafe static Vector<long> LoadVectorByteNonFaultingZeroExtendToInt64(byte* address);
+        public unsafe static Vector<ushort> LoadVectorByteNonFaultingZeroExtendToUInt16(byte* address);
+        public unsafe static Vector<uint> LoadVectorByteNonFaultingZeroExtendToUInt32(byte* address);
+        public unsafe static Vector<ulong> LoadVectorByteNonFaultingZeroExtendToUInt64(byte* address);
+        public unsafe static Vector<int> LoadVectorInt16NonFaultingSignExtendToInt32(short* address);
+        public unsafe static Vector<long> LoadVectorInt16NonFaultingSignExtendToInt64(short* address);
+        public unsafe static Vector<uint> LoadVectorInt16NonFaultingSignExtendToUInt32(short* address);
+        public unsafe static Vector<ulong> LoadVectorInt16NonFaultingSignExtendToUInt64(short* address);
+        public unsafe static Vector<long> LoadVectorInt32NonFaultingSignExtendToInt64(int* address);
+        public unsafe static Vector<ulong> LoadVectorInt32NonFaultingSignExtendToUInt64(int* address);
+        public unsafe static Vector<byte> LoadVectorNonFaulting(byte* address);
+        public unsafe static Vector<double> LoadVectorNonFaulting(double* address);
+        public unsafe static Vector<short> LoadVectorNonFaulting(short* address);
+        public unsafe static Vector<int> LoadVectorNonFaulting(int* address);
+        public unsafe static Vector<long> LoadVectorNonFaulting(long* address);
+        public unsafe static Vector<sbyte> LoadVectorNonFaulting(sbyte* address);
+        public unsafe static Vector<float> LoadVectorNonFaulting(float* address);
+        public unsafe static Vector<ushort> LoadVectorNonFaulting(ushort* address);
+        public unsafe static Vector<uint> LoadVectorNonFaulting(uint* address);
+        public unsafe static Vector<ulong> LoadVectorNonFaulting(ulong* address);
+        public unsafe static Vector<byte> LoadVectorNonTemporal(Vector<byte> mask, byte* address);
+        public unsafe static Vector<double> LoadVectorNonTemporal(Vector<double> mask, double* address);
+        public unsafe static Vector<short> LoadVectorNonTemporal(Vector<short> mask, short* address);
+        public unsafe static Vector<int> LoadVectorNonTemporal(Vector<int> mask, int* address);
+        public unsafe static Vector<long> LoadVectorNonTemporal(Vector<long> mask, long* address);
+        public unsafe static Vector<sbyte> LoadVectorNonTemporal(Vector<sbyte> mask, sbyte* address);
+        public unsafe static Vector<float> LoadVectorNonTemporal(Vector<float> mask, float* address);
+        public unsafe static Vector<ushort> LoadVectorNonTemporal(Vector<ushort> mask, ushort* address);
+        public unsafe static Vector<uint> LoadVectorNonTemporal(Vector<uint> mask, uint* address);
+        public unsafe static Vector<ulong> LoadVectorNonTemporal(Vector<ulong> mask, ulong* address);
+        public unsafe static Vector<short> LoadVectorSByteNonFaultingSignExtendToInt16(sbyte* address);
+        public unsafe static Vector<int> LoadVectorSByteNonFaultingSignExtendToInt32(sbyte* address);
+        public unsafe static Vector<long> LoadVectorSByteNonFaultingSignExtendToInt64(sbyte* address);
+        public unsafe static Vector<ushort> LoadVectorSByteNonFaultingSignExtendToUInt16(sbyte* address);
+        public unsafe static Vector<uint> LoadVectorSByteNonFaultingSignExtendToUInt32(sbyte* address);
+        public unsafe static Vector<ulong> LoadVectorSByteNonFaultingSignExtendToUInt64(sbyte* address);
+        public unsafe static Vector<int> LoadVectorUInt16NonFaultingZeroExtendToInt32(ushort* address);
+        public unsafe static Vector<long> LoadVectorUInt16NonFaultingZeroExtendToInt64(ushort* address);
+        public unsafe static Vector<uint> LoadVectorUInt16NonFaultingZeroExtendToUInt32(ushort* address);
+        public unsafe static Vector<ulong> LoadVectorUInt16NonFaultingZeroExtendToUInt64(ushort* address);
+        public unsafe static Vector<long> LoadVectorUInt32NonFaultingZeroExtendToInt64(uint* address);
+        public unsafe static Vector<ulong> LoadVectorUInt32NonFaultingZeroExtendToUInt64(uint* address);
+        public static Vector<byte> PopCount(Vector<byte> value);
+        public static Vector<ulong> PopCount(Vector<double> value);
+        public static Vector<ushort> PopCount(Vector<short> value);
+        public static Vector<uint> PopCount(Vector<int> value);
+        public static Vector<ulong> PopCount(Vector<long> value);
+        public static Vector<byte> PopCount(Vector<sbyte> value);
+        public static Vector<uint> PopCount(Vector<float> value);
+        public static Vector<ushort> PopCount(Vector<ushort> value);
+        public static Vector<uint> PopCount(Vector<uint> value);
+        public static Vector<ulong> PopCount(Vector<ulong> value);
+        public unsafe static void PrefetchBytes(Vector<byte> mask, void* address, SvePrefetchType prefetchType);
+        public unsafe static void PrefetchInt16(Vector<ushort> mask, void* address, SvePrefetchType prefetchType);
+        public unsafe static void PrefetchInt32(Vector<uint> mask, void* address, SvePrefetchType prefetchType);
+        public unsafe static void PrefetchInt64(Vector<ulong> mask, void* address, SvePrefetchType prefetchType);
+        public static Vector<byte> ReverseElement(Vector<byte> value);
+        public static Vector<double> ReverseElement(Vector<double> value);
+        public static Vector<short> ReverseElement(Vector<short> value);
+        public static Vector<int> ReverseElement(Vector<int> value);
+        public static Vector<long> ReverseElement(Vector<long> value);
+        public static Vector<sbyte> ReverseElement(Vector<sbyte> value);
+        public static Vector<float> ReverseElement(Vector<float> value);
+        public static Vector<ushort> ReverseElement(Vector<ushort> value);
+        public static Vector<uint> ReverseElement(Vector<uint> value);
+        public static Vector<ulong> ReverseElement(Vector<ulong> value);
+        public static Vector<int> ReverseElement16(Vector<int> value);
+        public static Vector<long> ReverseElement16(Vector<long> value);
+        public static Vector<uint> ReverseElement16(Vector<uint> value);
+        public static Vector<ulong> ReverseElement16(Vector<ulong> value);
+        public static Vector<long> ReverseElement32(Vector<long> value);
+        public static Vector<ulong> ReverseElement32(Vector<ulong> value);
+        public static Vector<short> ReverseElement8(Vector<short> value);
+        public static Vector<int> ReverseElement8(Vector<int> value);
+        public static Vector<long> ReverseElement8(Vector<long> value);
+        public static Vector<ushort> ReverseElement8(Vector<ushort> value);
+        public static Vector<uint> ReverseElement8(Vector<uint> value);
+        public static Vector<ulong> ReverseElement8(Vector<ulong> value);
+        public static Vector<double> RoundAwayFromZero(Vector<double> value);
+        public static Vector<float> RoundAwayFromZero(Vector<float> value);
+        public static Vector<double> RoundToNearest(Vector<double> value);
+        public static Vector<float> RoundToNearest(Vector<float> value);
+        public static Vector<double> RoundToNegativeInfinity(Vector<double> value);
+        public static Vector<float> RoundToNegativeInfinity(Vector<float> value);
+        public static Vector<double> RoundToPositiveInfinity(Vector<double> value);
+        public static Vector<float> RoundToPositiveInfinity(Vector<float> value);
+        public static Vector<double> RoundToZero(Vector<double> value);
+        public static Vector<float> RoundToZero(Vector<float> value);
+        public static int SaturatingDecrementBy16BitElementCount(int value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static long SaturatingDecrementBy16BitElementCount(long value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<short> SaturatingDecrementBy16BitElementCount(Vector<short> value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<ushort> SaturatingDecrementBy16BitElementCount(Vector<ushort> value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static uint SaturatingDecrementBy16BitElementCount(uint value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static ulong SaturatingDecrementBy16BitElementCount(ulong value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static int SaturatingDecrementBy32BitElementCount(int value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static long SaturatingDecrementBy32BitElementCount(long value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<int> SaturatingDecrementBy32BitElementCount(Vector<int> value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<uint> SaturatingDecrementBy32BitElementCount(Vector<uint> value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static uint SaturatingDecrementBy32BitElementCount(uint value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static ulong SaturatingDecrementBy32BitElementCount(ulong value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static int SaturatingDecrementBy64BitElementCount(int value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static long SaturatingDecrementBy64BitElementCount(long value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<long> SaturatingDecrementBy64BitElementCount(Vector<long> value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<ulong> SaturatingDecrementBy64BitElementCount(Vector<ulong> value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static uint SaturatingDecrementBy64BitElementCount(uint value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static ulong SaturatingDecrementBy64BitElementCount(ulong value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static int SaturatingDecrementBy8BitElementCount(int value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static long SaturatingDecrementBy8BitElementCount(long value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static uint SaturatingDecrementBy8BitElementCount(uint value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static ulong SaturatingDecrementBy8BitElementCount(ulong value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static long SaturatingDecrementByActiveElementCount(int value, Vector<byte> from);
+        public static long SaturatingDecrementByActiveElementCount(int value, Vector<ushort> from);
+        public static long SaturatingDecrementByActiveElementCount(int value, Vector<uint> from);
+        public static long SaturatingDecrementByActiveElementCount(int value, Vector<ulong> from);
+        public static long SaturatingDecrementByActiveElementCount(long value, Vector<byte> from);
+        public static long SaturatingDecrementByActiveElementCount(long value, Vector<ushort> from);
+        public static long SaturatingDecrementByActiveElementCount(long value, Vector<uint> from);
+        public static long SaturatingDecrementByActiveElementCount(long value, Vector<ulong> from);
+        public static Vector<short> SaturatingDecrementByActiveElementCount(Vector<short> value, Vector<short> from);
+        public static Vector<int> SaturatingDecrementByActiveElementCount(Vector<int> value, Vector<int> from);
+        public static Vector<long> SaturatingDecrementByActiveElementCount(Vector<long> value, Vector<long> from);
+        public static Vector<ushort> SaturatingDecrementByActiveElementCount(Vector<ushort> value, Vector<ushort> from);
+        public static Vector<uint> SaturatingDecrementByActiveElementCount(Vector<uint> value, Vector<uint> from);
+        public static Vector<ulong> SaturatingDecrementByActiveElementCount(Vector<ulong> value, Vector<ulong> from);
+        public static ulong SaturatingDecrementByActiveElementCount(uint value, Vector<byte> from);
+        public static ulong SaturatingDecrementByActiveElementCount(uint value, Vector<ushort> from);
+        public static ulong SaturatingDecrementByActiveElementCount(uint value, Vector<uint> from);
+        public static ulong SaturatingDecrementByActiveElementCount(uint value, Vector<ulong> from);
+        public static ulong SaturatingDecrementByActiveElementCount(ulong value, Vector<byte> from);
+        public static ulong SaturatingDecrementByActiveElementCount(ulong value, Vector<ushort> from);
+        public static ulong SaturatingDecrementByActiveElementCount(ulong value, Vector<uint> from);
+        public static ulong SaturatingDecrementByActiveElementCount(ulong value, Vector<ulong> from);
+        public static int SaturatingIncrementBy16BitElementCount(int value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static long SaturatingIncrementBy16BitElementCount(long value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<short> SaturatingIncrementBy16BitElementCount(Vector<short> value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<ushort> SaturatingIncrementBy16BitElementCount(Vector<ushort> value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static uint SaturatingIncrementBy16BitElementCount(uint value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static ulong SaturatingIncrementBy16BitElementCount(ulong value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static int SaturatingIncrementBy32BitElementCount(int value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static long SaturatingIncrementBy32BitElementCount(long value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<int> SaturatingIncrementBy32BitElementCount(Vector<int> value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<uint> SaturatingIncrementBy32BitElementCount(Vector<uint> value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static uint SaturatingIncrementBy32BitElementCount(uint value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static ulong SaturatingIncrementBy32BitElementCount(ulong value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static int SaturatingIncrementBy64BitElementCount(int value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static long SaturatingIncrementBy64BitElementCount(long value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<long> SaturatingIncrementBy64BitElementCount(Vector<long> value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static Vector<ulong> SaturatingIncrementBy64BitElementCount(Vector<ulong> value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static uint SaturatingIncrementBy64BitElementCount(uint value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static ulong SaturatingIncrementBy64BitElementCount(ulong value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static int SaturatingIncrementBy8BitElementCount(int value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static long SaturatingIncrementBy8BitElementCount(long value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static uint SaturatingIncrementBy8BitElementCount(uint value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static ulong SaturatingIncrementBy8BitElementCount(ulong value, byte scale, SveMaskPattern pattern = SveMaskPattern.All);
+        public static long SaturatingIncrementByActiveElementCount(int value, Vector<byte> from);
+        public static long SaturatingIncrementByActiveElementCount(int value, Vector<ushort> from);
+        public static long SaturatingIncrementByActiveElementCount(int value, Vector<uint> from);
+        public static long SaturatingIncrementByActiveElementCount(int value, Vector<ulong> from);
+        public static long SaturatingIncrementByActiveElementCount(long value, Vector<byte> from);
+        public static long SaturatingIncrementByActiveElementCount(long value, Vector<ushort> from);
+        public static long SaturatingIncrementByActiveElementCount(long value, Vector<uint> from);
+        public static long SaturatingIncrementByActiveElementCount(long value, Vector<ulong> from);
+        public static Vector<short> SaturatingIncrementByActiveElementCount(Vector<short> value, Vector<short> from);
+        public static Vector<int> SaturatingIncrementByActiveElementCount(Vector<int> value, Vector<int> from);
+        public static Vector<long> SaturatingIncrementByActiveElementCount(Vector<long> value, Vector<long> from);
+        public static Vector<ushort> SaturatingIncrementByActiveElementCount(Vector<ushort> value, Vector<ushort> from);
+        public static Vector<uint> SaturatingIncrementByActiveElementCount(Vector<uint> value, Vector<uint> from);
+        public static Vector<ulong> SaturatingIncrementByActiveElementCount(Vector<ulong> value, Vector<ulong> from);
+        public static ulong SaturatingIncrementByActiveElementCount(uint value, Vector<byte> from);
+        public static ulong SaturatingIncrementByActiveElementCount(uint value, Vector<ushort> from);
+        public static ulong SaturatingIncrementByActiveElementCount(uint value, Vector<uint> from);
+        public static ulong SaturatingIncrementByActiveElementCount(uint value, Vector<ulong> from);
+        public static ulong SaturatingIncrementByActiveElementCount(ulong value, Vector<byte> from);
+        public static ulong SaturatingIncrementByActiveElementCount(ulong value, Vector<ushort> from);
+        public static ulong SaturatingIncrementByActiveElementCount(ulong value, Vector<uint> from);
+        public static ulong SaturatingIncrementByActiveElementCount(ulong value, Vector<ulong> from);
+        public unsafe static void StoreNarrowing(Vector<short> mask, sbyte* address, Vector<short> data);
+        public unsafe static void StoreNarrowing(Vector<int> mask, short* address, Vector<int> data);
+        public unsafe static void StoreNarrowing(Vector<int> mask, sbyte* address, Vector<int> data);
+        public unsafe static void StoreNarrowing(Vector<long> mask, short* address, Vector<long> data);
+        public unsafe static void StoreNarrowing(Vector<long> mask, int* address, Vector<long> data);
+        public unsafe static void StoreNarrowing(Vector<long> mask, sbyte* address, Vector<long> data);
+        public unsafe static void StoreNarrowing(Vector<ushort> mask, byte* address, Vector<ushort> data);
+        public unsafe static void StoreNarrowing(Vector<uint> mask, byte* address, Vector<uint> data);
+        public unsafe static void StoreNarrowing(Vector<uint> mask, ushort* address, Vector<uint> data);
+        public unsafe static void StoreNarrowing(Vector<ulong> mask, byte* address, Vector<ulong> data);
+        public unsafe static void StoreNarrowing(Vector<ulong> mask, ushort* address, Vector<ulong> data);
+        public unsafe static void StoreNarrowing(Vector<ulong> mask, uint* address, Vector<ulong> data);
+        public unsafe static void StoreNonTemporal(Vector<byte> mask, byte* address, Vector<byte> data);
+        public unsafe static void StoreNonTemporal(Vector<double> mask, double* address, Vector<double> data);
+        public unsafe static void StoreNonTemporal(Vector<short> mask, short* address, Vector<short> data);
+        public unsafe static void StoreNonTemporal(Vector<int> mask, int* address, Vector<int> data);
+        public unsafe static void StoreNonTemporal(Vector<long> mask, long* address, Vector<long> data);
+        public unsafe static void StoreNonTemporal(Vector<sbyte> mask, sbyte* address, Vector<sbyte> data);
+        public unsafe static void StoreNonTemporal(Vector<float> mask, float* address, Vector<float> data);
+        public unsafe static void StoreNonTemporal(Vector<ushort> mask, ushort* address, Vector<ushort> data);
+        public unsafe static void StoreNonTemporal(Vector<uint> mask, uint* address, Vector<uint> data);
+        public unsafe static void StoreNonTemporal(Vector<ulong> mask, ulong* address, Vector<ulong> data);
+        public static Vector<byte> TransposeEven(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> TransposeEven(Vector<double> left, Vector<double> right);
+        public static Vector<short> TransposeEven(Vector<short> left, Vector<short> right);
+        public static Vector<int> TransposeEven(Vector<int> left, Vector<int> right);
+        public static Vector<long> TransposeEven(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> TransposeEven(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> TransposeEven(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> TransposeEven(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> TransposeEven(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> TransposeEven(Vector<ulong> left, Vector<ulong> right);
+        public static Vector<byte> TransposeOdd(Vector<byte> left, Vector<byte> right);
+        public static Vector<double> TransposeOdd(Vector<double> left, Vector<double> right);
+        public static Vector<short> TransposeOdd(Vector<short> left, Vector<short> right);
+        public static Vector<int> TransposeOdd(Vector<int> left, Vector<int> right);
+        public static Vector<long> TransposeOdd(Vector<long> left, Vector<long> right);
+        public static Vector<sbyte> TransposeOdd(Vector<sbyte> left, Vector<sbyte> right);
+        public static Vector<float> TransposeOdd(Vector<float> left, Vector<float> right);
+        public static Vector<ushort> TransposeOdd(Vector<ushort> left, Vector<ushort> right);
+        public static Vector<uint> TransposeOdd(Vector<uint> left, Vector<uint> right);
+        public static Vector<ulong> TransposeOdd(Vector<ulong> left, Vector<ulong> right);
     }
+    public enum SvePrefetchType : byte {
+        LoadL1NonTemporal = (byte)1,
+        LoadL1Temporal = (byte)0,
+        LoadL2NonTemporal = (byte)3,
+        LoadL2Temporal = (byte)2,
+        LoadL3NonTemporal = (byte)5,
+        LoadL3Temporal = (byte)4,
+        StoreL1NonTemporal = (byte)9,
+        StoreL1Temporal = (byte)8,
+        StoreL2NonTemporal = (byte)11,
+        StoreL2Temporal = (byte)10,
+        StoreL3NonTemporal = (byte)13,
+        StoreL3Temporal = (byte)12,
+    }
 }
```

