# System.Text.Json.Schema

``` diff
+namespace System.Text.Json.Schema {
+    public static class JsonSchemaExporter {
+        public static JsonNode GetJsonSchemaAsNode(this JsonSerializerOptions options, Type type, JsonSchemaExporterOptions? exporterOptions = null);
+        public static JsonNode GetJsonSchemaAsNode(this JsonTypeInfo typeInfo, JsonSchemaExporterOptions? exporterOptions = null);
+    }
+    public readonly struct JsonSchemaExporterContext {
+        public ReadOnlySpan<string> Path { get; }
+        public JsonPropertyInfo? PropertyInfo { get; }
+        public JsonTypeInfo TypeInfo { get; }
+    }
+    public sealed class JsonSchemaExporterOptions {
+        public JsonSchemaExporterOptions();
+        public static JsonSchemaExporterOptions Default { get; }
+        public Func<JsonSchemaExporterContext, JsonNode, JsonNode>? TransformSchemaNode { get; set; }
+        public bool TreatNullObliviousAsNonNullable { get; set; }
+    }
+}
```

