# System.Drawing.Drawing2D

``` diff
 namespace System.Drawing.Drawing2D {
     public sealed class GraphicsPath : MarshalByRefObject, ICloneable, IDisposable {
-        public void AddPolygon(PointF[] points);
+        public void AddPolygon(params PointF[] points);
-        public void AddPolygon(Point[] points);
+        public void AddPolygon(params Point[] points);
-        public void AddRectangles(Rectangle[] rects);
+        public void AddRectangles(params Rectangle[] rects);
     }
     public sealed class Matrix : MarshalByRefObject, IDisposable {
-        public Matrix(Rectangle rect, Point[] plgpts);
+        public Matrix(Rectangle rect, params Point[] plgpts);
-        public Matrix(RectangleF rect, PointF[] plgpts);
+        public Matrix(RectangleF rect, params PointF[] plgpts);
-        public void TransformPoints(PointF[] pts);
+        public void TransformPoints(params PointF[] pts);
-        public void TransformPoints(Point[] pts);
+        public void TransformPoints(params Point[] pts);
+        public void TransformPoints(ReadOnlySpan<Point> pts);
+        public void TransformPoints(ReadOnlySpan<PointF> pts);
-        public void TransformVectors(PointF[] pts);
+        public void TransformVectors(params PointF[] pts);
-        public void TransformVectors(Point[] pts);
+        public void TransformVectors(params Point[] pts);
+        public void TransformVectors(ReadOnlySpan<Point> pts);
+        public void TransformVectors(ReadOnlySpan<PointF> pts);
-        public void VectorTransformPoints(Point[] pts);
+        public void VectorTransformPoints(params Point[] pts);
+        public void VectorTransformPoints(ReadOnlySpan<Point> pts);
     }
     public sealed class PathGradientBrush : Brush {
+        public PathGradientBrush(WrapMode wrapMode, ReadOnlySpan<Point> points);
+        public PathGradientBrush(WrapMode wrapMode, ReadOnlySpan<PointF> points);
-        public PathGradientBrush(PointF[] points);
+        public PathGradientBrush(params PointF[] points);
-        public PathGradientBrush(Point[] points);
+        public PathGradientBrush(params Point[] points);
+        public PathGradientBrush(ReadOnlySpan<Point> points);
+        public PathGradientBrush(ReadOnlySpan<PointF> points);
     }
 }
```

