# System.Formats.Nrbf

``` diff
+namespace System.Formats.Nrbf {
+    public abstract class ArrayRecord : SerializationRecord {
+        public override SerializationRecordId Id { get; }
+        public abstract ReadOnlySpan<int> Lengths { get; }
+        public int Rank { get; }
+        public Array GetArray(Type expectedArrayType, bool allowNulls = true);
+    }
+    public abstract class ClassRecord : SerializationRecord {
+        public override SerializationRecordId Id { get; }
+        public IEnumerable<string> MemberNames { get; }
+        public override TypeName TypeName { get; }
+        public ArrayRecord? GetArrayRecord(string memberName);
+        public bool GetBoolean(string memberName);
+        public byte GetByte(string memberName);
+        public char GetChar(string memberName);
+        public ClassRecord? GetClassRecord(string memberName);
+        public DateTime GetDateTime(string memberName);
+        public decimal GetDecimal(string memberName);
+        public double GetDouble(string memberName);
+        public short GetInt16(string memberName);
+        public int GetInt32(string memberName);
+        public long GetInt64(string memberName);
+        public object? GetRawValue(string memberName);
+        public sbyte GetSByte(string memberName);
+        public SerializationRecord? GetSerializationRecord(string memberName);
+        public float GetSingle(string memberName);
+        public string? GetString(string memberName);
+        public TimeSpan GetTimeSpan(string memberName);
+        public ushort GetUInt16(string memberName);
+        public uint GetUInt32(string memberName);
+        public ulong GetUInt64(string memberName);
+        public bool HasMember(string memberName);
+    }
+    public static class NrbfDecoder {
+        public static SerializationRecord Decode(Stream payload, out IReadOnlyDictionary<SerializationRecordId, SerializationRecord> recordMap, PayloadOptions options = null, bool leaveOpen = false);
+        public static SerializationRecord Decode(Stream payload, PayloadOptions? options = null, bool leaveOpen = false);
+        public static ClassRecord DecodeClassRecord(Stream payload, PayloadOptions? options = null, bool leaveOpen = false);
+        public static bool StartsWithPayloadHeader(byte[] bytes);
+        public static bool StartsWithPayloadHeader(Stream stream);
+    }
+    public sealed class PayloadOptions {
+        public PayloadOptions();
+        public TypeNameParseOptions TypeNameParseOptions { get; set; }
+        public bool UndoTruncatedTypeNames { get; set; }
+    }
+    public abstract class PrimitiveTypeRecord : SerializationRecord {
+        public object Value { get; }
+    }
+    public abstract class PrimitiveTypeRecord<T> : PrimitiveTypeRecord {
+        public override TypeName TypeName { get; }
+        public new T Value { get; }
+    }
+    public abstract class SerializationRecord {
+        public abstract SerializationRecordId Id { get; }
+        public abstract SerializationRecordType RecordType { get; }
+        public abstract TypeName TypeName { get; }
+        public bool TypeNameMatches(Type type);
+    }
+    public struct SerializationRecordId : IEquatable<SerializationRecordId> {
+        public bool Equals(SerializationRecordId other);
+        public override bool Equals(object? obj);
+        public override int GetHashCode();
+    }
+    public enum SerializationRecordType {
+        ArraySingleObject = 16,
+        ArraySinglePrimitive = 15,
+        ArraySingleString = 17,
+        BinaryArray = 7,
+        BinaryLibrary = 12,
+        BinaryObjectString = 6,
+        ClassWithId = 1,
+        ClassWithMembers = 3,
+        ClassWithMembersAndTypes = 5,
+        MemberPrimitiveTyped = 8,
+        MemberReference = 9,
+        MessageEnd = 11,
+        MethodCall = 21,
+        MethodReturn = 22,
+        ObjectNull = 10,
+        ObjectNullMultiple = 14,
+        ObjectNullMultiple256 = 13,
+        SerializedStreamHeader = 0,
+        SystemClassWithMembers = 2,
+        SystemClassWithMembersAndTypes = 4,
+    }
+    public abstract class SZArrayRecord<T> : ArrayRecord {
+        public int Length { get; }
+        public override ReadOnlySpan<int> Lengths { get; }
+        public abstract T?[] GetArray(bool allowNulls = true);
+    }
+}
```

