# Microsoft.AspNetCore.DataProtection.Repositories

``` diff
 namespace Microsoft.AspNetCore.DataProtection.Repositories {
-    public class FileSystemXmlRepository : IXmlRepository {
+    public class FileSystemXmlRepository : IDeletableXmlRepository, IXmlRepository {
+        public virtual bool DeleteElements(Action<IReadOnlyCollection<IDeletableElement>> chooseElements);
     }
+    public interface IDeletableElement {
+        int? DeletionOrder { get; set; }
+        XElement Element { get; }
+    }
+    public interface IDeletableXmlRepository : IXmlRepository {
+        bool DeleteElements(Action<IReadOnlyCollection<IDeletableElement>> chooseElements);
+    }
-    [SupportedOSPlatformAttribute("windows")]
-    public class RegistryXmlRepository : IXmlRepository {
+    [SupportedOSPlatformAttribute("windows")]
+    public class RegistryXmlRepository : IDeletableXmlRepository, IXmlRepository {
+        public virtual bool DeleteElements(Action<IReadOnlyCollection<IDeletableElement>> chooseElements);
     }
 }
```

