# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
+    [AttributeUsageAttribute(68)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class DisableHttpMetricsAttribute : Attribute, IDisableHttpMetricsMetadata {
+        public DisableHttpMetricsAttribute();
+        public override string ToString();
+    }
     public class HttpValidationProblemDetails : ProblemDetails {
+        public HttpValidationProblemDetails(IEnumerable<KeyValuePair<string, string[]>> errors);
     }
     public static class OpenApiRouteHandlerBuilderExtensions {
+        public static TBuilder ProducesProblem<TBuilder>(this TBuilder builder, int statusCode, string? contentType = null) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder ProducesValidationProblem<TBuilder>(this TBuilder builder, int statusCode = 400, string? contentType = null) where TBuilder : IEndpointConventionBuilder;
     }
     public static class Results {
-        public static IResult Problem(string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IDictionary<string, object?>? extensions = null);
+        public static IResult Problem(string detail, string instance, int? statusCode, string title, string type, IDictionary<string, object?>? extensions);
+        public static IResult Problem(string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IEnumerable<KeyValuePair<string, object?>>? extensions = null);
-        public static IResult ValidationProblem(IDictionary<string, string[]> errors, string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IDictionary<string, object?>? extensions = null);
+        public static IResult ValidationProblem(IDictionary<string, string[]> errors, string detail, string instance, int? statusCode, string title, string type, IDictionary<string, object?>? extensions);
+        public static IResult ValidationProblem(IEnumerable<KeyValuePair<string, string[]>> errors, string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IEnumerable<KeyValuePair<string, object?>>? extensions = null);
     }
     public static class TypedResults {
-        public static ProblemHttpResult Problem(string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IDictionary<string, object?>? extensions = null);
+        public static ProblemHttpResult Problem(string detail, string instance, int? statusCode, string title, string type, IDictionary<string, object?>? extensions);
+        public static ProblemHttpResult Problem(string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IEnumerable<KeyValuePair<string, object?>>? extensions = null);
-        public static ValidationProblem ValidationProblem(IDictionary<string, string[]> errors, string detail = null, string instance = null, string title = null, string type = null, IDictionary<string, object?>? extensions = null);
+        public static ValidationProblem ValidationProblem(IDictionary<string, string[]> errors, string detail, string instance, string title, string type, IDictionary<string, object?>? extensions);
+        public static ValidationProblem ValidationProblem(IEnumerable<KeyValuePair<string, string[]>> errors, string detail = null, string instance = null, string title = null, string type = null, IEnumerable<KeyValuePair<string, object?>>? extensions = null);
     }
 }
```

