# Microsoft.Extensions.Caching.Hybrid

``` diff
+namespace Microsoft.Extensions.Caching.Hybrid {
+    public abstract class HybridCache {
+        protected HybridCache();
+        public ValueTask<T> GetOrCreateAsync<T>(string key, Func<CancellationToken, ValueTask<T>> factory, HybridCacheEntryOptions? options = null, IEnumerable<string>? tags = null, CancellationToken cancellationToken = default(CancellationToken));
+        public abstract ValueTask<T> GetOrCreateAsync<TState, T>(string key, TState state, Func<TState, CancellationToken, ValueTask<T>> factory, HybridCacheEntryOptions? options = null, IEnumerable<string>? tags = null, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual ValueTask RemoveAsync(IEnumerable<string> keys, CancellationToken cancellationToken = default(CancellationToken));
+        public abstract ValueTask RemoveAsync(string key, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual ValueTask RemoveByTagAsync(IEnumerable<string> tags, CancellationToken cancellationToken = default(CancellationToken));
+        public abstract ValueTask RemoveByTagAsync(string tag, CancellationToken cancellationToken = default(CancellationToken));
+        public abstract ValueTask SetAsync<T>(string key, T value, HybridCacheEntryOptions? options = null, IEnumerable<string>? tags = null, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    [FlagsAttribute]
+    public enum HybridCacheEntryFlags {
+        DisableCompression = 32,
+        DisableDistributedCache = 12,
+        DisableDistributedCacheRead = 4,
+        DisableDistributedCacheWrite = 8,
+        DisableLocalCache = 3,
+        DisableLocalCacheRead = 1,
+        DisableLocalCacheWrite = 2,
+        DisableUnderlyingData = 16,
+        None = 0,
+    }
+    public sealed class HybridCacheEntryOptions {
+        public HybridCacheEntryOptions();
+        public TimeSpan? Expiration { get; set; }
+        public HybridCacheEntryFlags? Flags { get; set; }
+        public TimeSpan? LocalCacheExpiration { get; set; }
+    }
+    public interface IHybridCacheSerializer<T> {
+        T Deserialize(ReadOnlySequence<byte> source);
+        void Serialize(T value, IBufferWriter<byte> target);
+    }
+    public interface IHybridCacheSerializerFactory {
+        bool TryCreateSerializer<T>([NotNullWhenAttribute(true)] out IHybridCacheSerializer<T>? serializer);
+    }
+}
```

