# Microsoft.Extensions.DependencyInjection

``` diff
 namespace Microsoft.Extensions.DependencyInjection {
     public static class HttpClientBuilderExtensions {
+        public static IHttpClientBuilder AddAsKeyed(this IHttpClientBuilder builder, ServiceLifetime lifetime = ServiceLifetime.Scoped);
+        public static IHttpClientBuilder RemoveAsKeyed(this IHttpClientBuilder builder);
     }
     public static class MvcApiExplorerMvcCoreBuilderExtensions {
-        public static IMvcCoreBuilder AddApiExplorer(this IMvcCoreBuilder builder);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcCoreBuilder AddApiExplorer(this IMvcCoreBuilder builder);
     }
     public static class SignalRDependencyInjectionExtensions {
-        [RequiresUnreferencedCodeAttribute("SignalR does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
-        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services);
+        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services);
-        [RequiresUnreferencedCodeAttribute("SignalR does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
-        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services, Action<HubOptions> configure);
+        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services, Action<HubOptions> configure);
     }
 }
```

