# System.Diagnostics

``` diff
 namespace System.Diagnostics {
     public static class Debug {
-        [ConditionalAttribute("DEBUG")]
-        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition);
+        [ConditionalAttribute("DEBUG")]
+        [OverloadResolutionPriorityAttribute(-1)]
+        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition);
-        [ConditionalAttribute("DEBUG")]
-        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition, string message);
+        [ConditionalAttribute("DEBUG")]
+        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition, [CallerArgumentExpressionAttribute("condition")] string message = null);
     }
     public static class Debugger {
+        public static void BreakForUserUnhandledException(Exception exception);
     }
+    [AttributeUsageAttribute(AttributeTargets.Method)]
+    public sealed class DebuggerDisableUserUnhandledExceptionsAttribute : Attribute {
+        public DebuggerDisableUserUnhandledExceptionsAttribute();
+    }
     public sealed class Trace {
-        [ConditionalAttribute("TRACE")]
-        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition);
+        [ConditionalAttribute("TRACE")]
+        [OverloadResolutionPriorityAttribute(-1)]
+        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition);
-        [ConditionalAttribute("TRACE")]
-        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition, string message);
+        [ConditionalAttribute("TRACE")]
+        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition, [CallerArgumentExpressionAttribute("condition")] string message = null);
     }
 }
```

