# System.Numerics

``` diff
 namespace System.Numerics {
     public static class Vector {
+        public static Vector<T> Clamp<T>(Vector<T> value, Vector<T> min, Vector<T> max);
+        public static Vector<T> ClampNative<T>(Vector<T> value, Vector<T> min, Vector<T> max);
+        public static Vector<T> CopySign<T>(Vector<T> value, Vector<T> sign);
+        public static Vector<double> Cos(Vector<double> vector);
+        public static Vector<float> Cos(Vector<float> vector);
+        public static Vector<double> DegreesToRadians(Vector<double> degrees);
+        public static Vector<float> DegreesToRadians(Vector<float> degrees);
+        public static Vector<double> Exp(Vector<double> vector);
+        public static Vector<float> Exp(Vector<float> vector);
+        public static Vector<double> Hypot(Vector<double> x, Vector<double> y);
+        public static Vector<float> Hypot(Vector<float> x, Vector<float> y);
+        public static Vector<T> IsNaN<T>(Vector<T> vector);
+        public static Vector<T> IsNegative<T>(Vector<T> vector);
+        public static Vector<T> IsPositive<T>(Vector<T> vector);
+        public static Vector<T> IsPositiveInfinity<T>(Vector<T> vector);
+        public static Vector<T> IsZero<T>(Vector<T> vector);
+        public static Vector<double> Lerp(Vector<double> x, Vector<double> y, Vector<double> amount);
+        public static Vector<float> Lerp(Vector<float> x, Vector<float> y, Vector<float> amount);
+        public static Vector<double> Log(Vector<double> vector);
+        public static Vector<float> Log(Vector<float> vector);
+        public static Vector<double> Log2(Vector<double> vector);
+        public static Vector<float> Log2(Vector<float> vector);
+        public static Vector<T> MaxMagnitude<T>(Vector<T> left, Vector<T> right);
+        public static Vector<T> MaxMagnitudeNumber<T>(Vector<T> left, Vector<T> right);
+        public static Vector<T> MaxNative<T>(Vector<T> left, Vector<T> right);
+        public static Vector<T> MaxNumber<T>(Vector<T> left, Vector<T> right);
+        public static Vector<T> MinMagnitude<T>(Vector<T> left, Vector<T> right);
+        public static Vector<T> MinMagnitudeNumber<T>(Vector<T> left, Vector<T> right);
+        public static Vector<T> MinNative<T>(Vector<T> left, Vector<T> right);
+        public static Vector<T> MinNumber<T>(Vector<T> left, Vector<T> right);
+        public static Vector<double> RadiansToDegrees(Vector<double> radians);
+        public static Vector<float> RadiansToDegrees(Vector<float> radians);
+        public static Vector<double> Round(Vector<double> vector);
+        public static Vector<double> Round(Vector<double> vector, MidpointRounding mode);
+        public static Vector<float> Round(Vector<float> vector);
+        public static Vector<float> Round(Vector<float> vector, MidpointRounding mode);
+        public static Vector<double> Sin(Vector<double> vector);
+        public static Vector<float> Sin(Vector<float> vector);
+        public static (Vector<double> Sin, Vector<double> Cos) SinCos(Vector<double> vector);
+        public static (Vector<float> Sin, Vector<float> Cos) SinCos(Vector<float> vector);
+        public static Vector<double> Truncate(Vector<double> vector);
+        public static Vector<float> Truncate(Vector<float> vector);
     }
     public struct Vector2 : IEquatable<Vector2>, IFormattable {
+        public static Vector2 E { get; }
+        public static Vector2 Epsilon { get; }
+        public static Vector2 NaN { get; }
+        public static Vector2 NegativeInfinity { get; }
+        public static Vector2 NegativeZero { get; }
+        public static Vector2 Pi { get; }
+        public static Vector2 PositiveInfinity { get; }
+        public static Vector2 Tau { get; }
+        public static Vector2 ClampNative(Vector2 value1, Vector2 min, Vector2 max);
+        public static Vector2 CopySign(Vector2 value, Vector2 sign);
+        public static Vector2 Cos(Vector2 vector);
+        public static Vector2 DegreesToRadians(Vector2 degrees);
+        public static Vector2 Exp(Vector2 vector);
+        public static Vector2 Hypot(Vector2 x, Vector2 y);
+        public static Vector2 Lerp(Vector2 value1, Vector2 value2, Vector2 amount);
+        public static Vector2 Log(Vector2 vector);
+        public static Vector2 Log2(Vector2 vector);
+        public static Vector2 MaxMagnitude(Vector2 value1, Vector2 value2);
+        public static Vector2 MaxMagnitudeNumber(Vector2 value1, Vector2 value2);
+        public static Vector2 MaxNative(Vector2 value1, Vector2 value2);
+        public static Vector2 MaxNumber(Vector2 value1, Vector2 value2);
+        public static Vector2 MinMagnitude(Vector2 value1, Vector2 value2);
+        public static Vector2 MinMagnitudeNumber(Vector2 value1, Vector2 value2);
+        public static Vector2 MinNative(Vector2 value1, Vector2 value2);
+        public static Vector2 MinNumber(Vector2 value1, Vector2 value2);
+        public static Vector2 RadiansToDegrees(Vector2 radians);
+        public static Vector2 Round(Vector2 vector);
+        public static Vector2 Round(Vector2 vector, MidpointRounding mode);
+        public static Vector2 Sin(Vector2 vector);
+        public static (Vector2 Sin, Vector2 Cos) SinCos(Vector2 vector);
+        public static Vector2 Truncate(Vector2 vector);
     }
     public struct Vector3 : IEquatable<Vector3>, IFormattable {
+        public static Vector3 E { get; }
+        public static Vector3 Epsilon { get; }
+        public static Vector3 NaN { get; }
+        public static Vector3 NegativeInfinity { get; }
+        public static Vector3 NegativeZero { get; }
+        public static Vector3 Pi { get; }
+        public static Vector3 PositiveInfinity { get; }
+        public static Vector3 Tau { get; }
+        public static Vector3 ClampNative(Vector3 value1, Vector3 min, Vector3 max);
+        public static Vector3 CopySign(Vector3 value, Vector3 sign);
+        public static Vector3 Cos(Vector3 vector);
+        public static Vector3 DegreesToRadians(Vector3 degrees);
+        public static Vector3 Exp(Vector3 vector);
+        public static Vector3 Hypot(Vector3 x, Vector3 y);
+        public static Vector3 Lerp(Vector3 value1, Vector3 value2, Vector3 amount);
+        public static Vector3 Log(Vector3 vector);
+        public static Vector3 Log2(Vector3 vector);
+        public static Vector3 MaxMagnitude(Vector3 value1, Vector3 value2);
+        public static Vector3 MaxMagnitudeNumber(Vector3 value1, Vector3 value2);
+        public static Vector3 MaxNative(Vector3 value1, Vector3 value2);
+        public static Vector3 MaxNumber(Vector3 value1, Vector3 value2);
+        public static Vector3 MinMagnitude(Vector3 value1, Vector3 value2);
+        public static Vector3 MinMagnitudeNumber(Vector3 value1, Vector3 value2);
+        public static Vector3 MinNative(Vector3 value1, Vector3 value2);
+        public static Vector3 MinNumber(Vector3 value1, Vector3 value2);
+        public static Vector3 RadiansToDegrees(Vector3 radians);
+        public static Vector3 Round(Vector3 vector);
+        public static Vector3 Round(Vector3 vector, MidpointRounding mode);
+        public static Vector3 Sin(Vector3 vector);
+        public static (Vector3 Sin, Vector3 Cos) SinCos(Vector3 vector);
+        public static Vector3 Truncate(Vector3 vector);
     }
     public struct Vector4 : IEquatable<Vector4>, IFormattable {
+        public static Vector4 E { get; }
+        public static Vector4 Epsilon { get; }
+        public static Vector4 NaN { get; }
+        public static Vector4 NegativeInfinity { get; }
+        public static Vector4 NegativeZero { get; }
+        public static Vector4 Pi { get; }
+        public static Vector4 PositiveInfinity { get; }
+        public static Vector4 Tau { get; }
+        public static Vector4 ClampNative(Vector4 value1, Vector4 min, Vector4 max);
+        public static Vector4 CopySign(Vector4 value, Vector4 sign);
+        public static Vector4 Cos(Vector4 vector);
+        public static Vector4 DegreesToRadians(Vector4 degrees);
+        public static Vector4 Exp(Vector4 vector);
+        public static Vector4 Hypot(Vector4 x, Vector4 y);
+        public static Vector4 Lerp(Vector4 value1, Vector4 value2, Vector4 amount);
+        public static Vector4 Log(Vector4 vector);
+        public static Vector4 Log2(Vector4 vector);
+        public static Vector4 MaxMagnitude(Vector4 value1, Vector4 value2);
+        public static Vector4 MaxMagnitudeNumber(Vector4 value1, Vector4 value2);
+        public static Vector4 MaxNative(Vector4 value1, Vector4 value2);
+        public static Vector4 MaxNumber(Vector4 value1, Vector4 value2);
+        public static Vector4 MinMagnitude(Vector4 value1, Vector4 value2);
+        public static Vector4 MinMagnitudeNumber(Vector4 value1, Vector4 value2);
+        public static Vector4 MinNative(Vector4 value1, Vector4 value2);
+        public static Vector4 MinNumber(Vector4 value1, Vector4 value2);
+        public static Vector4 RadiansToDegrees(Vector4 radians);
+        public static Vector4 Round(Vector4 vector);
+        public static Vector4 Round(Vector4 vector, MidpointRounding mode);
+        public static Vector4 Sin(Vector4 vector);
+        public static (Vector4 Sin, Vector4 Cos) SinCos(Vector4 vector);
+        public static Vector4 Truncate(Vector4 vector);
     }
 }
```

